/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.model.JavaToKotlinHandler;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    private static final String PROPERTIES_RENDER_LANGUAGE_KEY = "SAVED_RENDER_LANGUAGE";
    @NotNull
    private final String myCommandName;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ObjectProperty<NamedModuleTemplate> myTemplates;
    @NotNull
    private final ObjectProperty<com.android.tools.idea.npw.platform.Language> myLanguageSet;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
    @NotNull
    private final StringProperty myProjectLocation;
    @NotNull
    private final StringProperty myModuleName;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final BoolProperty myInstantApp;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    @Nullable
    private final AndroidFacet myFacet;
    @NotNull
    private final List<File> myCreatedFiles = new ArrayList<File>();
    private final boolean myShouldOpenFiles;
    @Nullable
    private TemplateHandle myTemplateHandle;
    @NotNull
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    @Nullable
    private IconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull AndroidFacet facet, @Nullable TemplateHandle templateHandle, @NotNull String initialPackageSuggestion, @NotNull NamedModuleTemplate template, @NotNull String commandName, @NotNull ProjectSyncInvoker projectSyncInvoker, boolean shouldOpenFiles) {
        Project project = facet.getModule().getProject();
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myFacet = facet;
        this.myInstantApp = new BoolValueProperty(false);
        this.myProjectLocation = new StringValueProperty(project.getBasePath());
        this.myModuleName = new StringValueProperty(facet.getModule().getName());
        this.myPackageName = new StringValueProperty(initialPackageSuggestion);
        this.myTemplates = new ObjectValueProperty<NamedModuleTemplate>(template);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = new MultiTemplateRenderer(project, projectSyncInvoker);
        this.myLanguageSet = new ObjectValueProperty<com.android.tools.idea.npw.platform.Language>(RenderTemplateModel.getInitialSourceLanguage(project));
        this.myShouldOpenFiles = shouldOpenFiles;
        this.init();
    }

    public RenderTemplateModel(@NotNull NewModuleModel moduleModel, @Nullable TemplateHandle templateHandle, @NotNull NamedModuleTemplate template, @NotNull String commandName) {
        this.myProject = moduleModel.getProject();
        this.myFacet = null;
        this.myInstantApp = moduleModel.instantApp();
        this.myProjectLocation = moduleModel.projectLocation();
        this.myModuleName = moduleModel.moduleName();
        this.myPackageName = moduleModel.packageName();
        this.myTemplates = new ObjectValueProperty<NamedModuleTemplate>(template);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = moduleModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.incrementRenders();
        this.myLanguageSet = new ObjectValueProperty<com.android.tools.idea.npw.platform.Language>(RenderTemplateModel.getInitialSourceLanguage(this.myProject.getValueOrNull()));
        this.myShouldOpenFiles = true;
        this.init();
    }

    private void init() {
        this.myLanguageSet.addListener(() -> RenderTemplateModel.setInitialSourceLanguage((com.android.tools.idea.npw.platform.Language)((Object)((Object)this.myLanguageSet.get()))));
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    @Nullable
    public Module getModule() {
        return this.myFacet == null ? null : this.myFacet.getModule();
    }

    @Nullable
    public AndroidFacet getAndroidFacet() {
        return this.myFacet;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    @NotNull
    public ObjectProperty<NamedModuleTemplate> getTemplate() {
        return this.myTemplates;
    }

    @NotNull
    public ObjectProperty<com.android.tools.idea.npw.platform.Language> getLanguage() {
        return this.myLanguageSet;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public BoolProperty instantApp() {
        return this.myInstantApp;
    }

    public void setTemplateHandle(@Nullable TemplateHandle templateHandle) {
        this.myTemplateHandle = templateHandle;
    }

    @Nullable
    public TemplateHandle getTemplateHandle() {
        return this.myTemplateHandle;
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        return this.myProject;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public List<File> getCreatedFiles() {
        return this.myCreatedFiles;
    }

    public void setIconGenerator(@NotNull IconGenerator iconGenerator) {
        this.myIconGenerator = iconGenerator;
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new FreeMarkerTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    private VirtualFile toScratchFile(@Nullable Project project) {
        StringBuilder templateVars = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        for (Map.Entry<String, Object> entry : this.myTemplateValues.entrySet()) {
            templateVars.append(entry.getKey()).append("=").append(entry.getValue()).append(lineSeparator);
        }
        return ScratchRootType.getInstance().createScratchFile(project, "templateVars.txt", (Language)PlainTextLanguage.INSTANCE, templateVars.toString(), ScratchFileService.Option.create_new_always);
    }

    @NotNull
    static com.android.tools.idea.npw.platform.Language getInitialSourceLanguage(@Nullable Project project) {
        if (project != null && AndroidStudioKotlinPluginUtils.hasAnyKotlinModules(project)) {
            return com.android.tools.idea.npw.platform.Language.fromName(PropertiesComponent.getInstance().getValue(PROPERTIES_RENDER_LANGUAGE_KEY), com.android.tools.idea.npw.platform.Language.KOTLIN);
        }
        return com.android.tools.idea.npw.platform.Language.JAVA;
    }

    private static void setInitialSourceLanguage(@NotNull com.android.tools.idea.npw.platform.Language language) {
        PropertiesComponent.getInstance().setValue(PROPERTIES_RENDER_LANGUAGE_KEY, language.getName());
    }

    private class FreeMarkerTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private FreeMarkerTemplateRenderer() {
        }

        @Override
        public void init() {
            AndroidModuleTemplate paths2 = ((NamedModuleTemplate)RenderTemplateModel.this.myTemplates.get()).getPaths();
            File moduleRoot = paths2.getModuleRoot();
            if (moduleRoot == null) {
                RenderTemplateModel.getLog().error("RenderTemplateModel can't create files because module root is not found. Please report this error.");
                return;
            }
            RenderTemplateModel.this.myTemplateValues.put("sourceProviderName", ((NamedModuleTemplate)RenderTemplateModel.this.myTemplates.get()).getName());
            if (RenderTemplateModel.this.getModule() == null) {
                RenderTemplateModel.this.myTemplateValues.put("isLauncher", true);
            }
            TemplateValueInjector templateInjector = new TemplateValueInjector(RenderTemplateModel.this.myTemplateValues).setModuleRoots(paths2, (String)RenderTemplateModel.this.myProjectLocation.get(), (String)RenderTemplateModel.this.myModuleName.get(), (String)RenderTemplateModel.this.packageName().get());
            if (RenderTemplateModel.this.myFacet == null) {
                templateInjector.setBuildVersion(RenderTemplateModel.this.androidSdkInfo().getValue(), RenderTemplateModel.this.getProject().getValueOrNull());
            } else {
                templateInjector.setFacet(RenderTemplateModel.this.myFacet);
                templateInjector.setLanguage((com.android.tools.idea.npw.platform.Language)((Object)RenderTemplateModel.this.myLanguageSet.get()));
                String applicationPackage = AndroidPackageUtils.getPackageForApplication(RenderTemplateModel.this.myFacet);
                if (!((String)RenderTemplateModel.this.packageName().get()).equals(applicationPackage)) {
                    RenderTemplateModel.this.myTemplateValues.put("applicationPackage", AndroidPackageUtils.getPackageForApplication(RenderTemplateModel.this.myFacet));
                }
            }
        }

        @Override
        public boolean doDryRun() {
            if (!((Optional)RenderTemplateModel.this.myProject.get()).isPresent() || RenderTemplateModel.this.myTemplateHandle == null) {
                RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            AndroidModuleTemplate paths2 = ((NamedModuleTemplate)RenderTemplateModel.this.myTemplates.get()).getPaths();
            Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            return this.renderTemplate(true, project, paths2, null, null);
        }

        @Override
        public void render() {
            final AndroidModuleTemplate paths2 = ((NamedModuleTemplate)RenderTemplateModel.this.myTemplates.get()).getPaths();
            final Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            final ArrayList filesToReformat = Lists.newArrayList();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, RenderTemplateModel.this.myCommandName, new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result2) {
                    boolean success = FreeMarkerTemplateRenderer.this.renderTemplate(false, project, paths2, RenderTemplateModel.this.myCreatedFiles, filesToReformat);
                    if (success && RenderTemplateModel.this.myIconGenerator != null) {
                        RenderTemplateModel.this.myIconGenerator.generateIconsToDisk(paths2);
                    }
                    result2.setResult((Object)success);
                }
            }.execute().getResultObject();
            if (success) {
                if (this.isKotlinTemplate()) {
                    JavaToKotlinHandler.convertJavaFilesToKotlin(project, filesToReformat, () -> {
                        for (int i2 = 0; i2 < RenderTemplateModel.this.myCreatedFiles.size(); ++i2) {
                            File file = (File)RenderTemplateModel.this.myCreatedFiles.get(i2);
                            if (!file.getName().endsWith(".java")) continue;
                            File ktFile = new File(file.getParent(), file.getName().replace(".java", ".kt"));
                            RenderTemplateModel.this.myCreatedFiles.set(i2, ktFile);
                        }
                        if (RenderTemplateModel.this.myShouldOpenFiles) {
                            TemplateUtils.openEditors(project, RenderTemplateModel.this.myCreatedFiles, true);
                        }
                    });
                } else if (RenderTemplateModel.this.myShouldOpenFiles) {
                    DumbService.getInstance((Project)project).smartInvokeLater(() -> TemplateUtils.openEditors(project, RenderTemplateModel.this.myCreatedFiles, true));
                }
            }
        }

        private boolean isKotlinTemplate() {
            return RenderTemplateModel.this.myTemplateValues.getOrDefault("includeKotlinSupport", false);
        }

        private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull AndroidModuleTemplate paths2, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
            VirtualFile result2;
            Template template = RenderTemplateModel.this.myTemplateHandle.getTemplate();
            File moduleRoot = paths2.getModuleRoot();
            if (moduleRoot == null) {
                return false;
            }
            if (!dryRun && ((Boolean)StudioFlags.NPW_DUMP_TEMPLATE_VARS.get()).booleanValue() && filesToOpen != null && (result2 = RenderTemplateModel.this.toScratchFile(project)) != null) {
                filesToOpen.add(VfsUtilCore.virtualToIoFile((VirtualFile)result2));
            }
            if (((Boolean)StudioFlags.SHIPPED_SYNC_ENABLED.get()).booleanValue()) {
                RenderTemplateModel.this.myTemplateValues.put("activityTemplateName", StringUtils.deleteWhitespace((String)template.getMetadata().getTitle()));
            }
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(RenderTemplateModel.this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModuleRoot(paths2.getModuleRoot()).withModule(RenderTemplateModel.this.getModule()).withParams(RenderTemplateModel.this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
            return template.render(context, dryRun);
        }
    }
}

