/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public final class AndroidApiLevelComboBox
extends JComboBox<AndroidVersionsInfo.VersionItem> {
    private final ItemListener myItemListener = this::saveSelectedApi;
    private FormFactor myFormFactor;

    public void init(@NotNull FormFactor formFactor, @NotNull List<AndroidVersionsInfo.VersionItem> items2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFormFactor = formFactor;
        this.setName(this.myFormFactor.id + ".minSdk");
        Object selectedItem = this.getSelectedItem();
        this.removeItemListener(this.myItemListener);
        this.removeAllItems();
        for (AndroidVersionsInfo.VersionItem item : items2) {
            this.addItem(item);
        }
        this.setSelectedItem(selectedItem);
        if (this.getSelectedItem() == null) {
            this.loadSavedApi();
        }
        this.addItemListener(this.myItemListener);
    }

    private void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(AndroidApiLevelComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        int index = this.getItemCount() - 1;
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)this.getItemAt(i2);
            if (!Objects.equal((Object)item.getMinApiLevelStr(), (Object)savedApiLevel)) continue;
            index = i2;
            break;
        }
        this.setSelectedIndex(index);
    }

    private void saveSelectedApi(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getItem() != null) {
            AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)e.getItem();
            PropertiesComponent.getInstance().setValue(AndroidApiLevelComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), item.getMinApiLevelStr());
        }
    }

    @VisibleForTesting
    static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        return formFactor.id + "minApi";
    }
}

