/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppNameToModuleNameExpression
extends Expression<String> {
    @Nullable
    private final Project myProject;
    @NotNull
    private final StringProperty myApplicationName;

    public AppNameToModuleNameExpression(@Nullable Project project, @NotNull StringProperty applicationName) {
        super(applicationName);
        this.myProject = project;
        this.myApplicationName = applicationName;
    }

    @Override
    @NotNull
    public String get() {
        String moduleName = ((String)this.myApplicationName.get()).toLowerCase(Locale.US).replaceAll("\\s", "");
        int i2 = 2;
        String uniqueModuleName = moduleName;
        while (!AppNameToModuleNameExpression.isUniqueModuleName(uniqueModuleName, this.myProject)) {
            uniqueModuleName = moduleName + Integer.toString(i2);
            ++i2;
        }
        return uniqueModuleName;
    }

    private static boolean isUniqueModuleName(@NotNull String moduleName, @Nullable Project project) {
        if (project == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }
}

