/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.ui.WizardGallery;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends ModelWizardStep.WithoutModel {
    public static final String ANDROID_AUTOMOTIVE_MODULE_NAME = "Automotive Module";
    public static final String ANDROID_WEAR_MODULE_NAME = "Wear OS Module";
    public static final String ANDROID_TV_MODULE_NAME = "Android TV Module";
    public static final String ANDROID_THINGS_MODULE_NAME = "Android Things Module";
    public static final String JAVA_LIBRARY_MODULE_NAME = "Java Library";
    public static final String GOOGLE_CLOUD_MODULE_NAME = "Google Cloud Module";
    private final List<ModuleGalleryEntry> myModuleGalleryEntryList;
    private final ProjectSyncInvoker myProjectSyncInvoker;
    private final JComponent myRootPanel;
    private final Project myProject;
    private ASGallery<ModuleGalleryEntry> myFormFactorGallery;
    private Map<ModuleGalleryEntry, SkippableWizardStep> myModuleDescriptionToStepMap;

    public ChooseModuleTypeStep(@NotNull Project project, @NotNull List<ModuleGalleryEntry> moduleGalleryEntries, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        super(AndroidBundle.message("android.wizard.module.new.module.header", new Object[0]));
        this.myProject = project;
        this.myModuleGalleryEntryList = ChooseModuleTypeStep.sortModuleEntries(moduleGalleryEntries);
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myRootPanel = this.createGallery();
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @NotNull
    public static ChooseModuleTypeStep createWithDefaultGallery(Project project, ProjectSyncInvoker projectSyncInvoker) {
        ArrayList<ModuleGalleryEntry> moduleDescriptions = new ArrayList<ModuleGalleryEntry>();
        for (ModuleDescriptionProvider provider : (ModuleDescriptionProvider[])ModuleDescriptionProvider.EP_NAME.getExtensions()) {
            moduleDescriptions.addAll(provider.getDescriptions(project));
        }
        return new ChooseModuleTypeStep(project, moduleDescriptions, projectSyncInvoker);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap<ModuleGalleryEntry, SkippableWizardStep>();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            NewModuleModel model2 = new NewModuleModel(this.myProject, this.myProjectSyncInvoker);
            if (moduleGalleryEntry instanceof ModuleTemplateGalleryEntry) {
                ModuleTemplateGalleryEntry templateEntry = (ModuleTemplateGalleryEntry)moduleGalleryEntry;
                model2.isLibrary().set(templateEntry.isLibrary());
                model2.instantApp().set(templateEntry.isInstantApp());
                model2.templateFile().setValue(templateEntry.getTemplateFile());
            }
            SkippableWizardStep step = moduleGalleryEntry.createStep(model2);
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        return allSteps;
    }

    @NotNull
    private JComponent createGallery() {
        this.myFormFactorGallery = new WizardGallery<ModuleGalleryEntry>(this.getTitle(), galEntry -> galEntry.getIcon() == null ? null : galEntry.getIcon(), galEntry -> galEntry == null ? AndroidBundle.message("android.wizard.gallery.item.none", new Object[0]) : galEntry.getName());
        return new JBScrollPane(this.myFormFactorGallery);
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        this.myFormFactorGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myFormFactorGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myFormFactorGallery.setSelectedIndex(0);
    }

    @Override
    protected void onProceeding() {
        ModuleGalleryEntry selectedEntry = (ModuleGalleryEntry)this.myFormFactorGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> step.setShouldShow(galleryEntry == selectedEntry));
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorGallery;
    }

    @VisibleForTesting
    @NotNull
    static List<ModuleGalleryEntry> sortModuleEntries(@NotNull List<ModuleGalleryEntry> moduleTypesProviders) {
        String[] orderedNames = new String[]{AndroidBundle.message("android.wizard.module.new.mobile", new Object[0]), AndroidBundle.message("android.wizard.module.new.library", new Object[0]), AndroidBundle.message("android.wizard.module.new.dynamic.module", new Object[0]), AndroidBundle.message("android.wizard.module.new.dynamic.module.instant", new Object[0]), AndroidBundle.message("android.wizard.module.new.instant.app", new Object[0]), AndroidBundle.message("android.wizard.module.new.feature.module", new Object[0]), ANDROID_AUTOMOTIVE_MODULE_NAME, ANDROID_WEAR_MODULE_NAME, ANDROID_TV_MODULE_NAME, ANDROID_THINGS_MODULE_NAME, AndroidBundle.message("android.wizard.module.import.gradle.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.eclipse.title", new Object[0]), AndroidBundle.message("android.wizard.module.import.title", new Object[0]), JAVA_LIBRARY_MODULE_NAME, GOOGLE_CLOUD_MODULE_NAME, AndroidBundle.message("android.wizard.module.new.benchmark.module.app", new Object[0])};
        Map<String, ModuleGalleryEntry> entryMap = moduleTypesProviders.stream().collect(Collectors.toMap(ModuleGalleryEntry::getName, c -> c));
        ArrayList<ModuleGalleryEntry> result2 = new ArrayList<ModuleGalleryEntry>();
        for (String name : orderedNames) {
            ModuleGalleryEntry entry = entryMap.remove(name);
            if (entry == null) continue;
            result2.add(entry);
        }
        ArrayList<ModuleGalleryEntry> secondHalf = new ArrayList<ModuleGalleryEntry>(entryMap.values());
        Collections.sort(secondHalf, Comparator.comparing(ModuleGalleryEntry::getName));
        result2.addAll(secondHalf);
        return result2;
    }
}

