/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewAndroidModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleTemplateGalleryEntry> getDescriptions(Project project) {
        ArrayList<ModuleTemplateGalleryEntry> res = new ArrayList<ModuleTemplateGalleryEntry>();
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null) continue;
            int minSdk = metadata.getMinSdk();
            FormFactor formFactor = FormFactor.get(metadata.getFormFactor());
            if (formFactor == FormFactor.CAR || formFactor == FormFactor.AUTOMOTIVE && !((Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get()).booleanValue() || formFactor == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            if (formFactor.equals((Object)FormFactor.MOBILE)) {
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, NewAndroidModuleDescriptionProvider.getModuleTypeIcon(templateFile), AndroidBundle.message("android.wizard.module.new.mobile", new Object[0]), metadata.getTitle()));
                File androidProjectTemplate = TemplateManager.getInstance().getTemplateFile("Application", "Android Project");
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, true, NewAndroidModuleDescriptionProvider.getModuleTypeIcon(androidProjectTemplate), AndroidBundle.message("android.wizard.module.new.library", new Object[0]), metadata.getDescription()));
                continue;
            }
            res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, NewAndroidModuleDescriptionProvider.getModuleTypeIcon(templateFile), metadata.getTitle(), metadata.getDescription()));
        }
        return res;
    }

    private static Icon getModuleTypeIcon(@NotNull File templateFile) {
        return ActivityGallery.getTemplateIcon(new TemplateHandle(templateFile), false);
    }

    private static class AndroidModuleTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        private final File myTemplateFile;
        private final FormFactor myFormFactor;
        private final int myMinSdkLevel;
        private final boolean myIsLibrary;
        private final Icon myIcon;
        private final String myName;
        private final String myDescription;

        AndroidModuleTemplateGalleryEntry(File templateFile, FormFactor formFactor, int minSdkLevel, boolean isLibrary, Icon icon2, String name, String description) {
            this.myTemplateFile = templateFile;
            this.myFormFactor = formFactor;
            this.myMinSdkLevel = minSdkLevel;
            this.myIsLibrary = isLibrary;
            this.myIcon = icon2;
            this.myName = name;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            return this.myTemplateFile;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            return this.myFormFactor;
        }

        @Override
        public boolean isLibrary() {
            return this.myIsLibrary;
        }

        @Override
        public boolean isInstantApp() {
            return false;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            String basePackage = NewProjectModel.getSuggestedProjectPackage(model2.getProject().getValue(), false);
            return new ConfigureAndroidModuleStep(model2, this.myFormFactor, this.myMinSdkLevel, basePackage, this.isLibrary(), false, this.myName);
        }
    }
}

