/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVersionsInfo {
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AndroidVersionsInfo.class);
    private static final IdDisplay NO_MATCH = IdDisplay.create((String)"no_match", (String)"No Match");
    private final List<VersionItem> myKnownTargetVersions = Lists.newArrayList();
    private final Set<AndroidVersion> myInstalledVersions = Sets.newHashSet();
    private IAndroidTarget myHighestInstalledApiTarget;

    public void loadLocalVersions() {
        this.loadLocalTargetVersions();
        this.loadInstalledVersions();
    }

    @NotNull
    public List<VersionItem> getKnownTargetVersions(@NotNull FormFactor formFactor, int minSdkLevel) {
        ArrayList<VersionItem> versionItemList = new ArrayList<VersionItem>();
        minSdkLevel = Math.max(minSdkLevel, formFactor.getMinOfflineApiLevel());
        for (VersionItem target : this.myKnownTargetVersions) {
            if (!AndroidVersionsInfo.isFormFactorAvailable(formFactor, minSdkLevel, target.getMinApiLevel()) && (target.getAndroidTarget() == null || !target.getAndroidTarget().getVersion().isPreview())) continue;
            versionItemList.add(target);
        }
        return versionItemList;
    }

    private void loadInstalledVersions() {
        this.myInstalledVersions.clear();
        IAndroidTarget highestInstalledTarget = null;
        for (IAndroidTarget target : AndroidVersionsInfo.loadInstalledCompilationTargets()) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myInstalledVersions.add(target.getVersion());
        }
        this.myHighestInstalledApiTarget = highestInstalledTarget;
    }

    @Nullable(value="If we don't know (yet) the highest installed version")
    AndroidVersion getHighestInstalledVersion() {
        return this.myHighestInstalledApiTarget == null ? null : this.myHighestInstalledApiTarget.getVersion();
    }

    @Nullable
    public static File getSdkManagerLocalPath() {
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @NotNull
    public List<UpdatablePackage> loadInstallPackageList(@NotNull List<VersionItem> installItems) {
        HashSet requestedPaths = Sets.newHashSet();
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        requestedPaths.add(DetailsTypes.getBuildToolsPath((Revision)GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, REPO_LOG)));
        for (VersionItem versionItem : installItems) {
            AndroidVersion androidVersion = versionItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            if (versionItem.myAddon != null) {
                requestedPaths.add(versionItem.myAddon.getPath());
                AndroidTargetManager targetManager = sdkHandler.getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) != null) continue;
                requestedPaths.add(platformPath);
                continue;
            }
            if (this.myHighestInstalledApiTarget != null && (androidVersion.getApiLevel() <= this.myHighestInstalledApiTarget.getVersion().getApiLevel() || this.myInstalledVersions.contains(androidVersion))) continue;
            requestedPaths.add(DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(28, null)));
        }
        return AndroidVersionsInfo.getPackageList(requestedPaths, sdkHandler);
    }

    public void loadRemoteTargetVersions(@NotNull FormFactor formFactor, int minSdkLevel, @NotNull ItemsLoaded itemsLoadedCallback) {
        minSdkLevel = Math.max(minSdkLevel, formFactor.getMinOfflineApiLevel());
        List<VersionItem> versionItemList = this.getKnownTargetVersions(formFactor, minSdkLevel);
        this.loadRemoteTargetVersions(formFactor, minSdkLevel, versionItemList, itemsLoadedCallback);
    }

    private void loadLocalTargetVersions() {
        this.myKnownTargetVersions.clear();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i2 = 0; i2 < knownVersions.length; ++i2) {
                this.myKnownTargetVersions.add(new VersionItem(knownVersions[i2], i2 + 1));
            }
        }
        for (IAndroidTarget target : AndroidVersionsInfo.loadInstalledCompilationTargets()) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myKnownTargetVersions.add(new VersionItem(target));
        }
    }

    @NotNull
    private static IAndroidTarget[] loadInstalledCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result2 = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform() && target.getAdditionalLibraries().isEmpty()) continue;
            result2.add(target);
        }
        return result2.toArray(new IAndroidTarget[0]);
    }

    private void loadRemoteTargetVersions(@NotNull FormFactor myFormFactor, int minSdkLevel, @NotNull List<VersionItem> versionItemList, ItemsLoaded completedCallback) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Runnable runCallbacks = () -> {
            if (completedCallback != null) {
                completedCallback.onDataLoadedFinished(versionItemList);
            }
        };
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            this.addPackages(myFormFactor, versionItemList, packages.getNewPkgs(), minSdkLevel);
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        }, ModalityState.any());
        RepoManager.RepoLoadedCallback onLocalComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> this.addPackages(myFormFactor, versionItemList, packages.getLocalPackages().values(), minSdkLevel), ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> {
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        }, ModalityState.any());
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Refreshing Targets", null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @NotNull
    private static List<UpdatablePackage> getPackageList(@NotNull Collection<String> requestedPaths, @NotNull AndroidSdkHandler sdkHandler) {
        ArrayList<UpdatablePackage> requestedPackages = new ArrayList<UpdatablePackage>();
        RepositoryPackages packages = sdkHandler.getSdkManager(REPO_LOG).getPackages();
        Map consolidated = packages.getConsolidatedPkgs();
        for (String path : requestedPaths) {
            UpdatablePackage p = (UpdatablePackage)consolidated.get(path);
            if (p == null || !p.hasRemote()) continue;
            requestedPackages.add(p);
        }
        ArrayList<UpdatablePackage> resolvedPackages = new ArrayList();
        try {
            resolvedPackages = SdkQuickfixUtils.resolve(requestedPackages, packages);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            REPO_LOG.logError("Error Resolving Packages", (Throwable)e);
        }
        return resolvedPackages;
    }

    private static boolean filterPkgDesc(@NotNull RepoPackage p, @NotNull FormFactor formFactor, int minSdkLevel) {
        return AndroidVersionsInfo.isApiType(p) && AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, AndroidVersionsInfo.getTag(p), AndroidVersionsInfo.getFeatureLevel(p));
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable IdDisplay tag, int targetSdkLevel) {
        return formFactor.isSupported(tag, targetSdkLevel) && targetSdkLevel >= minSdkLevel;
    }

    private static boolean isApiType(@NotNull RepoPackage repoPackage) {
        return repoPackage.getTypeDetails() instanceof DetailsTypes.ApiDetailsType;
    }

    private static int getFeatureLevel(@NotNull RepoPackage repoPackage) {
        return AndroidVersionsInfo.getAndroidVersion(repoPackage).getFeatureLevel();
    }

    private static boolean isFormFactorAvailable(@NotNull FormFactor formFactor, int minSdkLevel, int targetSdkLevel) {
        return AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, SystemImage.DEFAULT_TAG, targetSdkLevel);
    }

    @NotNull
    private static AndroidVersion getAndroidVersion(@NotNull RepoPackage repoPackage) {
        TypeDetails details = repoPackage.getTypeDetails();
        if (details instanceof DetailsTypes.ApiDetailsType) {
            return ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
        }
        throw new RuntimeException("Could not determine version");
    }

    @Nullable
    private static IdDisplay getTag(@NotNull RepoPackage repoPackage) {
        DetailsTypes.SysImgDetailsType imgDetailsType;
        TypeDetails details = repoPackage.getTypeDetails();
        IdDisplay tag = NO_MATCH;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            tag = ((DetailsTypes.AddonDetailsType)details).getTag();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType && (imgDetailsType = (DetailsTypes.SysImgDetailsType)details).getAbi().equals("x86")) {
            tag = imgDetailsType.getTag();
        }
        return tag;
    }

    private void addPackages(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList, @NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        List sorted = packages.stream().filter(repoPackage -> repoPackage != null && AndroidVersionsInfo.filterPkgDesc(repoPackage, myFormFactor, minSdkLevel)).collect(Collectors.toList());
        sorted.sort(Comparator.comparing(AndroidVersionsInfo::getAndroidVersion));
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = AndroidVersionsInfo.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myMinApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(info));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList) {
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = myFormFactor.getMinOfflineApiLevel(); apiLevel <= myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (myFormFactor.isSupported(null, apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myMinApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(apiLevel));
            prevInsertedApiLevel = apiLevel;
        }
    }

    public class VersionItem {
        private final AndroidVersion myAndroidVersion;
        private final String myLabel;
        private final int myMinApiLevel;
        private final String myMinApiLevelStr;
        private IAndroidTarget myAndroidTarget;
        private RemotePackage myAddon;

        VersionItem(@NotNull AndroidVersion androidVersion, @Nullable IdDisplay tag, IAndroidTarget target) {
            this.myAndroidVersion = androidVersion;
            this.myLabel = this.getLabel(androidVersion, tag, target);
            this.myAndroidTarget = target;
            this.myMinApiLevel = androidVersion.getFeatureLevel();
            this.myMinApiLevelStr = androidVersion.getApiString();
        }

        VersionItem(String label, int minApiLevel) {
            this.myAndroidVersion = new AndroidVersion(minApiLevel, null);
            this.myLabel = label;
            this.myMinApiLevel = minApiLevel;
            this.myMinApiLevelStr = Integer.toString(minApiLevel);
        }

        VersionItem(int minApiLevel) {
            this(new AndroidVersion(minApiLevel, null), SystemImage.DEFAULT_TAG, null);
        }

        public VersionItem(IAndroidTarget target) {
            this(target.getVersion(), SystemImage.DEFAULT_TAG, target);
        }

        VersionItem(RepoPackage info) {
            this(AndroidVersionsInfo.getAndroidVersion(info), AndroidVersionsInfo.getTag(info), null);
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)AndroidVersionsInfo.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        @Nullable(value="null except for preview releases")
        public IAndroidTarget getAndroidTarget() {
            return this.myAndroidTarget;
        }

        @Nullable(value="null except when an addon needs to be installed (eg Google Glass)")
        public RemotePackage getAddon() {
            return this.myAddon;
        }

        public int getMinApiLevel() {
            return this.myMinApiLevel;
        }

        @NotNull
        public String getMinApiLevelStr() {
            return this.myMinApiLevelStr;
        }

        public int getBuildApiLevel() {
            int apiLevel = this.myAddon != null || this.myAndroidTarget != null && (this.myAndroidTarget.getVersion().isPreview() || !this.myAndroidTarget.isPlatform()) ? this.myMinApiLevel : (AndroidVersionsInfo.this.getHighestInstalledVersion() != null && AndroidVersionsInfo.this.getHighestInstalledVersion().getFeatureLevel() > 28 ? AndroidVersionsInfo.this.getHighestInstalledVersion().getFeatureLevel() : 28);
            return apiLevel;
        }

        @NotNull
        public String getBuildApiLevelStr() {
            if (this.myAndroidTarget == null) {
                return Integer.toString(this.getBuildApiLevel());
            }
            if (this.myAndroidTarget.isPlatform()) {
                return TemplateMetadata.getBuildApiString(this.myAndroidTarget.getVersion());
            }
            return AndroidTargetHash.getTargetHashString((IAndroidTarget)this.myAndroidTarget);
        }

        public int getTargetApiLevel() {
            return this.getBuildApiLevel();
        }

        @NotNull
        public String getTargetApiLevelStr() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 29 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                return this.myAndroidTarget == null ? Integer.toString(buildApiLevel) : this.myAndroidTarget.getVersion().getApiString();
            }
            AndroidVersion installedVersion = AndroidVersionsInfo.this.getHighestInstalledVersion();
            if (installedVersion != null && installedVersion.getFeatureLevel() == buildApiLevel) {
                return installedVersion.getApiString();
            }
            return Integer.toString(buildApiLevel);
        }

        @NotNull
        public String getLabel() {
            return this.myLabel;
        }

        public boolean equals(Object obj) {
            return obj instanceof VersionItem && ((VersionItem)obj).getLabel().equals(this.getLabel());
        }

        public int hashCode() {
            return this.getLabel().hashCode();
        }

        @NotNull
        private String getLabel(@NotNull AndroidVersion version2, @Nullable IdDisplay tag, @Nullable IAndroidTarget target) {
            int featureLevel = version2.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                return String.format(Locale.US, "Glass Development Kit Preview (API %1$d)", featureLevel);
            }
            if (featureLevel <= 29) {
                if (version2.isPreview()) {
                    return String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                }
                if (target == null || target.isPlatform()) {
                    return SdkVersionInfo.getAndroidName((int)featureLevel);
                }
                if (!StringUtil.isEmptyOrSpaces((String)target.getDescription())) {
                    return String.format(Locale.US, "API %1$d: %2$s", featureLevel, target.getDescription());
                }
                return AndroidTargetHash.getTargetHashString((IAndroidTarget)target);
            }
            if (version2.isPreview()) {
                return String.format(Locale.US, "API %1$d: Android (%2$s)", featureLevel, version2.getCodename());
            }
            return String.format(Locale.US, "API %1$d: Android", featureLevel);
        }

        public String toString() {
            return this.myLabel;
        }
    }

    public static interface ItemsLoaded {
        public void onDataLoadedFinished(List<VersionItem> var1);
    }
}

