/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class FormFactorUtils {
    @Nullable
    public static Icon getFormFactorsImage(JComponent component, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        List filteredFormFactors = Arrays.stream(FormFactor.values()).filter(formFactor -> !(formFactor == FormFactor.GLASS || formFactor == FormFactor.AUTOMOTIVE && (Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get() == false || formFactor == FormFactor.CAR && (Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get() != false || !formFactor.hasEmulator() && requireEmulator)).collect(Collectors.toList());
        for (FormFactor formFactor2 : filteredFormFactors) {
            Icon icon2 = formFactor2.getLargeIcon();
            height = Math.max(height, icon2.getIconHeight());
            width += formFactor2.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (FormFactor formFactor3 : filteredFormFactors) {
            Icon icon3 = formFactor3.getLargeIcon();
            icon3.paintIcon(component, graphics, x, 0);
            x += icon3.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }
}

