/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.npw.project.SourceProviderAdapter;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleModuleUtils {
    @NotNull
    public static SourceProvider getSourceProvider(@NotNull NamedModuleTemplate template) {
        return new SourceProviderAdapter(template.getName(), template.getPaths());
    }

    @Nullable
    public static Module getContainingModule(File file, Project project) {
        if (project.isDisposed()) {
            return null;
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (vFile == null || vFile.isDirectory()) {
            return null;
        }
        return ProjectFileIndex.getInstance((Project)project).getModuleForFile(vFile, false);
    }

    public static void setGradleWrapperExecutable(@NotNull File projectRoot) throws IOException {
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(projectRoot, "gradlew");
            if (!gradlewFile.isFile()) {
                throw new IOException("Could not find gradle wrapper. Command line builds may not work properly.");
            }
            FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
        }
    }

    public static boolean projectContainsFeatureModule(@NotNull Project project) {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List<String> plugins;
            GradleBuildModel gradleBuildModel = projectBuildModel.getModuleBuildModel(module);
            if (gradleBuildModel == null || !(plugins = PluginModel.extractNames(gradleBuildModel.plugins())).contains("com.android.feature")) continue;
            return true;
        }
        return false;
    }
}

