/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.cpp.ConfigureCppSupportStep;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.project.ChooseAndroidProjectPanel;
import com.android.tools.idea.npw.project.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.ui.WizardGallery;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseAndroidProjectStep
extends ModelWizardStep<NewProjectModel> {
    private static final String[] ORDERED_ACTIVITY_NAMES = new String[]{"Basic Activity", "Empty Activity", "Bottom Navigation Activity", "Fragment + ViewModel", "Fullscreen Activity", "Master/Detail Flow", "Navigation Drawer Activity", "Google Maps Activity", "Login Activity", "Scrolling Activity", "Tabbed Activity"};
    private final Supplier<List<FormFactorInfo>> myFormFactors;
    private JPanel myRootPanel;
    private CommonTabbedPane myTabsPanel;
    private JBLoadingPanel myLoadingPanel;
    private NewProjectModuleModel myNewProjectModuleModel;
    private final BoolValueProperty canGoForward;

    public ChooseAndroidProjectStep(@NotNull NewProjectModel model2) {
        super(model2, AndroidBundle.message("android.wizard.project.new.choose", new Object[0]));
        com.google.common.base.Supplier supplier = () -> ChooseAndroidProjectStep.createFormFactors(this.getTitle());
        this.$$$setupUI$$$();
        this.myFormFactors = Suppliers.memoize((com.google.common.base.Supplier)supplier);
        this.canGoForward = new BoolValueProperty();
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        this.myNewProjectModuleModel = new NewProjectModuleModel((NewProjectModel)this.getModel());
        RenderTemplateModel renderModel = this.myNewProjectModuleModel.getExtraRenderTemplateModel();
        return Lists.newArrayList((Object[])new ModelWizardStep[]{new ConfigureAndroidProjectStep(this.myNewProjectModuleModel, (NewProjectModel)this.getModel()), new ConfigureCppSupportStep((NewProjectModel)this.getModel()), new ConfigureTemplateParametersStep(renderModel, AndroidBundle.message("android.wizard.config.activity.title", new Object[0]), Lists.newArrayList())});
    }

    private void createUIComponents() {
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), this, 300){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                for (Component component : this.getComponents()) {
                    component.setBounds(x, y, width, height);
                }
            }
        };
        this.myLoadingPanel.setLoadingText("Loading Android project template files");
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.myLoadingPanel.startLoading();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            List<FormFactorInfo> formFactors = this.myFormFactors.get();
            GuiUtils.invokeLaterIfNeeded(() -> this.updateUi(wizard, formFactors), (ModalityState)ModalityState.any());
        });
    }

    private void updateUi(final @NotNull ModelWizard.Facade wizard, @NotNull List<FormFactorInfo> formFactors) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (FormFactorInfo formFactorInfo : formFactors) {
            ChooseAndroidProjectPanel<TemplateRenderer> tabPanel = formFactorInfo.tabPanel;
            this.myTabsPanel.addTab(formFactorInfo.formFactor.toString(), (Component)tabPanel.myRootPanel);
            tabPanel.myGallery.setDefaultAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    wizard.goForward();
                }
            });
            ListSelectionListener activitySelectedListener = selectionEvent -> {
                TemplateRenderer selectedTemplate = (TemplateRenderer)tabPanel.myGallery.getSelectedElement();
                if (selectedTemplate != null) {
                    tabPanel.myTemplateName.setText(selectedTemplate.getImageLabel());
                    tabPanel.myTemplateDesc.setText("<html>" + selectedTemplate.getTemplateDescription() + "</html>");
                    tabPanel.myDocumentationLink.setVisible(selectedTemplate.isCppTemplate());
                }
            };
            tabPanel.myGallery.addListSelectionListener(activitySelectedListener);
            activitySelectedListener.valueChanged(null);
        }
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
        this.myLoadingPanel.stopLoading();
        this.canGoForward.set(Boolean.TRUE);
    }

    @Override
    protected void onProceeding() {
        FormFactorInfo formFactorInfo = this.myFormFactors.get().get(this.myTabsPanel.getSelectedIndex());
        TemplateRenderer selectedTemplate = (TemplateRenderer)formFactorInfo.tabPanel.myGallery.getSelectedElement();
        ((NewProjectModel)this.getModel()).enableCppSupport().set(selectedTemplate.isCppTemplate());
        this.myNewProjectModuleModel.formFactor().set(formFactorInfo.formFactor);
        this.myNewProjectModuleModel.moduleTemplateFile().setNullableValue(formFactorInfo.templateFile);
        this.myNewProjectModuleModel.renderTemplateHandle().setNullableValue(selectedTemplate.getTemplate());
        TemplateHandle extraStepTemplateHandle = formFactorInfo.formFactor == FormFactor.THINGS ? selectedTemplate.getTemplate() : null;
        this.myNewProjectModuleModel.getExtraRenderTemplateModel().setTemplateHandle(extraStepTemplateHandle);
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.canGoForward;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @NotNull
    protected JComponent getPreferredFocusComponent() {
        return this.myTabsPanel;
    }

    @NotNull
    private static List<FormFactorInfo> createFormFactors(@NotNull String wizardTitle) {
        TreeMap formFactorInfoMap = Maps.newTreeMap();
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactor.get(metadata.getFormFactor())) == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled() || formFactor == FormFactor.AUTOMOTIVE && !((Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get()).booleanValue() || formFactor == FormFactor.CAR && ((Boolean)StudioFlags.NPW_TEMPLATES_AUTOMOTIVE.get()).booleanValue()) continue;
            FormFactorInfo prevFormFactorInfo = (FormFactorInfo)formFactorInfoMap.get((Object)formFactor);
            int templateMinSdk = metadata.getMinSdk();
            if (prevFormFactorInfo == null) {
                int minSdk = Math.max(templateMinSdk, formFactor.getMinOfflineApiLevel());
                ChooseAndroidProjectPanel<TemplateRenderer> tabPanel = new ChooseAndroidProjectPanel<TemplateRenderer>(ChooseAndroidProjectStep.createGallery(wizardTitle, formFactor));
                formFactorInfoMap.put(formFactor, new FormFactorInfo(templateFile, formFactor, minSdk, tabPanel));
                continue;
            }
            if (templateMinSdk <= prevFormFactorInfo.minSdk) continue;
            prevFormFactorInfo.minSdk = templateMinSdk;
            prevFormFactorInfo.templateFile = templateFile;
        }
        return formFactorInfoMap.values().stream().sorted(Comparator.comparing(f -> f.formFactor)).collect(Collectors.toList());
    }

    @NotNull
    private static List<TemplateHandle> getFilteredTemplateHandles(@NotNull FormFactor formFactor) {
        List<TemplateHandle> templateHandles = TemplateManager.getInstance().getTemplateList(formFactor);
        if (formFactor == FormFactor.MOBILE) {
            Map<String, TemplateHandle> entryMap = templateHandles.stream().collect(Collectors.toMap(it -> it.getMetadata().getTitle(), it -> it));
            return Arrays.stream(ORDERED_ACTIVITY_NAMES).map(it -> (TemplateHandle)entryMap.get(it)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (formFactor == FormFactor.AUTOMOTIVE) {
            Set titles = templateHandles.stream().map(it -> it.getMetadata().getTitle()).collect(Collectors.toSet());
            for (TemplateHandle carTemplateHandle : TemplateManager.getInstance().getTemplateList(FormFactor.CAR)) {
                if (titles.contains(carTemplateHandle.getMetadata().getTitle())) continue;
                templateHandles.add(carTemplateHandle);
            }
        }
        return templateHandles;
    }

    @NotNull
    private static ASGallery<TemplateRenderer> createGallery(@NotNull String title, @NotNull FormFactor formFactor) {
        List<TemplateHandle> templateHandles = ChooseAndroidProjectStep.getFilteredTemplateHandles(formFactor);
        ArrayList templateRenderers = Lists.newArrayListWithExpectedSize((int)(templateHandles.size() + 2));
        templateRenderers.add(new TemplateRenderer(null, false));
        for (TemplateHandle templateHandle : templateHandles) {
            templateRenderers.add(new TemplateRenderer(templateHandle, false));
        }
        if (formFactor == FormFactor.MOBILE) {
            templateRenderers.add(new TemplateRenderer(null, true));
        }
        TemplateRenderer[] listItems = templateRenderers.toArray(new TemplateRenderer[0]);
        WizardGallery<TemplateRenderer> gallery = new WizardGallery<TemplateRenderer>(title, TemplateRenderer::getIcon, TemplateRenderer::getImageLabel);
        gallery.setModel(JBList.createDefaultListModel((Object[])listItems));
        gallery.setSelectedIndex(ChooseAndroidProjectStep.getDefaultSelectedTemplateIndex(listItems));
        return gallery;
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateRenderer[] templateRenderers) {
        int i2;
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (!templateRenderers[i2].getImageLabel().equals("Empty Activity")) continue;
            return i2;
        }
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (templateRenderers[i2].getTemplate() == null) continue;
            return i2;
        }
        assert (false) : "No valid Template found";
        return 0;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CommonTabbedPane commonTabbedPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        jBLoadingPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jBLoadingPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myTabsPanel = commonTabbedPane = new CommonTabbedPane();
        commonTabbedPane.setPreferredSize(new Dimension(200, 200));
        jBLoadingPanel.add((Component)commonTabbedPane, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class TemplateRenderer {
        @Nullable
        private final TemplateHandle myTemplate;
        private final boolean myIsCppTemplate;

        TemplateRenderer(@Nullable TemplateHandle template, boolean isCppTemplate) {
            this.myTemplate = template;
            this.myIsCppTemplate = isCppTemplate;
        }

        @Nullable
        TemplateHandle getTemplate() {
            return this.myTemplate;
        }

        boolean isCppTemplate() {
            return this.myIsCppTemplate;
        }

        @NotNull
        String getImageLabel() {
            return ActivityGallery.getTemplateImageLabel(this.myTemplate, this.isCppTemplate());
        }

        @NotNull
        String getTemplateDescription() {
            return ActivityGallery.getTemplateDescription(this.myTemplate, this.isCppTemplate());
        }

        @NotNull
        public String toString() {
            return this.getImageLabel();
        }

        @Nullable
        Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplate, this.isCppTemplate());
        }
    }

    private static class FormFactorInfo {
        @NotNull
        final FormFactor formFactor;
        @NotNull
        final ChooseAndroidProjectPanel<TemplateRenderer> tabPanel;
        @NotNull
        File templateFile;
        int minSdk;

        FormFactorInfo(@NotNull File templateFile, @NotNull FormFactor formFactor, int minSdk, @NotNull ChooseAndroidProjectPanel<TemplateRenderer> tabPanel) {
            this.templateFile = templateFile;
            this.formFactor = formFactor;
            this.minSdk = minSdk;
            this.tabPanel = tabPanel;
        }
    }
}

