/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.ide.common.sdk.LoadStatus;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.idea.npw.ChooseApiLevelDialog;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.AndroidApiLevelComboBox;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.stats.DistributionService;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class FormFactorSdkControls
implements Disposable {
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final AndroidVersionsInfo myAndroidVersionsInfo;
    private LoadStatus mySdkDataLoadingStatus;
    private LoadStatus myStatsDataLoadingStatus;
    private JPanel myStatsPanel;
    private JBLabel myApiPercentIcon;
    private JBLabel myApiPercentLabel;
    private HyperlinkLabel myLearnMoreLink;
    private JPanel myLoadingDataPanel;
    private AsyncProcessIcon myLoadingDataIcon;
    private JLabel myLoadingDataLabel;
    private AndroidApiLevelComboBox myMinSdkCombobox;
    private JPanel myRoot;

    public FormFactorSdkControls() {
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myAndroidVersionsInfo = new AndroidVersionsInfo();
    }

    public void init(OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo, Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myBindings.bind(androidSdkInfo, new SelectedItemProperty(this.myMinSdkCombobox));
        this.myListeners.listen(androidSdkInfo, value2 -> value2.ifPresent(item -> this.myApiPercentLabel.setText(FormFactorSdkControls.getApiHelpText(item.getMinApiLevel()))));
        this.myLoadingDataLabel.setForeground((Color)JBColor.GRAY);
        this.myApiPercentIcon.setIcon(AllIcons.General.BalloonInformation);
        this.myLearnMoreLink.setHyperlinkText(AndroidBundle.message("android.wizard.module.help.choose", new Object[0]));
        this.myLearnMoreLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                int minApiLevel = ((AndroidVersionsInfo.VersionItem)FormFactorSdkControls.this.myMinSdkCombobox.getSelectedItem()).getMinApiLevel();
                ChooseApiLevelDialog chooseApiLevelDialog = new ChooseApiLevelDialog(null, minApiLevel);
                Disposer.register((Disposable)FormFactorSdkControls.this, (Disposable)chooseApiLevelDialog.getDisposable());
                if (!chooseApiLevelDialog.showAndGet()) {
                    return;
                }
                int selectedApiLevel = chooseApiLevelDialog.getSelectedApiLevel();
                for (int i2 = 0; i2 < FormFactorSdkControls.this.myMinSdkCombobox.getItemCount(); ++i2) {
                    AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)FormFactorSdkControls.this.myMinSdkCombobox.getItemAt(i2);
                    if (item.getMinApiLevel() != selectedApiLevel) continue;
                    FormFactorSdkControls.this.myMinSdkCombobox.setSelectedItem(item);
                    break;
                }
            }
        });
    }

    @NotNull
    public JPanel getRoot() {
        return this.myRoot;
    }

    public void showStatsPanel(boolean show) {
        this.myStatsPanel.setVisible(show);
    }

    public void startDataLoading(FormFactor formFactor, int minSdk) {
        this.myApiPercentLabel.setText(FormFactorSdkControls.getApiHelpText(minSdk));
        this.mySdkDataLoadingStatus = LoadStatus.LOADING;
        this.myStatsDataLoadingStatus = this.myStatsPanel.isVisible() ? LoadStatus.LOADING : LoadStatus.LOADED;
        this.updateLoadingProgress();
        this.myAndroidVersionsInfo.loadLocalVersions();
        this.myMinSdkCombobox.init(formFactor, this.myAndroidVersionsInfo.getKnownTargetVersions(formFactor, minSdk));
        this.myAndroidVersionsInfo.loadRemoteTargetVersions(formFactor, minSdk, items2 -> {
            this.myMinSdkCombobox.init(formFactor, items2);
            this.mySdkDataLoadingStatus = LoadStatus.LOADED;
            this.updateLoadingProgress();
        });
        if (this.myStatsPanel.isVisible()) {
            DistributionService.getInstance().refresh(() -> ApplicationManager.getApplication().invokeLater(() -> {
                this.myStatsDataLoadingStatus = LoadStatus.LOADED;
                this.updateLoadingProgress();
            }), () -> ApplicationManager.getApplication().invokeLater(() -> {
                this.myStatsDataLoadingStatus = LoadStatus.FAILED;
                this.updateLoadingProgress();
            }));
        }
    }

    public Collection<? extends UpdatablePackage> getSdkInstallPackageList() {
        AndroidVersionsInfo.VersionItem androidVersion = (AndroidVersionsInfo.VersionItem)this.myMinSdkCombobox.getSelectedItem();
        return this.myAndroidVersionsInfo.loadInstallPackageList(Collections.singletonList(androidVersion));
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private void createUIComponents() {
        this.myLoadingDataIcon = new AsyncProcessIcon(AndroidBundle.message("android.wizard.module.help.loading", new Object[0]));
    }

    private void updateLoadingProgress() {
        this.myLoadingDataPanel.setVisible(this.mySdkDataLoadingStatus != LoadStatus.LOADED || this.myStatsDataLoadingStatus != LoadStatus.LOADED);
        this.myLoadingDataIcon.setVisible(this.mySdkDataLoadingStatus == LoadStatus.LOADING || this.myStatsDataLoadingStatus == LoadStatus.LOADING);
        if (this.mySdkDataLoadingStatus == LoadStatus.LOADING) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.project.loading.sdks", new Object[0]));
        } else if (this.myStatsDataLoadingStatus == LoadStatus.LOADING) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.module.help.refreshing", new Object[0]));
        } else if (this.myStatsDataLoadingStatus == LoadStatus.FAILED) {
            this.myLoadingDataLabel.setText(AndroidBundle.message("android.wizard.project.loading.stats.fail", new Object[0]));
        }
    }

    public void setEnabled(boolean enabled) {
        this.myMinSdkCombobox.setEnabled(enabled);
    }

    private static String getApiHelpText(int selectedApi) {
        double percentage = DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0;
        String percentageStr = percentage < 1.0 ? "<b>&lt; 1%</b>" : String.format("approximately <b>" + (percentage >= 10.0 ? "%.3g%%" : "%.2g%%") + "</b>", percentage);
        return String.format("<html>Your app will run on %1$s of devices.</html>", percentageStr);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        AndroidApiLevelComboBox androidApiLevelComboBox;
        JLabel jLabel;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myStatsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myApiPercentIcon = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myApiPercentLabel = jBLabel = new JBLabel();
        jBLabel.setText("API level percentage");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myLearnMoreLink = hyperlinkLabel = new HyperlinkLabel();
        Font font = this.$$$getFont$$$(null, -1, 11, hyperlinkLabel.getFont());
        if (font != null) {
            hyperlinkLabel.setFont(font);
        }
        hyperlinkLabel.setOpaque(true);
        hyperlinkLabel.setText("");
        hyperlinkLabel.setVisible(true);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myLoadingDataPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myLoadingDataIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myLoadingDataLabel = jLabel = new JLabel();
        jLabel.setText("(loading SDK Data and Stats)");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 0, -1, jLabel2.getFont());
        if (font2 != null) {
            jLabel2.setFont(font2);
        }
        jLabel2.setText("Minimum API level");
        jLabel2.setVerticalAlignment(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        this.myMinSdkCombobox = androidApiLevelComboBox = new AndroidApiLevelComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        androidApiLevelComboBox.setModel(defaultComboBoxModel);
        jPanel3.add((Component)androidApiLevelComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

