/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.ui.WizardGallery;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActivityTypeStep
extends SkippableWizardStep<NewModuleModel> {
    private final RenderTemplateModel myRenderModel;
    @NotNull
    private List<TemplateRenderer> myTemplateRenderers;
    @NotNull
    private List<NamedModuleTemplate> myModuleTemplates;
    @NotNull
    private ASGallery<TemplateRenderer> myActivityGallery;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final StringProperty myInvalidParameterMessage = new StringValueProperty();
    private final ListenerManager myListeners = new ListenerManager();

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull List<NamedModuleTemplate> moduleTemplates) {
        this(moduleModel, renderModel, formFactor);
        this.init(formFactor, moduleTemplates);
    }

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull VirtualFile targetDirectory) {
        this(moduleModel, renderModel, formFactor);
        List<NamedModuleTemplate> moduleTemplates = AndroidPackageUtils.getModuleTemplates(renderModel.getAndroidFacet(), targetDirectory);
        this.init(formFactor, moduleTemplates);
    }

    private ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor) {
        super(moduleModel, AndroidBundle.message("android.wizard.activity.add", formFactor.id), formFactor.getIcon());
        this.myRenderModel = renderModel;
    }

    private void init(@NotNull FormFactor formFactor, @NotNull List<NamedModuleTemplate> moduleTemplates) {
        this.myModuleTemplates = moduleTemplates;
        List<TemplateHandle> templateHandles = TemplateManager.getInstance().getTemplateList(formFactor);
        this.myTemplateRenderers = Lists.newArrayListWithExpectedSize((int)(templateHandles.size() + 1));
        if (this.isNewModule()) {
            this.myTemplateRenderers.add(new TemplateRenderer(null));
        }
        for (TemplateHandle templateHandle : templateHandles) {
            this.myTemplateRenderers.add(new TemplateRenderer(templateHandle));
        }
        this.myActivityGallery = new WizardGallery<TemplateRenderer>(this.getTitle(), TemplateRenderer::getIcon, TemplateRenderer::getLabel);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)new JBScrollPane(this.myActivityGallery));
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myActivityGallery;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        String title = AndroidBundle.message("android.wizard.config.activity.title", new Object[0]);
        return Lists.newArrayList((Object[])new ConfigureTemplateParametersStep[]{new ConfigureTemplateParametersStep(this.myRenderModel, title, this.myModuleTemplates)});
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.myActivityGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myActivityGallery.addListSelectionListener(listSelectionEvent -> {
            TemplateRenderer selectedTemplate = (TemplateRenderer)this.myActivityGallery.getSelectedElement();
            if (selectedTemplate != null) {
                this.myRenderModel.setTemplateHandle(selectedTemplate.getTemplate());
                wizard.updateNavigationProperties();
            }
            this.validateTemplate();
        });
        this.myListeners.listenAndFire(((NewModuleModel)this.getModel()).enableCppSupport().or(((NewModuleModel)this.getModel()).instantApp()), src -> {
            TemplateRenderer[] listItems = this.createGalleryList(this.myTemplateRenderers);
            this.myActivityGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])listItems));
            this.myActivityGallery.setSelectedIndex(ChooseActivityTypeStep.getDefaultSelectedTemplateIndex(listItems, this.isNewModule()));
        });
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onEntering() {
        this.validateTemplate();
    }

    @Override
    protected void onProceeding() {
        NewModuleModel moduleModel = (NewModuleModel)this.getModel();
        Project project = moduleModel.getProject().getValueOrNull();
        if (this.myRenderModel.getTemplateHandle() == null) {
            moduleModel.setDefaultRenderTemplateValues(this.myRenderModel, project);
        } else {
            moduleModel.getRenderTemplateValues().setValue(this.myRenderModel.getTemplateValues());
        }
        new TemplateValueInjector(moduleModel.getTemplateValues()).setProjectDefaults(project, (String)moduleModel.applicationName().get());
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateRenderer[] templateRenderers, boolean isNewModule) {
        int i2;
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (!templateRenderers[i2].getLabel().equals("Empty Activity")) continue;
            return i2;
        }
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (templateRenderers[i2].getTemplate() == null) continue;
            return i2;
        }
        assert (false);
        return 0;
    }

    private boolean isNewModule() {
        return this.myRenderModel.getModule() == null;
    }

    private TemplateRenderer[] createGalleryList(@NotNull List<TemplateRenderer> templateRenderers) {
        Predicate<TemplateRenderer> predicate = (Boolean)((NewModuleModel)this.getModel()).enableCppSupport().get() != false ? TemplateRenderer::isCppTemplate : ((Boolean)((NewModuleModel)this.getModel()).instantApp().get() != false ? TemplateRenderer::isIappTemplate : templateRenderer -> true);
        List<TemplateRenderer> filteredTemplates = templateRenderers.stream().filter(predicate).collect(Collectors.toList());
        if (filteredTemplates.size() > 1) {
            return filteredTemplates.toArray(new TemplateRenderer[0]);
        }
        return templateRenderers.toArray(new TemplateRenderer[0]);
    }

    private void validateTemplate() {
        TemplateHandle template = this.myRenderModel.getTemplateHandle();
        TemplateMetadata templateData = template == null ? null : template.getMetadata();
        AndroidVersionsInfo.VersionItem androidSdkInfo = this.myRenderModel.androidSdkInfo().getValueOrNull();
        AndroidFacet facet = this.myRenderModel.getAndroidFacet();
        int moduleApiLevel = Integer.MAX_VALUE;
        int moduleBuildApiLevel = Integer.MAX_VALUE;
        if (androidSdkInfo != null) {
            moduleApiLevel = androidSdkInfo.getMinApiLevel();
            moduleBuildApiLevel = androidSdkInfo.getBuildApiLevel();
        } else if (facet != null) {
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
            moduleApiLevel = moduleInfo.getMinSdkVersion().getFeatureLevel();
            if (moduleInfo.getBuildSdkVersion() != null) {
                moduleBuildApiLevel = moduleInfo.getBuildSdkVersion().getFeatureLevel();
            }
        }
        Project project = ((NewModuleModel)this.getModel()).getProject().getValueOrNull();
        boolean isAndroidxProj = project != null && MigrateToAndroidxUtil.isAndroidx(project);
        this.myInvalidParameterMessage.set(ChooseActivityTypeStep.validateTemplate(templateData, moduleApiLevel, moduleBuildApiLevel, this.isNewModule(), isAndroidxProj));
    }

    @NotNull
    @VisibleForTesting
    static String validateTemplate(@Nullable TemplateMetadata template, int moduleApiLevel, int moduleBuildApiLevel, boolean isNewModule, boolean isAndroidxProj) {
        if (template == null) {
            return isNewModule ? "" : AndroidBundle.message("android.wizard.activity.not.found", new Object[0]);
        }
        if (moduleApiLevel < template.getMinSdk()) {
            return AndroidBundle.message("android.wizard.activity.invalid.min.sdk", template.getMinSdk());
        }
        if (moduleBuildApiLevel < template.getMinBuildApi()) {
            return AndroidBundle.message("android.wizard.activity.invalid.min.build", template.getMinBuildApi());
        }
        if (template.getAndroidXRequired() && !isAndroidxProj) {
            return AndroidBundle.message("android.wizard.activity.invalid.androidx", new Object[0]);
        }
        return "";
    }

    private static class TemplateRenderer {
        @Nullable
        private final TemplateHandle myTemplate;

        TemplateRenderer(@Nullable TemplateHandle template) {
            this.myTemplate = template;
        }

        @Nullable
        TemplateHandle getTemplate() {
            return this.myTemplate;
        }

        @NotNull
        String getLabel() {
            return ActivityGallery.getTemplateImageLabel(this.myTemplate, false);
        }

        public String toString() {
            return this.getLabel();
        }

        boolean isCppTemplate() {
            if (this.myTemplate == null) {
                return true;
            }
            String title = this.myTemplate.getMetadata().getTitle();
            return "Empty Activity".equals(title) || "Basic Activity".equals(title);
        }

        boolean isIappTemplate() {
            return !"Settings Activity".equals(this.getLabel());
        }

        @Nullable
        Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplate, false);
        }
    }
}

