/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.builder.model.SourceProvider;
import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipLabel;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.template.GenerateIconsStep;
import com.android.tools.idea.npw.template.IconLoader;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.npw.template.components.ActivityComboProvider;
import com.android.tools.idea.npw.template.components.CheckboxProvider;
import com.android.tools.idea.npw.template.components.ComponentProvider;
import com.android.tools.idea.npw.template.components.EnumComboProvider;
import com.android.tools.idea.npw.template.components.LabelWithEditButtonProvider;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.template.components.ModuleTemplateComboProvider;
import com.android.tools.idea.npw.template.components.PackageComboProvider;
import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.npw.template.components.SeparatorProvider;
import com.android.tools.idea.npw.template.components.TextFieldProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.IconProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.ParameterValueResolver;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureTemplateParametersStep
extends ModelWizardStep<RenderTemplateModel> {
    private final List<NamedModuleTemplate> myTemplates;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final LoadingCache<File, Optional<Icon>> myThumbnailsCache;
    private final Map<Parameter, RowEntry> myParameterRows;
    private final Map<Parameter, Object> myUserValues;
    private final StringEvaluator myEvaluator;
    private final StringProperty myThumbPath;
    private final StringProperty myInvalidParameterMessage;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myRootPanel;
    private JLabel myTemplateThumbLabel;
    private JPanel myParametersPanel;
    private JSeparator myFooterSeparator;
    private TooltipLabel myParameterDescriptionLabel;
    private JLabel myTemplateDescriptionLabel;
    private EvaluationState myEvaluationState;

    public ConfigureTemplateParametersStep(@NotNull RenderTemplateModel model2, @NotNull String title, @NotNull List<NamedModuleTemplate> templates) {
        super(model2, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myThumbnailsCache = IconLoader.createLoadingCache();
        this.myParameterRows = Maps.newHashMap();
        this.myUserValues = Maps.newHashMap();
        this.myEvaluator = new StringEvaluator();
        this.myThumbPath = new StringValueProperty();
        this.myInvalidParameterMessage = new StringValueProperty();
        this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        this.myTemplates = templates;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)StudioWizardStepPanel.wrappedWithVScroll(this.myRootPanel));
        this.myParameterDescriptionLabel.setScope((Container)this.myParametersPanel);
        this.myTemplateDescriptionLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)this.myTemplateDescriptionLabel.getFont().getSize()));
    }

    private static Logger getLog() {
        return Logger.getInstance(ConfigureTemplateParametersStep.class);
    }

    @NotNull
    private static String getRecentsKeyForParameter(@NotNull Parameter parameter) {
        return "android.template." + parameter.id;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        TemplateHandle template = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        if (template != null && template.getMetadata().getIconType() == AndroidIconType.NOTIFICATION) {
            assert (((RenderTemplateModel)this.getModel()).getAndroidFacet() != null);
            return Collections.singletonList(new GenerateIconsStep(((RenderTemplateModel)this.getModel()).getAndroidFacet(), (RenderTemplateModel)this.getModel()));
        }
        return super.createDependentSteps();
    }

    @Override
    protected boolean shouldShow() {
        return ((RenderTemplateModel)this.getModel()).getTemplateHandle() != null;
    }

    @Override
    protected void onEntering() {
        RowEntry<JComboBox> row;
        this.resetPanel();
        final TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        TemplateMetadata templateMetadata = templateHandle.getMetadata();
        ApplicationManager.getApplication().invokeLater(() -> this.myTemplateDescriptionLabel.setText(WizardUtils.toHtmlString(Strings.nullToEmpty((String)templateMetadata.getDescription()))), ModalityState.any());
        if (templateMetadata.getFormFactor() != null) {
            this.setIcon(FormFactor.get(templateMetadata.getFormFactor()).getIcon());
        }
        final IconProperty thumb = new IconProperty(this.myTemplateThumbLabel);
        VisibleProperty thumbVisibility = new VisibleProperty(this.myTemplateThumbLabel);
        this.myBindings.bind(thumb, new Expression<Optional<Icon>>(new ObservableValue[]{this.myThumbPath}){

            @Override
            @NotNull
            public Optional<Icon> get() {
                return (Optional)ConfigureTemplateParametersStep.this.myThumbnailsCache.getUnchecked((Object)new File(templateHandle.getRootPath(), (String)ConfigureTemplateParametersStep.this.myThumbPath.get()));
            }
        });
        this.myBindings.bind(thumbVisibility, new Expression<Boolean>(new ObservableValue[]{thumb}){

            @Override
            @NotNull
            public Boolean get() {
                return ((Optional)thumb.get()).isPresent();
            }
        });
        this.myThumbPath.set(this.getDefaultThumbnailPath());
        final TextProperty parameterDescription = new TextProperty((JLabel)this.myParameterDescriptionLabel);
        this.myBindings.bind(new VisibleProperty(this.myFooterSeparator), new Expression<Boolean>(new ObservableValue[]{parameterDescription}){

            @Override
            @NotNull
            public Boolean get() {
                return !parameterDescription.get().isEmpty();
            }
        });
        for (final Parameter parameter : templateMetadata.getParameters()) {
            RowEntry<?> row2 = this.createRowForParameter(((RenderTemplateModel)this.getModel()).getModule(), parameter);
            ObservableValue<?> property2 = row2.getProperty();
            if (property2 != null) {
                property2.addListener(() -> {
                    if (this.myEvaluationState != EvaluationState.EVALUATING && this.myRootPanel.isShowing()) {
                        this.myUserValues.put(parameter, property2.get());
                        this.enqueueEvaluateParameters();
                    }
                });
                final ActionGroup resetParameterGroup = new ActionGroup(){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        return new AnAction[]{new ResetParameterAction(parameter)};
                    }
                };
                row2.getComponent().addMouseListener((MouseListener)new PopupHandler(){

                    public void invokePopup(Component comp, int x, int y) {
                        ActionManager.getInstance().createActionPopupMenu("unknown", resetParameterGroup).getComponent().show(comp, x, y);
                    }
                });
            }
            this.myParameterRows.put(parameter, row2);
            row2.addToPanel(this.myParametersPanel);
        }
        if (this.displayLanguageChoice(templateMetadata)) {
            row = new RowEntry<JComboBox>("Source Language", new LanguageComboProvider());
            row.addToPanel(this.myParametersPanel);
            SelectedItemProperty language = (SelectedItemProperty)row.getProperty();
            assert (language != null);
            this.myBindings.bindTwoWay(ObjectProperty.wrap(language), ((RenderTemplateModel)this.getModel()).getLanguage());
        }
        if (this.myTemplates.size() > 1) {
            row = new RowEntry<JComboBox>("Target Source Set", new ModuleTemplateComboProvider(this.myTemplates));
            row.setEnabled(this.myTemplates.size() > 1);
            row.addToPanel(this.myParametersPanel);
            SelectedItemProperty template = (SelectedItemProperty)row.getProperty();
            assert (template != null);
            this.myBindings.bind(((RenderTemplateModel)this.getModel()).getTemplate(), ObjectProperty.wrap(template));
            template.addListener(() -> this.enqueueEvaluateParameters());
        }
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.evaluateParameters();
    }

    private boolean displayLanguageChoice(TemplateMetadata templateMetadata) {
        if (((RenderTemplateModel)this.getModel()).getAndroidFacet() == null) {
            return false;
        }
        return templateMetadata.getFormFactor() != null || templateMetadata.getParameter("className") != null || templateMetadata.getParameter("packageName") != null;
    }

    private RowEntry<?> createRowForParameter(@Nullable Module module, @NotNull Parameter parameter) {
        if ("packageName".equals(parameter.id)) {
            assert (parameter.name != null);
            RowEntry<Object> rowEntry = module != null ? new RowEntry<EditorComboBox>(parameter.name, new PackageComboProvider(module.getProject(), parameter, (String)((RenderTemplateModel)this.getModel()).packageName().get(), ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter))) : new RowEntry<LabelWithEditButton>(parameter.name, new LabelWithEditButtonProvider(parameter));
            StringProperty packageName = (StringProperty)rowEntry.getProperty();
            assert (packageName != null);
            this.myBindings.bindTwoWay(packageName, ((RenderTemplateModel)this.getModel()).packageName());
            this.myListeners.listen(((RenderTemplateModel)this.getModel()).packageName(), () -> this.enqueueEvaluateParameters());
            return rowEntry;
        }
        if ("parentActivityClass".equals(parameter.id) && module != null) {
            assert (parameter.name != null);
            return new RowEntry<ReferenceEditorComboWithBrowseButton>(parameter.name, new ActivityComboProvider(module, parameter, ConfigureTemplateParametersStep.getRecentsKeyForParameter(parameter)));
        }
        switch (parameter.type) {
            case STRING: {
                assert (parameter.name != null);
                return new RowEntry<JTextField>(parameter.name, new TextFieldProvider(parameter));
            }
            case BOOLEAN: {
                return new RowEntry<JCheckBox>(new CheckboxProvider(parameter), RowEntry.WantGrow.NO);
            }
            case SEPARATOR: {
                return new RowEntry<JSeparator>(new SeparatorProvider(parameter), RowEntry.WantGrow.YES);
            }
            case ENUM: {
                assert (parameter.name != null);
                return new RowEntry<JComboBox>(parameter.name, new EnumComboProvider(parameter));
            }
        }
        throw new IllegalStateException(String.format("Can't create UI for unknown component type: %1$s (%2$s)", new Object[]{parameter.type, parameter.id}));
    }

    private void enqueueEvaluateParameters() {
        if (this.myEvaluationState == EvaluationState.REQUEST_ENQUEUED) {
            return;
        }
        this.myEvaluationState = EvaluationState.REQUEST_ENQUEUED;
        ApplicationManager.getApplication().invokeLater(this::evaluateParameters, ModalityState.any());
    }

    private boolean isNewModule() {
        return ((RenderTemplateModel)this.getModel()).getModule() == null;
    }

    private boolean isParameterVisible(Parameter parameter) {
        return !this.isNewModule() || !"packageName".equals(parameter.id) && !"isLauncher".equals(parameter.id) && !"parentActivityClass".equals(parameter.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateParameters() {
        this.myEvaluationState = EvaluationState.EVALUATING;
        Collection<Parameter> parameters2 = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        HashSet excludedParameters = Sets.newHashSet();
        try {
            int projectType = ((RenderTemplateModel)this.getModel()).getAndroidFacet() == null ? -1 : ((AndroidFacetConfiguration)((RenderTemplateModel)this.getModel()).getAndroidFacet().getConfiguration()).getProjectType();
            boolean isInstantApp = projectType == 5 || (Boolean)((RenderTemplateModel)this.getModel()).instantApp().get() != false;
            HashMap additionalValues = Maps.newHashMap();
            new TemplateValueInjector(additionalValues).addTemplateAdditionalValues((String)((RenderTemplateModel)this.getModel()).packageName().get(), isInstantApp, ((RenderTemplateModel)this.getModel()).getTemplate());
            HashMap allValues = Maps.newHashMap((Map)additionalValues);
            Map<Parameter, Object> parameterValues = ParameterValueResolver.resolve(parameters2, this.myUserValues, additionalValues, new ParameterDeduplicator());
            for (Parameter parameter : parameters2) {
                Object value2 = parameterValues.get(parameter);
                if (value2 == null) continue;
                this.myParameterRows.get(parameter).setValue(value2);
                allValues.put(parameter.id, value2);
            }
            for (Parameter parameter : parameters2) {
                String enabledStr = Strings.nullToEmpty((String)parameter.enabled);
                if (!enabledStr.isEmpty()) {
                    boolean enabled = this.myEvaluator.evaluateBooleanExpression(enabledStr, allValues, true);
                    this.myParameterRows.get(parameter).setEnabled(enabled);
                    if (!enabled) {
                        excludedParameters.add(parameter.id);
                    }
                }
                if (!this.isParameterVisible(parameter)) {
                    this.myParameterRows.get(parameter).setVisible(false);
                    excludedParameters.add(parameter.id);
                    continue;
                }
                String visibilityStr = Strings.nullToEmpty((String)parameter.visibility);
                if (visibilityStr.isEmpty()) continue;
                boolean visible = this.myEvaluator.evaluateBooleanExpression(visibilityStr, allValues, true);
                this.myParameterRows.get(parameter).setVisible(visible);
                if (visible) continue;
                excludedParameters.add(parameter.id);
            }
            this.myThumbPath.set(this.getCurrentThumbnailPath());
        }
        catch (CircularParameterDependencyException e) {
            ConfigureTemplateParametersStep.getLog().error("Circular dependency between parameters in template %1$s", (Throwable)e, new String[]{((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getTitle()});
        }
        finally {
            this.myEvaluationState = EvaluationState.NOT_EVALUATING;
        }
        this.myInvalidParameterMessage.set(Strings.nullToEmpty((String)this.validateAllParametersExcept(excludedParameters)));
    }

    @NotNull
    private String getDefaultThumbnailPath() {
        return Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath());
    }

    @NotNull
    private String getCurrentThumbnailPath() {
        return Strings.nullToEmpty((String)((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getThumbnailPath((Function<String, Object>)((Function)parameterId -> {
            Parameter parameter = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameter((String)parameterId);
            ObservableValue<?> property2 = this.myParameterRows.get(parameter).getProperty();
            return property2 != null ? property2.get() : null;
        })));
    }

    @Nullable
    private String validateAllParametersExcept(@NotNull Set<String> excludedParameters) {
        String message2 = null;
        Collection<Parameter> parameters2 = ((RenderTemplateModel)this.getModel()).getTemplateHandle().getMetadata().getParameters();
        Module module = ((RenderTemplateModel)this.getModel()).getModule();
        Project project = ((RenderTemplateModel)this.getModel()).getProject().getValueOrNull();
        SourceProvider sourceProvider = AndroidGradleModuleUtils.getSourceProvider((NamedModuleTemplate)((RenderTemplateModel)this.getModel()).getTemplate().get());
        for (Parameter parameter : parameters2) {
            ObservableValue<?> property2 = this.myParameterRows.get(parameter).getProperty();
            if (property2 == null || excludedParameters.contains(parameter.id)) continue;
            Set<Object> relatedValues = this.getRelatedValues(parameter);
            message2 = parameter.validate(project, module, sourceProvider, (String)((RenderTemplateModel)this.getModel()).packageName().get(), property2.get(), relatedValues);
            if (message2 == null) continue;
            break;
        }
        return message2;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        Component[] children = this.myParametersPanel.getComponents();
        for (int i2 = 0; i2 < children.length; ++i2) {
            boolean isContainer;
            JComponent child = (JComponent)children[i2];
            boolean bl = isContainer = child.getComponentCount() > 0;
            if (isContainer || !child.isFocusable() || !child.isVisible()) continue;
            return child;
        }
        return null;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void createUIComponents() {
        this.myParametersPanel = new JPanel((LayoutManager)new TabularLayout("Fit-,*").setVGap(10));
    }

    private void resetPanel() {
        this.myParametersPanel.removeAll();
        this.myParameterRows.clear();
        this.dispose();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myThumbnailsCache.invalidateAll();
    }

    @Override
    protected void onProceeding() {
        for (RowEntry rowEntry : this.myParameterRows.values()) {
            rowEntry.accept();
        }
        Map<String, Object> templateValues = ((RenderTemplateModel)this.getModel()).getTemplateValues();
        templateValues.clear();
        for (Parameter parameter : this.myParameterRows.keySet()) {
            ObservableValue<?> property2 = this.myParameterRows.get(parameter).getProperty();
            if (property2 == null) continue;
            templateValues.put(parameter.id, property2.get());
        }
    }

    private Set<Object> getRelatedValues(@NotNull Parameter parameter) {
        HashSet relatedValues = Sets.newHashSet();
        for (Parameter related : parameter.template.getRelatedParams(parameter)) {
            ObservableValue<?> property2 = this.myParameterRows.get(related).getProperty();
            if (property2 == null) continue;
            relatedValues.add(property2.get());
        }
        return relatedValues;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        TooltipLabel tooltipLabel;
        JSeparator jSeparator;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFooterSeparator = jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myParameterDescriptionLabel = tooltipLabel = new TooltipLabel();
        tooltipLabel.setText("");
        jPanel.add((Component)tooltipLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 2, null, null, null));
        this.myTemplateThumbLabel = jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setVerticalAlignment(1);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myParametersPanel;
        jPanel2.setOpaque(true);
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myTemplateDescriptionLabel = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, 18, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private final class ResetParameterAction
    extends AnAction {
        @NotNull
        private final Parameter myParameter;

        public ResetParameterAction(Parameter parameter) {
            super("Restore default value", "Discards any user modifications made to this parameter", AllIcons.General.Reset);
            this.myParameter = parameter;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ConfigureTemplateParametersStep.this.myUserValues.containsKey(this.myParameter));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ConfigureTemplateParametersStep.this.myUserValues.remove(this.myParameter);
            ConfigureTemplateParametersStep.this.evaluateParameters();
        }
    }

    private final class ParameterDeduplicator
    implements ParameterValueResolver.Deduplicator {
        private ParameterDeduplicator() {
        }

        @Override
        @Nullable
        public String deduplicate(@NotNull Parameter parameter, @Nullable String value2) {
            if (Strings.isNullOrEmpty((String)value2) || !parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE)) {
                return value2;
            }
            String suggested = value2;
            String extPart = Strings.emptyToNull((String)Files.getFileExtension((String)value2));
            String namePart = value2.replace("." + extPart, "");
            namePart = namePart.replaceAll("\\d*$", "");
            Joiner filenameJoiner = Joiner.on((char)'.').skipNulls();
            int suffix = 2;
            Module module = ((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getModule();
            Project project = ((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getProject().getValueOrNull();
            Set relatedValues = ConfigureTemplateParametersStep.this.getRelatedValues(parameter);
            SourceProvider sourceProvider = AndroidGradleModuleUtils.getSourceProvider((NamedModuleTemplate)((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).getTemplate().get());
            while (!parameter.uniquenessSatisfied(project, module, sourceProvider, (String)((RenderTemplateModel)ConfigureTemplateParametersStep.this.getModel()).packageName().get(), suggested, relatedValues)) {
                suggested = filenameJoiner.join((Object)(namePart + suffix), (Object)extPart, new Object[0]);
                ++suffix;
            }
            return suggested;
        }
    }

    private static final class RowEntry<T extends JComponent> {
        @Nullable
        private final JPanel myHeader;
        @NotNull
        private final ComponentProvider<T> myComponentProvider;
        @NotNull
        private final T myComponent;
        @Nullable
        private final AbstractProperty<?> myProperty;
        @NotNull
        private final WantGrow myWantGrow;

        public RowEntry(@NotNull String headerText, @NotNull ComponentProvider<T> componentProvider) {
            this.myHeader = new JPanel(new FlowLayout(0));
            JBLabel headerLabel = new JBLabel(headerText + ":");
            this.myHeader.add((Component)headerLabel);
            this.myHeader.add(Box.createHorizontalStrut(20));
            this.myWantGrow = WantGrow.NO;
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
            headerLabel.setLabelFor(this.myComponent);
        }

        public RowEntry(@NotNull ParameterComponentProvider<T> componentProvider, @NotNull WantGrow stretch) {
            this.myHeader = null;
            this.myWantGrow = stretch;
            this.myComponentProvider = componentProvider;
            this.myComponent = componentProvider.createComponent();
            this.myProperty = componentProvider.createProperty(this.myComponent);
        }

        @Nullable
        public ObservableValue<?> getProperty() {
            return this.myProperty;
        }

        public void addToPanel(@NotNull JPanel panel2) {
            assert (panel2.getLayout().getClass().equals(TabularLayout.class));
            int row = panel2.getComponentCount();
            if (this.myHeader != null) {
                panel2.add((Component)this.myHeader, new TabularLayout.Constraint(row, 0));
                assert (this.myWantGrow == WantGrow.NO);
            }
            int colspan = this.myWantGrow == WantGrow.YES ? 2 : 1;
            panel2.add((Component)this.myComponent, new TabularLayout.Constraint(row, 1, colspan));
        }

        public void setEnabled(boolean enabled) {
            if (this.myHeader != null) {
                this.myHeader.setEnabled(enabled);
            }
            ((JComponent)this.myComponent).setEnabled(enabled);
        }

        public void setVisible(boolean visible) {
            if (this.myHeader != null) {
                this.myHeader.setVisible(visible);
            }
            ((JComponent)this.myComponent).setVisible(visible);
        }

        public <V> void setValue(@NotNull V value2) {
            assert (this.myProperty != null);
            this.myProperty.set(value2);
        }

        @NotNull
        public JComponent getComponent() {
            return this.myComponent;
        }

        public void accept() {
            this.myComponentProvider.accept(this.myComponent);
        }

        public static enum WantGrow {
            NO,
            YES;

        }
    }

    private static enum EvaluationState {
        NOT_EVALUATING,
        REQUEST_ENQUEUED,
        EVALUATING;

    }
}

