/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateImageAssetPanel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.base.Strings;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class GenerateIconsStep
extends ModelWizardStep<RenderTemplateModel> {
    private final StudioWizardStepPanel myStudioPanel;
    private final GenerateImageAssetPanel myGenerateIconsPanel;
    private final ListenerManager myListeners = new ListenerManager();

    public GenerateIconsStep(AndroidFacet facet, @NotNull RenderTemplateModel model2) {
        super(model2, "Generate Icons");
        TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        assert (templateHandle != null);
        AndroidIconType iconType = templateHandle.getMetadata().getIconType();
        assert (iconType != null);
        this.myGenerateIconsPanel = new GenerateImageAssetPanel(this, facet, ((NamedModuleTemplate)model2.getTemplate().get()).getPaths(), iconType);
        this.myListeners.listenAndFire(model2.getTemplate(), value2 -> this.myGenerateIconsPanel.setProjectPaths(value2.getPaths()));
        this.myStudioPanel = new StudioWizardStepPanel(this.myGenerateIconsPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    @Override
    protected void onEntering() {
        TemplateHandle templateHandle = ((RenderTemplateModel)this.getModel()).getTemplateHandle();
        assert (templateHandle != null);
        String iconNameExpression = templateHandle.getMetadata().getIconName();
        String iconName = null;
        if (iconNameExpression != null && !iconNameExpression.isEmpty()) {
            StringEvaluator evaluator = new StringEvaluator();
            iconName = evaluator.evaluate(iconNameExpression, ((RenderTemplateModel)this.getModel()).getTemplateValues());
        }
        this.myGenerateIconsPanel.setOutputName(Strings.nullToEmpty(iconName));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myGenerateIconsPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        ((RenderTemplateModel)this.getModel()).setIconGenerator(this.myGenerateIconsPanel.getIconGenerator());
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }
}

