/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.ui.TemplateIcon;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IconLoader
extends CacheLoader<File, Optional<Icon>> {
    IconLoader() {
    }

    public static LoadingCache<File, Optional<Icon>> createLoadingCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new IconLoader());
    }

    private static Logger getLog() {
        return Logger.getInstance(IconLoader.class);
    }

    @Nullable
    public Optional<Icon> load(@NotNull File iconPath) {
        try {
            if (iconPath.isFile()) {
                Icon icon2 = com.intellij.openapi.util.IconLoader.findIcon((URL)iconPath.toURI().toURL());
                if (icon2 != null) {
                    TemplateIcon templateIcon = new TemplateIcon(icon2);
                    templateIcon.cropBlankWidth();
                    templateIcon.setHeight(256);
                    return Optional.of(templateIcon);
                }
                IconLoader.getLog().warn("File " + iconPath.getAbsolutePath() + " exists but is not a valid image");
            } else {
                IconLoader.getLog().warn("Image file " + iconPath.getAbsolutePath() + " was not found");
            }
        }
        catch (IOException e) {
            IconLoader.getLog().warn((Throwable)e);
        }
        return Optional.empty();
    }
}

