/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class TemplateHandle {
    private final File myRootPath;
    private final Template myTemplate;
    private final TemplateMetadata myMetadata;

    public TemplateHandle(@NotNull File rootPath) {
        this.myRootPath = rootPath;
        this.myTemplate = Template.createFromPath(rootPath);
        this.myMetadata = TemplateManager.getInstance().getTemplateMetadata(rootPath);
    }

    @NotNull
    public File getRootPath() {
        return this.myRootPath;
    }

    @NotNull
    public Template getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public TemplateMetadata getMetadata() {
        return this.myMetadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myRootPath, this.myMetadata.getTitle()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TemplateHandle another = (TemplateHandle)obj;
        return Objects.equal((Object)this.myRootPath, (Object)another.myRootPath) && Objects.equal((Object)this.myMetadata.getTitle(), (Object)another.myMetadata.getTitle());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.myMetadata.getTitle()).add("path", (Object)this.myRootPath.getAbsolutePath()).toString();
    }
}

