/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.npw.model.JavaToKotlinHandler;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public final class TemplateValueInjector {
    private final Map<String, Object> myTemplateValues;

    public TemplateValueInjector(@NotNull Map<String, Object> templateValues) {
        this.myTemplateValues = templateValues;
    }

    public TemplateValueInjector setFacet(@NotNull AndroidFacet facet) {
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, facet);
        this.myTemplateValues.put("isNewProject", false);
        this.myTemplateValues.put("isLibraryProject", ((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject());
        String appTheme = MergedManifestManager.getSnapshot(facet).getManifestTheme();
        this.myTemplateValues.put("hasApplicationTheme", appTheme != null);
        Module module = facet.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            IAndroidTarget target = platform.getTarget();
            this.myTemplateValues.put("buildApi", target.getVersion().getFeatureLevel());
            this.myTemplateValues.put("buildApiString", TemplateMetadata.getBuildApiString(target.getVersion()));
            this.myTemplateValues.put("buildApiRevision", target.getVersion().isPreview() ? target.getRevision() : 0);
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet);
        AndroidVersion minSdkVersion2 = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion2.getApiString();
        this.myTemplateValues.put("minApi", minSdkName);
        this.myTemplateValues.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        this.myTemplateValues.put("minApiLevel", minSdkVersion2.getFeatureLevel());
        Project project = module.getProject();
        this.addGradleVersions(project);
        this.addKotlinVersion();
        this.addAndroidxSupport(project);
        int projectType = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType();
        if (projectType == 5) {
            this.setInstantAppSupport(true, project, module.getName());
        } else if (projectType == 6) {
            this.setDynamicFeatureSupport(module);
        }
        return this;
    }

    public TemplateValueInjector setBuildVersion(@NotNull AndroidVersionsInfo.VersionItem buildVersion, @Nullable Project project) {
        BuildToolInfo info;
        TemplateValueInjector.addDebugKeyStore(this.myTemplateValues, null);
        this.myTemplateValues.put("isNewProject", true);
        this.myTemplateValues.put("themeExists", true);
        this.myTemplateValues.put("minApiLevel", buildVersion.getMinApiLevel());
        this.myTemplateValues.put("minApi", buildVersion.getMinApiLevelStr());
        this.myTemplateValues.put("buildApi", buildVersion.getBuildApiLevel());
        this.myTemplateValues.put("buildApiString", buildVersion.getBuildApiLevelStr());
        this.myTemplateValues.put("targetApi", buildVersion.getTargetApiLevel());
        this.myTemplateValues.put("targetApiString", buildVersion.getTargetApiLevelStr());
        IAndroidTarget target = buildVersion.getAndroidTarget();
        this.myTemplateValues.put("buildApiRevision", target == null ? 0 : target.getRevision());
        if (target != null && (info = target.getBuildToolInfo()) != null) {
            this.addBuildToolVersion(project, info.getRevision());
        }
        this.addGradleVersions(project);
        this.addKotlinVersion();
        this.addAndroidxSupport(project);
        return this;
    }

    public TemplateValueInjector setJavaVersion(Project project) {
        LanguageLevel min = (LanguageLevel)ApplicationManager.getApplication().runReadAction(() -> {
            LanguageLevel minResult = null;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                LanguageLevel moduleLevel;
                LanguageLevelModuleExtensionImpl moduleLevelExt = LanguageLevelModuleExtensionImpl.getInstance((Module)module);
                if (moduleLevelExt == null || (moduleLevel = moduleLevelExt.getLanguageLevel()) == null || minResult != null && moduleLevel.compareTo((Enum)minResult) >= 0) continue;
                minResult = moduleLevel;
            }
            return minResult == null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : minResult;
        });
        this.myTemplateValues.put("javaVersion", JpsJavaSdkType.complianceOption((JavaVersion)min.toJavaVersion()));
        return this;
    }

    public TemplateValueInjector setModuleRoots(@NotNull AndroidModuleTemplate paths2, @NotNull String projectPath, @NotNull String moduleName, @NotNull String packageName) {
        File aidlDir;
        File manifestDir;
        File resDir;
        File testDir;
        File moduleRoot = paths2.getModuleRoot();
        assert (moduleRoot != null);
        this.myTemplateValues.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        File srcDir = paths2.getSrcDirectory(packageName);
        if (srcDir != null) {
            this.myTemplateValues.put("srcDir", TemplateValueInjector.getRelativePath(moduleRoot, srcDir));
            this.myTemplateValues.put("srcOut", FileUtil.toSystemIndependentName((String)srcDir.getAbsolutePath()));
        }
        if ((testDir = paths2.getTestDirectory(packageName)) != null) {
            this.myTemplateValues.put("testDir", TemplateValueInjector.getRelativePath(moduleRoot, testDir));
            this.myTemplateValues.put("testOut", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        }
        if ((resDir = (File)Iterables.getFirst(paths2.getResDirectories(), null)) != null) {
            this.myTemplateValues.put("resDir", TemplateValueInjector.getRelativePath(moduleRoot, resDir));
            this.myTemplateValues.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = paths2.getManifestDirectory()) != null) {
            this.myTemplateValues.put("manifestDir", TemplateValueInjector.getRelativePath(moduleRoot, manifestDir));
            this.myTemplateValues.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = paths2.getAidlDirectory(packageName)) != null) {
            this.myTemplateValues.put("aidlDir", TemplateValueInjector.getRelativePath(moduleRoot, aidlDir));
            this.myTemplateValues.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        if (moduleName.startsWith(":")) {
            moduleName = moduleName.substring(1);
        }
        this.myTemplateValues.put("projectLocation", projectPath);
        this.myTemplateValues.put("projectName", moduleName);
        this.myTemplateValues.put("packageName", packageName);
        return this;
    }

    public TemplateValueInjector setProjectDefaults(@Nullable Project project, @NotNull String moduleTitle) {
        this.myTemplateValues.put("appTitle", moduleTitle);
        this.myTemplateValues.put("isLowMemory", SystemInfo.is32Bit);
        this.addGradleVersions(project);
        this.addKotlinVersion();
        this.myTemplateValues.put("isGradle", true);
        this.myTemplateValues.put("target.files", new HashSet());
        this.myTemplateValues.put("files.to.open", new ArrayList());
        this.myTemplateValues.put("createActivity", false);
        if (project != null) {
            this.myTemplateValues.put("topOut", project.getBasePath());
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(ConfigureAndroidModuleStep.class);
        this.addBuildToolVersion(project, GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, (ProgressIndicator)progress));
        File sdkLocation = sdkHandler.getLocation();
        if (sdkLocation != null) {
            this.myTemplateValues.put("sdkDir", sdkLocation.getPath());
        }
        return this;
    }

    public TemplateValueInjector setLanguage(Language language) {
        this.myTemplateValues.put("language", language.getName());
        this.myTemplateValues.put("includeKotlinSupport", language == Language.KOTLIN);
        return this;
    }

    public TemplateValueInjector setInstantAppSupport(boolean isExistingProject, @NotNull Project project, @NotNull String moduleName) {
        this.myTemplateValues.put("isInstantApp", true);
        this.myTemplateValues.put("instantAppApiMinVersion", InstantApps.getCompatApiMinVersion());
        this.myTemplateValues.put("isLibraryProject", true);
        String projectPath = project.getBasePath();
        assert (projectPath != null);
        String defaultResourceSuffix = FileUtil.join((String[])new String[]{"src", "main", "res"});
        File projectRoot = new File(projectPath);
        File baseModuleRoot = new File(projectRoot, "base");
        File baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
        Module baseFeature = null;
        if (isExistingProject && (baseFeature = InstantApps.findBaseFeature(project)) == null) {
            baseModuleRoot = new File(projectRoot, moduleName);
            baseModuleResourceRoot = new File(baseModuleRoot, defaultResourceSuffix);
            this.myTemplateValues.put("isBaseFeature", true);
            String monolithicModuleName = InstantApps.findMonolithicModuleName(project);
            if (monolithicModuleName != null) {
                this.myTemplateValues.put("monolithicModuleName", monolithicModuleName);
            }
        }
        if (baseFeature == null) {
            this.myTemplateValues.put("baseFeatureName", baseModuleRoot.getName());
            this.myTemplateValues.put("baseFeatureDir", baseModuleRoot.getPath());
            this.myTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
        } else {
            this.setBaseFeature(baseFeature);
        }
        return this;
    }

    public TemplateValueInjector setDynamicFeatureSupport(@NotNull Module module) {
        this.myTemplateValues.put("isDynamicFeature", true);
        Module baseFeature = DynamicAppUtils.getBaseFeature(module);
        if (baseFeature == null) {
            throw new RuntimeException("Dynamic Feature Module '" + module.getName() + "' has no Base Module");
        }
        return this.setBaseFeature(baseFeature);
    }

    public TemplateValueInjector setBaseFeature(@NotNull Module baseFeature) {
        AndroidModuleModel moduleModel = AndroidModuleModel.get(baseFeature);
        assert (moduleModel != null);
        File baseModuleRoot = moduleModel.getRootDirPath();
        Collection resDirectories = moduleModel.getDefaultSourceProvider().getResDirectories();
        assert (!resDirectories.isEmpty());
        File baseModuleResourceRoot = (File)resDirectories.iterator().next();
        this.myTemplateValues.put("baseFeatureName", baseModuleRoot.getName());
        this.myTemplateValues.put("baseFeatureDir", baseModuleRoot.getPath());
        this.myTemplateValues.put("baseFeatureResDir", baseModuleResourceRoot.getPath());
        return this;
    }

    public void addGradleVersions(@Nullable Project project) {
        this.myTemplateValues.put("gradlePluginVersion", TemplateValueInjector.determineGradlePluginVersion(project).toString());
        this.myTemplateValues.put("gradleVersion", "5.4.1");
    }

    public TemplateValueInjector addTemplateAdditionalValues(@NotNull String packageName, boolean isInstantApp, @NotNull ObjectProperty<NamedModuleTemplate> template) {
        this.myTemplateValues.put("packageName", packageName);
        this.myTemplateValues.put("sourceProviderName", ((NamedModuleTemplate)template.get()).getName());
        this.myTemplateValues.put("isInstantApp", isInstantApp);
        this.myTemplateValues.put("companyDomain", NewProjectModel.getInitialDomain(false));
        return this;
    }

    private void addKotlinVersion() {
        ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
        String kotlinVersion = provider.getKotlinVersion();
        this.myTemplateValues.put("kotlinVersion", kotlinVersion);
        if (this.isEAP(kotlinVersion)) {
            this.myTemplateValues.put("includeKotlinEapRepo", true);
            this.myTemplateValues.put("kotlinEapRepoUrl", "https://dl.bintray.com/kotlin/kotlin-eap");
        }
    }

    private boolean isEAP(String version2) {
        return version2.contains("rc") || version2.contains("eap") || version2.contains("-M");
    }

    private void addBuildToolVersion(@Nullable Project project, @NotNull Revision buildToolRevision) {
        GradleVersion gradlePluginVersion = TemplateValueInjector.determineGradlePluginVersion(project);
        this.myTemplateValues.put("buildToolsVersion", buildToolRevision.toString());
        this.myTemplateValues.put("explicitBuildToolsVersion", GradleBuildSettings.needsExplicitBuildToolsVersion(gradlePluginVersion, buildToolRevision));
    }

    private void addAndroidxSupport(@Nullable Project project) {
        if (project != null) {
            this.myTemplateValues.put("addAndroidXSupport", MigrateToAndroidxUtil.isAndroidx(project));
        }
    }

    private static void addDebugKeyStore(@NotNull Map<String, Object> templateValues, @Nullable AndroidFacet facet) {
        try {
            File sha1File = facet == null ? KeystoreUtils.getOrCreateDefaultDebugKeystore() : KeystoreUtils.getDebugKeystore(facet);
            templateValues.put("debugKeystoreSha1", KeystoreUtils.sha1(sha1File));
        }
        catch (Exception e) {
            TemplateValueInjector.getLog().info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateValues.put("debugKeystoreSha1", "");
        }
    }

    @Nullable
    private static String getRelativePath(@NotNull File base, @NotNull File file) {
        return FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)base.getPath()), (String)FileUtil.toSystemIndependentName((String)file.getPath()), (char)'/');
    }

    @NotNull
    private static GradleVersion determineGradlePluginVersion(@Nullable Project project) {
        GradleVersion defaultGradleVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        if (project == null) {
            return defaultGradleVersion;
        }
        GradleVersion versionInUse = GradleUtil.getAndroidGradleModelVersionInUse(project);
        if (versionInUse != null) {
            return versionInUse;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromBuildFiles(project);
        GradleVersion pluginVersion = androidPluginInfo == null ? null : androidPluginInfo.getPluginVersion();
        return pluginVersion == null ? defaultGradleVersion : pluginVersion;
    }

    private static Logger getLog() {
        return Logger.getInstance(TemplateValueInjector.class);
    }
}

