/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ParameterComponentProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EnumComboProvider
extends ParameterComponentProvider<JComboBox> {
    public EnumComboProvider(@NotNull Parameter parameter) {
        super(parameter);
    }

    private static ApiComboBoxItem<String> createItemForOption(@NotNull Parameter parameter, @NotNull Element option) {
        String optionId = option.getAttribute("id");
        assert (optionId != null && !optionId.isEmpty()) : "id";
        NodeList childNodes2 = option.getChildNodes();
        assert (childNodes2.getLength() == 1 && childNodes2.item(0).getNodeType() == 3);
        String optionLabel = childNodes2.item(0).getNodeValue().trim();
        int minSdk = EnumComboProvider.getIntegerOptionValue(option, "minApi", parameter.name, 1);
        int minBuildApi = EnumComboProvider.getIntegerOptionValue(option, "minBuildApi", parameter.name, 1);
        return new ApiComboBoxItem<String>(optionId, optionLabel, minSdk, minBuildApi);
    }

    private static int getIntegerOptionValue(@NotNull Element option, String attribute, @Nullable String parameterName, int defaultValue) {
        String stringValue = option.getAttribute(attribute);
        try {
            return StringUtil.isEmpty((String)stringValue) ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            EnumComboProvider.getLog().warn(String.format("Invalid %1$s value (%2$s) for option %3$s in parameter %4$s", attribute, stringValue, option.getAttribute("id"), parameterName), (Throwable)e);
            return defaultValue;
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(EnumComboProvider.class);
    }

    @Override
    @NotNull
    protected JComboBox createComponent(@NotNull Parameter parameter) {
        List<Element> options = parameter.getOptions();
        DefaultComboBoxModel<ApiComboBoxItem<String>> comboBoxModel = new DefaultComboBoxModel<ApiComboBoxItem<String>>();
        assert (!options.isEmpty());
        for (Element option : options) {
            comboBoxModel.addElement(EnumComboProvider.createItemForOption(parameter, option));
        }
        return new JComboBox(comboBoxModel);
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull JComboBox comboBox) {
        return new ApiComboBoxTextProperty(comboBox);
    }

    private static class ApiComboBoxTextProperty
    extends AbstractProperty<String>
    implements ActionListener {
        @NotNull
        private final JComboBox myComboBox;

        public ApiComboBoxTextProperty(@NotNull JComboBox comboBox) {
            this.myComboBox = comboBox;
            this.myComboBox.addActionListener(this);
        }

        @Override
        protected void setDirectly(@NotNull String value2) {
            int index = -1;
            DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.myComboBox.getModel();
            for (int i2 = 0; i2 < model2.getSize(); ++i2) {
                ApiComboBoxItem item = (ApiComboBoxItem)model2.getElementAt(i2);
                if (!value2.equals(item.getData())) continue;
                index = i2;
                break;
            }
            this.myComboBox.setSelectedIndex(index);
        }

        @Override
        @NotNull
        public String get() {
            ApiComboBoxItem item = (ApiComboBoxItem)this.myComboBox.getSelectedItem();
            return item != null ? (String)item.getData() : "";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyInvalidated();
        }
    }
}

