/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template.components;

import com.android.tools.idea.npw.template.components.ComponentProvider;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.intellij.ui.ListCellRendererWrapper;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleTemplateComboProvider
extends ComponentProvider<JComboBox> {
    @NotNull
    private final List<NamedModuleTemplate> myTemplates;

    public ModuleTemplateComboProvider(@NotNull List<NamedModuleTemplate> templates) {
        this.myTemplates = templates;
    }

    @Override
    @NotNull
    public JComboBox createComponent() {
        DefaultComboBoxModel<NamedModuleTemplate> comboBoxModel = new DefaultComboBoxModel<NamedModuleTemplate>();
        for (NamedModuleTemplate template : this.myTemplates) {
            comboBoxModel.addElement(template);
        }
        JComboBox moduleTemplateCombo = new JComboBox(comboBoxModel);
        moduleTemplateCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                this.setText(((NamedModuleTemplate)value2).getName());
            }
        });
        moduleTemplateCombo.setToolTipText("<html>The source set within which to generate new project files.<br>If you specify a source set that does not yet exist on disk, a folder will be created for it.</html>");
        return moduleTemplateCombo;
    }

    @Override
    @Nullable
    public AbstractProperty<?> createProperty(@NotNull JComboBox moduleTemplateCombo) {
        return new SelectedItemProperty(moduleTemplateCombo);
    }
}

