/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ui;

import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.TemplateIcon;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityGallery {
    @Nullable
    public static TemplateIcon getTemplateIcon(@Nullable TemplateHandle templateHandle, boolean isCppTemplate) {
        String thumb;
        if (isCppTemplate) {
            return new TemplateIcon(AndroidIcons.Wizards.CppConfiguration);
        }
        String string = thumb = templateHandle == null ? null : templateHandle.getMetadata().getThumbnailPath();
        if (thumb != null && !thumb.isEmpty()) {
            try {
                File file = new File(templateHandle.getRootPath(), thumb.replace('/', File.separatorChar));
                Icon icon2 = IconLoader.findIcon((URL)file.toURI().toURL());
                return icon2 != null ? new TemplateIcon(icon2) : null;
            }
            catch (IOException e) {
                Logger.getInstance(ActivityGallery.class).warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static String getTemplateImageLabel(@Nullable TemplateHandle templateHandle, boolean isCppTemplate) {
        if (isCppTemplate) {
            return AndroidBundle.message("android.wizard.gallery.item.add.cpp", new Object[0]);
        }
        if (templateHandle == null) {
            return AndroidBundle.message("android.wizard.gallery.item.add.no.activity", new Object[0]);
        }
        String title = templateHandle.getMetadata().getTitle();
        return title == null ? "" : title;
    }

    @NotNull
    public static String getTemplateDescription(@Nullable TemplateHandle templateHandle, boolean isCppTemplate) {
        if (isCppTemplate) {
            return AndroidBundle.message("android.wizard.gallery.item.add.cpp.Desc", new Object[0]);
        }
        if (templateHandle == null) {
            return AndroidBundle.message("android.wizard.gallery.item.add.no.activity.desc", new Object[0]);
        }
        String description = templateHandle.getMetadata().getDescription();
        return description == null ? "" : description;
    }
}

