/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ui;

import com.android.tools.adtui.ImageUtils;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TemplateIcon
extends JBUI.ScalableJBIcon {
    private Icon myDelegateIcon;
    private float myScale = 1.0f;
    private Rectangle myCropRectangle;

    public TemplateIcon(@NotNull Icon icon2) {
        this.myDelegateIcon = icon2;
        this.myCropRectangle = new Rectangle(this.myDelegateIcon.getIconWidth(), this.myDelegateIcon.getIconHeight());
    }

    private void setScale(float scale) {
        this.myScale = scale;
        this.myCropRectangle = new Rectangle((int)((float)this.myCropRectangle.x * this.myScale), (int)((float)this.myCropRectangle.y * this.myScale), (int)((float)this.myCropRectangle.width * this.myScale), (int)((float)this.myCropRectangle.height * this.myScale));
    }

    public void setHeight(int height) {
        this.setScale((float)height / (float)this.myCropRectangle.height);
    }

    public void cropBlankWidth() {
        BufferedImage image = ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)this.myDelegateIcon), (boolean)true);
        Rectangle cropBounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
        if (cropBounds != null) {
            this.myCropRectangle.x = cropBounds.x;
            this.myCropRectangle.width = cropBounds.width;
        }
    }

    @NotNull
    public Icon scale(float scale) {
        this.setScale(scale);
        return this;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon2 = IconUtil.scale((Icon)this.myDelegateIcon, (Component)c, (float)this.myScale);
        icon2.paintIcon(c, g, x - this.myCropRectangle.x, y);
    }

    public int getIconWidth() {
        return this.myCropRectangle.width;
    }

    public int getIconHeight() {
        return this.myCropRectangle.height;
    }
}

