/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.validator;

import com.android.tools.adtui.validation.Validator;
import com.google.common.base.CharMatcher;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class ProjectNameValidator
implements Validator<String> {
    private static final CharMatcher DISALLOWED_IN_PROJECT_NAME = CharMatcher.anyOf((CharSequence)"/\\:<>\"?*|");

    @NotNull
    public Validator.Result validate(@NotNull String name) {
        if (name.isEmpty()) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.application.name", new Object[0]));
        }
        int illegalCharIdx = DISALLOWED_IN_PROJECT_NAME.indexIn((CharSequence)name);
        if (illegalCharIdx >= 0) {
            return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.project.illegal.character", Character.valueOf(name.charAt(illegalCharIdx)), name));
        }
        if (!Character.isUpperCase(name.charAt(0))) {
            return new Validator.Result(Validator.Severity.INFO, AndroidBundle.message("android.wizard.validate.lowercase.application.name", new Object[0]));
        }
        return Validator.Result.OK;
    }
}

