/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractObservableValue<T>
implements ObservableValue<T> {
    private final List<InvalidationListener> myListeners = new ArrayList<InvalidationListener>(0);
    private final List<WeakReference<InvalidationListener>> myWeakListeners = new ArrayList<WeakReference<InvalidationListener>>(0);
    private boolean myNotificationsEnabled = true;

    @Override
    public final void addListener(@NotNull InvalidationListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public final void removeListener(@NotNull InvalidationListener listener2) {
        this.myListeners.remove(listener2);
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener l = (InvalidationListener)it.next().get();
            if (l != null && l != listener2) continue;
            it.remove();
        }
    }

    @Override
    public final void addWeakListener(@NotNull InvalidationListener listener2) {
        this.myWeakListeners.add(new WeakReference<InvalidationListener>(listener2));
    }

    protected final void notifyInvalidated() {
        if (!this.myNotificationsEnabled) {
            return;
        }
        for (InvalidationListener listener2 : this.myListeners) {
            listener2.onInvalidated();
        }
        Iterator<WeakReference<InvalidationListener>> it = this.myWeakListeners.iterator();
        while (it.hasNext()) {
            InvalidationListener listener2;
            listener2 = (InvalidationListener)it.next().get();
            if (listener2 != null) {
                listener2.onInvalidated();
                continue;
            }
            it.remove();
        }
    }

    protected final void setNotificationsEnabled(boolean enabled) {
        this.myNotificationsEnabled = enabled;
    }
}

