/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.google.common.collect.Queues;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatchInvoker {
    public static final Strategy SWING_INVOKE_LATER_STRATEGY = SwingUtilities::invokeLater;
    public static final Strategy INVOKE_IMMEDIATELY_STRATEGY = Runnable::run;
    private static final int MAX_CYCLE_COUNT = 10;
    private static Strategy ourOverrideStrategy = null;
    private final Strategy myStrategy;
    private final Queue<Runnable> myRunnables = Queues.newArrayDeque();
    private final Queue<Runnable> myDeferredRunnables = Queues.newArrayDeque();
    private boolean myUpdateInProgress;

    public BatchInvoker() {
        this(ourOverrideStrategy != null ? ourOverrideStrategy : SWING_INVOKE_LATER_STRATEGY);
    }

    public BatchInvoker(@NotNull Strategy strategy) {
        this.myStrategy = strategy;
    }

    public void enqueue(@NotNull Runnable runnable) {
        if (this.myUpdateInProgress) {
            if (!this.myDeferredRunnables.contains(runnable)) {
                this.myDeferredRunnables.add(runnable);
            }
            return;
        }
        boolean shouldInvoke = this.myRunnables.isEmpty();
        if (!this.myRunnables.contains(runnable)) {
            this.myRunnables.add(runnable);
        }
        if (shouldInvoke) {
            this.enqueueInvoke();
        }
    }

    private void enqueueInvoke() {
        this.myStrategy.invoke(() -> {
            int cycleCount = 0;
            RuntimeException runnableExceptionChain = null;
            while (true) {
                this.myUpdateInProgress = true;
                for (Runnable runnable : this.myRunnables) {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException ex) {
                        runnableExceptionChain = BatchInvoker.addExceptionCause(ex, runnableExceptionChain);
                    }
                }
                this.myRunnables.clear();
                this.myUpdateInProgress = false;
                if (this.myDeferredRunnables.isEmpty()) break;
                if (++cycleCount > 10) {
                    this.myDeferredRunnables.clear();
                    throw new InfiniteCycleException(runnableExceptionChain);
                }
                this.myRunnables.addAll(this.myDeferredRunnables);
                this.myDeferredRunnables.clear();
            }
            if (runnableExceptionChain != null) {
                throw runnableExceptionChain;
            }
        });
    }

    public static void setOverrideStrategy(Strategy overrideStrategy) {
        ourOverrideStrategy = overrideStrategy;
    }

    public static void clearOverrideStrategy() {
        ourOverrideStrategy = null;
    }

    private static RuntimeException addExceptionCause(@NotNull RuntimeException ex, @Nullable RuntimeException cause) {
        if (cause != null) {
            Throwable tail = ex;
            while (tail.getCause() != null) {
                tail = ex.getCause();
            }
            tail.initCause(cause);
        }
        return ex;
    }

    public static final class InfiniteCycleException
    extends RuntimeException {
        public InfiniteCycleException(@Nullable Throwable cause) {
            super("Endless invocation cycle detected.", cause);
        }
    }

    public static interface Strategy {
        public void invoke(@NotNull Runnable var1);
    }
}

