/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.adapters;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdapterProperty<S, D>
extends AbstractProperty<D>
implements InvalidationListener {
    @NotNull
    private final AbstractProperty<S> myWrappedProperty;
    private final BoolProperty myInSync = new BoolValueProperty();
    @NotNull
    private D myLastValue;
    private boolean myNeedsInitialSync = true;

    public AdapterProperty(@NotNull AbstractProperty<S> wrappedProperty, @NotNull D initialValue) {
        this.myLastValue = initialValue;
        this.myWrappedProperty = wrappedProperty;
        this.myWrappedProperty.addWeakListener(this);
    }

    @Override
    protected final void setDirectly(@NotNull D value2) {
        this.myWrappedProperty.set(this.convertFromDestType(value2));
    }

    @Override
    @NotNull
    public final D get() {
        this.doInitialSync();
        return this.myLastValue;
    }

    @NotNull
    public ObservableBool inSync() {
        this.doInitialSync();
        return this.myInSync;
    }

    @Override
    public final void onInvalidated() {
        this.trySync();
        this.notifyInvalidated();
    }

    @Nullable
    protected abstract D convertFromSourceType(@NotNull S var1);

    @NotNull
    protected abstract S convertFromDestType(@NotNull D var1);

    private void doInitialSync() {
        if (this.myNeedsInitialSync) {
            this.trySync();
        }
    }

    private void trySync() {
        D result2 = this.convertFromSourceType(this.myWrappedProperty.get());
        this.myInSync.set(result2 != null);
        if (result2 != null) {
            this.myLastValue = result2;
        }
        this.myNeedsInitialSync = false;
    }
}

