/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.collections;

import com.android.tools.idea.observable.AbstractObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingListIterator;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObservableList<E>
extends AbstractObservableValue<List<? extends E>>
implements List<E>,
SettableValue<List<? extends E>> {
    @NotNull
    private List<E> myInnerList;
    private int myUpdateCount;
    private boolean myInvalidatedWhileUpdating;

    public ObservableList() {
        this.myInnerList = Lists.newArrayList();
    }

    public ObservableList(@NotNull Iterable<? extends E> otherCollection) {
        this.myInnerList = Lists.newArrayList(otherCollection);
    }

    public void beginUpdate() {
        ++this.myUpdateCount;
    }

    public void endUpdate() {
        if (this.myUpdateCount == 0) {
            throw new IllegalStateException("Can't call ObservableList.endUpdate without matching beginUpdate");
        }
        --this.myUpdateCount;
        if (this.myUpdateCount == 0 && this.myInvalidatedWhileUpdating) {
            this.myInvalidatedWhileUpdating = false;
            this.notifyInvalidated();
        }
    }

    private void notifyContentsChanged() {
        if (this.myUpdateCount > 0) {
            this.myInvalidatedWhileUpdating = true;
            return;
        }
        this.notifyInvalidated();
    }

    @Override
    public int size() {
        return this.myInnerList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myInnerList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myInnerList.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ObservableIterator(this.myInnerList.iterator());
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.myInnerList.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        return this.myInnerList.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean added = this.myInnerList.add(e);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.myInnerList.remove(o);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myInnerList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    public boolean setAll(@NotNull Collection<? extends E> c) {
        boolean changed;
        this.beginUpdate();
        boolean cleared = false;
        if (!this.myInnerList.isEmpty()) {
            this.myInnerList.clear();
            cleared = true;
        }
        boolean added = this.myInnerList.addAll(c);
        boolean bl = changed = cleared || added;
        if (changed) {
            this.notifyContentsChanged();
        }
        this.endUpdate();
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added = this.myInnerList.addAll(index, c);
        if (added) {
            this.notifyContentsChanged();
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = this.myInnerList.removeAll(c);
        if (removed) {
            this.notifyContentsChanged();
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retained = this.myInnerList.retainAll(c);
        if (retained) {
            this.notifyContentsChanged();
        }
        return retained;
    }

    @Override
    public void clear() {
        if (this.myInnerList.isEmpty()) {
            return;
        }
        this.myInnerList.clear();
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.myInnerList.get(index);
    }

    @Override
    @Nullable
    public E set(int index, E element) {
        E result2 = this.myInnerList.set(index, element);
        this.notifyContentsChanged();
        return result2;
    }

    @Override
    public void add(int index, E element) {
        this.myInnerList.add(index, element);
        this.notifyContentsChanged();
    }

    @Override
    @Nullable
    public E remove(int index) {
        E result2 = this.myInnerList.remove(index);
        this.notifyContentsChanged();
        return result2;
    }

    @Override
    public int indexOf(Object o) {
        return this.myInnerList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myInnerList.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new ObservableListIterator(this.myInnerList.listIterator());
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new ObservableListIterator(this.myInnerList.listIterator(index));
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return this.myInnerList.subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return this.myInnerList.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.myInnerList.equals(o)) {
            return true;
        }
        if (o != null && o instanceof ObservableList) {
            return ((ObservableList)o).myInnerList.equals(this.myInnerList);
        }
        return false;
    }

    public String toString() {
        return this.myInnerList.toString();
    }

    @Override
    @NotNull
    public List<E> get() {
        return this.myInnerList;
    }

    @Override
    public void set(@NotNull List<? extends E> value2) {
        this.setAll(value2);
    }

    private class ObservableListIterator
    extends ForwardingListIterator<E> {
        @NotNull
        private final ListIterator<E> myInner;

        public ObservableListIterator(ListIterator<E> inner) {
            this.myInner = inner;
        }

        protected ListIterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }

        public void set(@NotNull E e) {
            this.myInner.set(e);
            ObservableList.this.notifyContentsChanged();
        }

        public void add(@NotNull E e) {
            this.myInner.add(e);
            ObservableList.this.notifyContentsChanged();
        }
    }

    private class ObservableIterator
    extends ForwardingIterator<E> {
        private final Iterator<E> myInner;

        public ObservableIterator(Iterator<E> inner) {
            this.myInner = inner;
        }

        protected Iterator<E> delegate() {
            return this.myInner;
        }

        public void remove() {
            this.myInner.remove();
            ObservableList.this.notifyContentsChanged();
        }
    }
}

