/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    private static final String STARTUP_AGENT_CONFIG_NAME = "startupagent.config";

    private static Logger getLogger() {
        return Logger.getInstance(AndroidProfilerLaunchTaskContributor.class);
    }

    @Override
    @NotNull
    public LaunchTask getTask(@NotNull Module module, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions) {
        return new AndroidProfilerToolWindowLaunchTask(module, launchOptions);
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull Module module, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        long deviceId;
        if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(launchOptions)) {
            return "";
        }
        Project project = module.getProject();
        TransportService transportService = TransportService.getInstance();
        if (transportService == null) {
            return "";
        }
        ProfilerClient client = new ProfilerClient(transportService.getChannelName());
        try {
            deviceId = AndroidProfilerLaunchTaskContributor.waitForPerfd(device, client);
        }
        catch (TimeoutException | InterruptedException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            return "";
        }
        TransportFileManager fileManager = new TransportFileManager(device, transportService.getMessageBus());
        this.pushStartupAgentConfig(fileManager, project);
        String agentArgs = fileManager.configureStartupAgent(applicationId2, STARTUP_AGENT_CONFIG_NAME);
        String startupProfilingResult = AndroidProfilerLaunchTaskContributor.startStartupProfiling(applicationId2, project, client, device, deviceId);
        return String.format("%s %s", agentArgs, startupProfilingResult);
    }

    private void pushStartupAgentConfig(@NotNull TransportFileManager fileManager, @NotNull Project project) {
        try {
            fileManager.pushAgentConfig(STARTUP_AGENT_CONFIG_NAME, AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (AdbCommandRejectedException | IOException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().warn("Error when trying to push AgentConfig:", e);
        }
    }

    @NotNull
    private static String startStartupProfiling(@NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, long deviceId) {
        if (!((Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get()).booleanValue()) {
            return "";
        }
        AndroidRunConfigurationBase runConfig = AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project);
        if (runConfig == null || !runConfig.getProfilerState().STARTUP_CPU_PROFILING_ENABLED) {
            return "";
        }
        String configName = runConfig.getProfilerState().STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(project).getConfigByName(configName);
        if (startupConfig == null) {
            return "";
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeastO(device)) {
            AndroidNotification.getInstance(project).showBalloon("Startup CPU Profiling", "Starting a method trace recording on startup is only supported on devices with API levels 26 and higher.", NotificationType.WARNING);
            return "";
        }
        CpuProfiler.StartupProfilingRequest.Builder requestBuilder = CpuProfiler.StartupProfilingRequest.newBuilder().setAppPackage(appPackageName).setDeviceId(deviceId).setConfiguration(CpuProfilerConfigConverter.toProto(startupConfig));
        if (requestBuilder.getConfiguration().getTraceType() == Cpu.CpuTraceType.SIMPLEPERF) {
            requestBuilder.setAbiCpuArch(AndroidProfilerLaunchTaskContributor.getAbiDependentCommonLibName("simpleperf", "simpleperf", device));
        } else if (requestBuilder.getConfiguration().getTraceType() == Cpu.CpuTraceType.ATRACE) {
            requestBuilder.setAbiCpuArch(AndroidProfilerLaunchTaskContributor.getAbiDependentCommonLibName("perfetto", "perfetto", device));
        }
        CpuProfiler.StartupProfilingResponse response = client.getCpuClient().startStartupProfiling(requestBuilder.build());
        if (response.getFilePath().isEmpty() || requestBuilder.getConfiguration().getTraceType() != Cpu.CpuTraceType.ART) {
            return "";
        }
        StringBuilder argsBuilder = new StringBuilder("--start-profiler ").append(response.getFilePath());
        if (startupConfig.getTechnology() == CpuProfilerConfig.Technology.SAMPLED_JAVA) {
            argsBuilder.append(" --sampling ").append(startupConfig.getSamplingIntervalUs());
        }
        argsBuilder.append(" --streaming");
        return argsBuilder.toString();
    }

    private static boolean isAtLeastO(@NotNull IDevice device) {
        return device.getVersion().getFeatureLevel() >= 26;
    }

    @Nullable
    private static AndroidRunConfigurationBase getSelectedRunConfiguration(@NotNull Project project) {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            return (AndroidRunConfigurationBase)settings.getConfiguration();
        }
        return null;
    }

    private static long waitForPerfd(@NotNull IDevice device, @NotNull ProfilerClient client) throws InterruptedException, TimeoutException {
        for (int i2 = 0; i2 < 60; ++i2) {
            Common.Device profilerDevice = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, client);
            if (!Common.Device.getDefaultInstance().equals((Object)profilerDevice)) {
                return profilerDevice.getDeviceId();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        throw new TimeoutException("Timeout waiting for perfd");
    }

    @NotNull
    private static Common.Device getProfilerDevice(@NotNull IDevice device, @NotNull ProfilerClient client) {
        List devices = StudioProfilers.getUpToDateDevices((boolean)((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()), (ProfilerClient)client, null);
        for (Common.Device profilerDevice : devices) {
            if (!profilerDevice.getSerial().equals(device.getSerialNumber()) || profilerDevice.getState() != Common.Device.State.ONLINE) continue;
            return profilerDevice;
        }
        return Common.Device.getDefaultInstance();
    }

    @NotNull
    private static String getAbiDependentCommonLibName(String dir, String fileName, IDevice device) {
        return AndroidProfilerLaunchTaskContributor.getBestAbiCpuArch(device, "plugins/android/resources/" + dir, "../../prebuilts/tools/common/" + dir, fileName);
    }

    @NotNull
    private static String getBestAbiCpuArch(@NotNull IDevice device, @NotNull String releaseDir, @NotNull String devDir, @NotNull String fileName) {
        File dir = new File(PathManager.getHomePath(), releaseDir);
        if (!dir.exists()) {
            dir = new File(PathManager.getHomePath(), devDir);
        }
        for (String abi : device.getAbis()) {
            File candidate = new File(dir, abi + "/" + fileName);
            if (!candidate.exists()) continue;
            return Abi.getEnum((String)abi).getCpuArch();
        }
        return "";
    }

    private static boolean isProfilerLaunch(@NotNull LaunchOptions options) {
        Object launchValue = options.getExtraOption("isProfiling");
        return launchValue instanceof Boolean && (Boolean)launchValue != false;
    }

    public static final class AndroidProfilerToolWindowLaunchTask
    implements LaunchTask {
        private static final String ID = "PROFILER_TOOLWINDOW";
        @NotNull
        private final Module myModule;
        @NotNull
        private final LaunchOptions myLaunchOptions;

        public AndroidProfilerToolWindowLaunchTask(@NotNull Module module, @NotNull LaunchOptions launchOptions) {
            this.myModule = module;
            this.myLaunchOptions = launchOptions;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Launching the Profiler Tool Window";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @Override
        public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
            long currentDeviceTimeNs = this.getCurrentDeviceTime(device);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = this.myModule.getProject();
                ToolWindow window = ToolWindowManagerEx.getInstanceEx((Project)project).getToolWindow("Android Profiler");
                if (window != null) {
                    AndroidProfilerToolWindow profilerToolWindow;
                    window.setShowStripeButton(true);
                    String deviceName = AndroidProfilerToolWindow.getDeviceDisplayName(device);
                    String processName = AndroidProfilerToolWindow.getModuleName(this.myModule);
                    AndroidProfilerToolWindow.PreferredProcessInfo preferredProcessInfo = new AndroidProfilerToolWindow.PreferredProcessInfo(deviceName, processName, p -> p.getStartTimestampNs() >= currentDeviceTimeNs);
                    boolean profileStarted = false;
                    if (window.isVisible() && (profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project)) != null) {
                        profilerToolWindow.profile(preferredProcessInfo);
                        profileStarted = true;
                    }
                    if (!profileStarted) {
                        project.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, (Object)preferredProcessInfo);
                    }
                }
            });
            if (launchStatus instanceof ProcessHandlerLaunchStatus) {
                final ProcessHandler processHandler = ((ProcessHandlerLaunchStatus)launchStatus).getProcessHandler();
                ProcessAdapter adapter = new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        myModule.getProject().putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                        processHandler.removeProcessListener((ProcessListener)this);
                    }
                };
                processHandler.addProcessListener((ProcessListener)adapter);
            }
            return true;
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        private long getCurrentDeviceTime(@NotNull IDevice device) {
            long startTimeNs = Long.MIN_VALUE;
            if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions) && !TransportService.isServiceInitialized()) {
                return startTimeNs;
            }
            TransportService transportService = TransportService.getInstance();
            if (transportService == null) {
                return startTimeNs;
            }
            ProfilerClient client = new ProfilerClient(transportService.getChannelName());
            long deviceId = -1L;
            if (AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions)) {
                try {
                    deviceId = AndroidProfilerLaunchTaskContributor.waitForPerfd(device, client);
                }
                catch (TimeoutException | InterruptedException e) {
                    AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
                }
            } else {
                deviceId = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, client).getDeviceId();
            }
            Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
            if (!Transport.TimeResponse.getDefaultInstance().equals((Object)timeResponse)) {
                startTimeNs = timeResponse.getTimestampNs();
            }
            return startTimeNs;
        }
    }
}

