/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.stacktrace.IntellijCodeNavigator;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import icons.StudioIcons;
import icons.StudioIllustrations;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindow
implements Disposable {
    static final Key<PreferredProcessInfo> LAST_RUN_APP_INFO = Key.create((String)"Profiler.Last.Run.App");
    private static final String HIDE_STOP_PROMPT = "profilers.hide.stop.prompt";
    @NotNull
    private static final Notification OPEN_FILE_FAILURE_NOTIFICATION = new Notification.Builder("Failed to open file", "The profiler was unable to open the selected file. Please try opening it again or select a different file.").setSeverity(Notification.Severity.ERROR).build();
    private static final String NO_CLIENT_TITLE = "Initialization failed";
    private static final String NO_CLIENT_MESSAGE = "To start the profiler, close all other Android Studio projects.";
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private StudioProfilersWrapper myProfilersWrapper;
    @NotNull
    private final ToolWindow myWindow;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IntellijProfilerServices myIdeProfilerServices;

    public AndroidProfilerToolWindow(@NotNull ToolWindow window, @NotNull Project project) {
        this.myWindow = window;
        this.myProject = project;
        this.myIdeProfilerServices = new IntellijProfilerServices(this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myIdeProfilerServices);
        this.myPanel = new JPanel(new BorderLayout());
        if (!this.tryInitializeProfilers()) {
            this.myIdeProfilerServices.getFeatureTracker().trackProfilerInitializationFailed();
            this.myPanel.add(this.buildInitializationFailedUi());
        }
    }

    private boolean tryInitializeProfilers() {
        if (this.myProfilersWrapper != null) {
            return true;
        }
        TransportService service = TransportService.getInstance();
        if (service == null) {
            return false;
        }
        this.myProfilersWrapper = new StudioProfilersWrapper(this.myProject, this.myWindow, service, this.myIdeProfilerServices);
        Disposer.register((Disposable)this, (Disposable)this.myProfilersWrapper);
        this.myPanel.removeAll();
        this.myPanel.add(this.myProfilersWrapper.getProfilersView().getComponent());
        this.myPanel.revalidate();
        this.myPanel.repaint();
        return true;
    }

    @NotNull
    private JComponent buildInitializationFailedUi() {
        JPanel panel2 = new JPanel();
        BoxLayout layout2 = new BoxLayout(panel2, 1);
        panel2.setLayout(layout2);
        panel2.add(Box.createVerticalGlue());
        panel2.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        JLabel icon2 = new JLabel(StudioIllustrations.Common.DISCONNECT_PROFILER);
        icon2.setHorizontalAlignment(0);
        icon2.setAlignmentX(0.5f);
        panel2.add(icon2);
        JLabel title = new JLabel(NO_CLIENT_TITLE);
        title.setHorizontalAlignment(0);
        title.setAlignmentX(0.5f);
        title.setFont(ProfilerFonts.H1_FONT);
        title.setForeground(ProfilerColors.MESSAGE_COLOR);
        panel2.add(title);
        panel2.add(Box.createRigidArea(new Dimension(1, 15)));
        JLabel message2 = new JLabel(NO_CLIENT_MESSAGE);
        message2.setHorizontalAlignment(0);
        message2.setAlignmentX(0.5f);
        message2.setFont(ProfilerFonts.STANDARD_FONT);
        message2.setForeground(ProfilerColors.MESSAGE_COLOR);
        panel2.add(message2);
        panel2.add(Box.createVerticalGlue());
        return panel2;
    }

    @Nullable
    StudioProfilers getProfilers() {
        return this.myProfilersWrapper != null ? this.myProfilersWrapper.getProfilers() : null;
    }

    public void profile(@NotNull PreferredProcessInfo processInfo) {
        if (this.tryInitializeProfilers()) {
            StudioProfilers profilers = this.myProfilersWrapper.getProfilers();
            profilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
        }
    }

    void disableAutoProfiling() {
        if (this.tryInitializeProfilers()) {
            StudioProfilers profilers = this.myProfilersWrapper.getProfilers();
            profilers.setAutoProfilingEnabled(false);
        }
    }

    public void openFile(@NotNull VirtualFile file) {
        StudioProfilers profilers;
        if (this.tryInitializeProfilers() && !(profilers = this.myProfilersWrapper.getProfilers()).getSessionsManager().importSessionFromFile(new File(file.getPath()))) {
            profilers.getIdeServices().showNotification(OPEN_FILE_FAILURE_NOTIFICATION);
        }
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    private static String getPreferredProcessName(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String moduleName = AndroidProfilerToolWindow.getModuleName(module);
            if (moduleName == null) continue;
            return moduleName;
        }
        return null;
    }

    @Nullable
    static String getModuleName(@NotNull Module module) {
        String pkg;
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
        if (moduleInfo != null && (pkg = moduleInfo.getPackage()) != null) {
            return pkg;
        }
        return null;
    }

    @NotNull
    static String getDeviceDisplayName(@NotNull IDevice device) {
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = TransportServiceProxy.getDeviceManufacturer(device);
        String model2 = TransportServiceProxy.getDeviceModel(device);
        String serial = device.getSerialNumber();
        String suffix = String.format("-%s", serial);
        if (model2.endsWith(suffix)) {
            model2 = model2.substring(0, model2.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model2);
        return deviceNameBuilder.toString();
    }

    static class PreferredProcessInfo {
        @NotNull
        private final String deviceName;
        @Nullable
        private final String processName;
        @NotNull
        private final Predicate<Common.Process> processFilter;

        PreferredProcessInfo(@NotNull String deviceName, @Nullable String processName, @NotNull Predicate<Common.Process> processFilter) {
            this.deviceName = deviceName;
            this.processName = processName;
            this.processFilter = processFilter;
        }
    }

    private static class AndroidProfilerWindowManagerListener
    implements ToolWindowManagerListener {
        private boolean myIsProfilingActiveBalloonShown = false;
        private boolean myWasWindowExpanded = false;
        @NotNull
        private final Project myProject;
        @NotNull
        private final StudioProfilers myProfilers;
        @NotNull
        private final StudioProfilersView myProfilersView;

        AndroidProfilerWindowManagerListener(@NotNull Project project, @NotNull StudioProfilers profilers, @NotNull StudioProfilersView view) {
            this.myProject = project;
            this.myProfilers = profilers;
            this.myProfilersView = view;
        }

        public void stateChanged() {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Android Profiler");
            if (window == null) {
                return;
            }
            boolean hasAliveSession = SessionsManager.isSessionAlive((Common.Session)this.myProfilers.getSessionsManager().getProfilingSession());
            boolean isWindowTabHidden = !window.isShowStripeButton();
            boolean isWindowExpanded = window.isVisible();
            boolean windowVisibilityChanged = isWindowExpanded != this.myWasWindowExpanded;
            this.myWasWindowExpanded = isWindowExpanded;
            if (isWindowTabHidden) {
                if (hasAliveSession) {
                    boolean confirm;
                    boolean hidePrompt = this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getBoolean(AndroidProfilerToolWindow.HIDE_STOP_PROMPT, false);
                    boolean bl = confirm = hidePrompt || this.myProfilersView.getIdeProfilerComponents().createUiMessageHandler().displayOkCancelMessage("Confirm Stop Profiling", "Hiding the window will stop the current profiling session. Are you sure?", "Yes", "Cancel", null, result2 -> this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(AndroidProfilerToolWindow.HIDE_STOP_PROMPT, result2.booleanValue()));
                    if (!confirm) {
                        window.setShowStripeButton(true);
                        return;
                    }
                }
                this.myProfilers.stop();
                return;
            }
            if (isWindowExpanded) {
                PreferredProcessInfo processInfo;
                this.myIsProfilingActiveBalloonShown = false;
                if (windowVisibilityChanged && (processInfo = (PreferredProcessInfo)this.myProject.getUserData(LAST_RUN_APP_INFO)) != null && Common.Session.getDefaultInstance().equals((Object)this.myProfilers.getSession())) {
                    this.myProfilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
                }
            } else {
                this.myProfilers.setAutoProfilingEnabled(false);
                if (hasAliveSession && !this.myIsProfilingActiveBalloonShown) {
                    this.myIsProfilingActiveBalloonShown = true;
                    String messageHtml = "A profiler session is running in the background.<br>To end the session, open the profiler and click the stop button in the Sessions pane.";
                    ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon("Android Profiler", MessageType.INFO, messageHtml);
                }
            }
        }
    }

    private static class StudioProfilersWrapper
    extends AspectObserver
    implements Disposable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ToolWindow myWindow;
        @NotNull
        private final StudioProfilers myProfilers;
        @NotNull
        private final StudioProfilersView myView;

        StudioProfilersWrapper(@NotNull Project project, @NotNull ToolWindow window, @NotNull TransportService service, @NotNull IntellijProfilerServices ideProfilerServices) {
            this.myProject = project;
            this.myWindow = window;
            service.getDataStoreService().setNoPiiExceptionHanlder(ideProfilerServices::reportNoPiiException);
            ProfilerClient client = new ProfilerClient(service.getChannelName());
            this.myProfilers = new StudioProfilers(client, (IdeProfilerServices)ideProfilerServices);
            IntellijCodeNavigator navigator = (IntellijCodeNavigator)ideProfilerServices.getCodeNavigator();
            Common.SessionMetaData selectedSessionMetadata = this.myProfilers.getSessionsManager().getSelectedSessionMetaData();
            navigator.setCpuAbiArchSupplier(() -> selectedSessionMetadata == null ? null : this.myProfilers.getProcess().getAbiCpuArch());
            this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.MODE, this::modeChanged).onChange((Enum)ProfilerAspect.STAGE, this::stageChanged);
            this.myProfilers.getSessionsManager().addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
            PreferredProcessInfo processInfo = (PreferredProcessInfo)this.myProject.getUserData(LAST_RUN_APP_INFO);
            if (processInfo != null) {
                this.myProfilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
                this.myProject.putUserData(LAST_RUN_APP_INFO, null);
            } else {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myProfilers.setPreferredProcessName(AndroidProfilerToolWindow.getPreferredProcessName(this.myProject)));
            }
            IntellijProfilerComponents profilerComponents = new IntellijProfilerComponents(this.myProject, this.myProfilers.getIdeServices().getFeatureTracker());
            this.myView = new StudioProfilersView(this.myProfilers, (IdeProfilerComponents)profilerComponents);
            Disposer.register((Disposable)this, (Disposable)this.myView);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new AndroidProfilerWindowManagerListener(this.myProject, this.myProfilers, this.myView));
        }

        public void dispose() {
            this.myProfilers.stop();
        }

        @NotNull
        private StudioProfilers getProfilers() {
            return this.myProfilers;
        }

        @NotNull
        private StudioProfilersView getProfilersView() {
            return this.myView;
        }

        private void modeChanged() {
            boolean maximize;
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            boolean bl = maximize = this.myProfilers.getMode() == ProfilerMode.EXPANDED;
            if (maximize != manager.isMaximized(this.myWindow)) {
                manager.setMaximized(this.myWindow, maximize);
            }
        }

        private void stageChanged() {
            if (this.myProfilers.isStopped()) {
                AndroidProfilerToolWindowFactory.removeContent(this.myWindow);
            }
        }

        private void selectedSessionChanged() {
            Common.SessionMetaData metaData = this.myProfilers.getSessionsManager().getSelectedSessionMetaData();
            this.myWindow.setTitle(metaData.getSessionName());
        }

        private void profilingSessionChanged() {
            Common.Session profilingSession = this.myProfilers.getSessionsManager().getProfilingSession();
            if (SessionsManager.isSessionAlive((Common.Session)profilingSession)) {
                this.myWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER));
            } else {
                this.myWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
            }
        }
    }
}

