/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxyManager;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import icons.StudioIcons;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindowFactory
implements DumbAware,
ToolWindowFactory,
Condition<Project> {
    public static final String ID = "Android Profiler";
    private static final String PROFILER_TOOL_WINDOW_TITLE = "Profiler";
    private static final Map<Content, AndroidProfilerToolWindow> PROJECT_PROFILER_MAP = new HashMap<Content, AndroidProfilerToolWindow>();

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        project.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidProfilerToolWindowFactory.ID);
                if (window == null) {
                    return;
                }
                AndroidProfilerToolWindow profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project);
                if (window.isVisible() && profilerToolWindow == null) {
                    AndroidProfilerToolWindowFactory.createContent(project, window);
                }
            }
        });
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(TransportDeviceManager.TOPIC, (Object)new ProfilerDeviceManagerListener(project));
    }

    public void init(ToolWindow toolWindow) {
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.hide(null);
        toolWindow.setShowStripeButton(false);
        toolWindow.setStripeTitle(PROFILER_TOOL_WINDOW_TITLE);
    }

    private static void createContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        AndroidProfilerToolWindow view = new AndroidProfilerToolWindow(toolWindow, project);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent(view.getComponent(), "", false);
        Disposer.register((Disposable)project, (Disposable)view);
        toolWindow.getContentManager().addContent(content);
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
        PROJECT_PROFILER_MAP.put(content, view);
        Disposer.register((Disposable)content, () -> PROJECT_PROFILER_MAP.remove(content));
        toolWindow.show(null);
    }

    @Nullable
    public static AndroidProfilerToolWindow getProfilerToolWindow(@NotNull Project project) {
        ToolWindow window = ToolWindowManagerEx.getInstanceEx((Project)project).getToolWindow(ID);
        if (window == null) {
            return null;
        }
        ContentManager contentManager = window.getContentManager();
        if (contentManager == null || contentManager.getContentCount() == 0) {
            return null;
        }
        return PROJECT_PROFILER_MAP.get(contentManager.getContent(0));
    }

    public static void removeContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow.getContentManager().getContentCount() > 0) {
            Content content = toolWindow.getContentManager().getContent(0);
            PROJECT_PROFILER_MAP.remove(content);
            toolWindow.getContentManager().removeAllContents(true);
        }
    }

    public boolean value(Project project) {
        return true;
    }

    private static class ProfilerDeviceManagerListener
    implements TransportDeviceManager.TransportDeviceManagerListener {
        private final int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);
        @NotNull
        private final FeatureTracker myTracker;

        public ProfilerDeviceManagerListener(@NotNull Project project) {
            this.myTracker = new StudioFeatureTracker(project);
        }

        @Override
        public void onPreTransportDaemonStart(@NotNull Common.Device device) {
            this.myTracker.trackPreTransportDaemonStarts(device);
        }

        @Override
        public void onStartTransportDaemonFail(@NotNull Common.Device device, @NotNull Exception exception) {
            this.myTracker.trackTransportDaemonFailed(device, exception);
        }

        @Override
        public void onTransportProxyCreationFail(@NotNull Common.Device device, @NotNull Exception exception) {
            this.myTracker.trackTransportProxyCreationFailed(device, exception);
        }

        @Override
        public void customizeProxyService(@NotNull TransportProxy proxy) {
            ProfilerServiceProxyManager.registerProxies(proxy);
        }

        @Override
        public void customizeDaemonConfig(@NotNull Transport.DaemonConfig.Builder configBuilder) {
            configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue())).setCpu(Transport.DaemonConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC).setSimpleperfHost(((Boolean)StudioFlags.PROFILER_SIMPLEPERF_HOST.get()).booleanValue()).setUsePerfetto(((Boolean)StudioFlags.PROFILER_USE_PERFETTO.get()).booleanValue()));
        }

        @Override
        public void customizeAgentConfig(@NotNull Agent.AgentConfig.Builder configBuilder, @Nullable AndroidRunConfigurationBase runConfig) {
            int liveAllocationSamplingRate = ((Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get()).booleanValue() ? (this.shouldEnableMemoryLiveAllocation(runConfig) ? PropertiesComponent.getInstance().getInt(IntellijProfilerPreferences.getProfilerPropertyName("memory.live.allocation.mode"), MemoryProfilerStage.DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.NONE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
            configBuilder.setCommon(configBuilder.getCommonBuilder().setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setProfilerUnifiedPipeline(((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue())).setMem(Agent.AgentConfig.MemoryConfig.newBuilder().setUseLiveAlloc(((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue()).setMaxStackDepth(this.LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(((Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get()).booleanValue()).setSamplingRate(MemoryProfiler.AllocationSamplingRate.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setCpuApiTracingEnabled(((Boolean)StudioFlags.PROFILER_CPU_API_TRACING.get()).booleanValue()).setStartupProfilingEnabled(runConfig != null);
        }

        private boolean shouldEnableMemoryLiveAllocation(@Nullable AndroidRunConfigurationBase runConfig) {
            if (runConfig != null && runConfig.getProfilerState().STARTUP_CPU_PROFILING_ENABLED) {
                String configName = runConfig.getProfilerState().STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
                CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(runConfig.getProject()).getConfigByName(configName);
                return startupConfig == null || !startupConfig.isDisableLiveAllocation();
            }
            return true;
        }
    }
}

