/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.actions.NavigateToCodeAction;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.intellij.ide.actions.CopyAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IntellijContextMenuInstaller
implements ContextMenuInstaller {
    private static final String COMPONENT_CONTEXT_MENU = "ComponentContextMenu";
    private int myCachedX = -1;

    public void installGenericContextMenu(final @NotNull JComponent component, final @NotNull ContextMenuItem contextMenuItem, final @NotNull IntPredicate itemEnabled, final @NotNull IntConsumer callback2) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        if (contextMenuItem.equals(ContextMenuItem.SEPARATOR)) {
            popupGroup.addSeparator();
            return;
        }
        if (contextMenuItem.equals(ContextMenuItem.COPY)) {
            popupGroup.add((AnAction)new CopyAction(){
                {
                    this.getTemplatePresentation().setText(contextMenuItem.getText());
                    this.getTemplatePresentation().setIcon(contextMenuItem.getIcon());
                    this.registerCustomShortcutSet(CommonShortcuts.getCopy(), component);
                }
            });
            return;
        }
        AnAction action2 = new AnAction(){

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setText(contextMenuItem.getText());
                presentation.setIcon(contextMenuItem.getIcon());
                presentation.setEnabled(itemEnabled.test(IntellijContextMenuInstaller.this.myCachedX));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                callback2.accept(IntellijContextMenuInstaller.this.myCachedX);
            }
        };
        action2.registerCustomShortcutSet(new ShortcutSet(){

            @NotNull
            public Shortcut[] getShortcuts() {
                return (Shortcut[])Arrays.stream(contextMenuItem.getKeyStrokes()).filter(keyStroke -> keyStroke != null).map(keyStroke -> new KeyboardShortcut(keyStroke, null)).toArray(Shortcut[]::new);
            }
        }, component);
        popupGroup.add(action2);
    }

    public void installNavigationContextMenu(@NotNull JComponent component, @NotNull CodeNavigator navigator, @NotNull Supplier<CodeLocation> codeLocationSupplier) {
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        popupGroup.add((AnAction)new NavigateToCodeAction(codeLocationSupplier, navigator));
    }

    @NotNull
    private DefaultActionGroup createOrGetActionGroup(@NotNull JComponent component) {
        DefaultActionGroup actionGroup = (DefaultActionGroup)component.getClientProperty(COMPONENT_CONTEXT_MENU);
        if (actionGroup == null) {
            final DefaultActionGroup newActionGroup = new DefaultActionGroup();
            component.putClientProperty(COMPONENT_CONTEXT_MENU, newActionGroup);
            component.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    IntellijContextMenuInstaller.this.myCachedX = x;
                    ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)newActionGroup).getComponent().show(comp, x, y);
                }
            });
            actionGroup = newActionGroup;
        }
        return actionGroup;
    }
}

