/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.ListBoxChooserDialog;
import com.android.tools.idea.profilers.TemporaryProfilerPreferences;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigService;
import com.android.tools.idea.profilers.stacktrace.IntelliJNativeFrameSymbolizer;
import com.android.tools.idea.profilers.stacktrace.IntellijCodeNavigator;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.SymbolFilesLocatorKt;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerPreferences;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.TracePreProcessor;
import com.android.tools.profilers.cpu.simpleperf.SimpleperfSampleReporter;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerServices
implements IdeProfilerServices,
Disposable {
    private final IntellijCodeNavigator myCodeNavigator;
    @NotNull
    private final NativeFrameSymbolizer myNativeSymbolizer;
    private final StudioFeatureTracker myFeatureTracker;
    @NotNull
    private final Project myProject;
    @NotNull
    private final IntellijProfilerPreferences myPersistentPreferences;
    @NotNull
    private final TemporaryProfilerPreferences myTemporaryPreferences;
    @NotNull
    private final SimpleperfSampleReporter mySimpleperfSampleReporter;

    private static Logger getLogger() {
        return Logger.getInstance(IntellijProfilerServices.class);
    }

    public IntellijProfilerServices(@NotNull Project project) {
        this.myProject = project;
        this.myFeatureTracker = new StudioFeatureTracker(this.myProject);
        NativeSymbolizer nativeSymbolizer = NativeSymbolizerKt.createNativeSymbolizer(project);
        Disposer.register((Disposable)this, nativeSymbolizer::stop);
        this.myNativeSymbolizer = new IntelliJNativeFrameSymbolizer(nativeSymbolizer);
        this.myCodeNavigator = new IntellijCodeNavigator(project, nativeSymbolizer, this.myFeatureTracker);
        this.myPersistentPreferences = new IntellijProfilerPreferences();
        this.myTemporaryPreferences = new TemporaryProfilerPreferences();
        this.mySimpleperfSampleReporter = new SimpleperfSampleReporter(() -> this.getNativeSymbolsDirectories());
    }

    public void dispose() {
    }

    @NotNull
    public Executor getMainExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0);
    }

    @NotNull
    public Executor getPoolExecutor() {
        return arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0);
    }

    public void saveFile(@NotNull File file, @NotNull Consumer<FileOutputStream> fileOutputStreamConsumer, @Nullable Runnable postRunnable) {
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    IntellijProfilerServices.getLogger().error("Could not create new file at: " + file.getPath());
                    return;
                }
            }
            catch (IOException e) {
                IntellijProfilerServices.getLogger().error((Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fileOutputStreamConsumer.accept(fos);
        }
        catch (IOException e) {
            IntellijProfilerServices.getLogger().error((Throwable)e);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            virtualFile.refresh(true, false, postRunnable);
        }
    }

    @NotNull
    public String getApplicationId() {
        ArrayList<String> applicationIds = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) continue;
            applicationIds.add(androidModuleModel.getApplicationId());
        }
        return applicationIds.isEmpty() ? "" : (String)applicationIds.get(0);
    }

    @NotNull
    public NativeFrameSymbolizer getNativeFrameSymbolizer() {
        return this.myNativeSymbolizer;
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        return this.myCodeNavigator;
    }

    @NotNull
    public FeatureTracker getFeatureTracker() {
        return this.myFeatureTracker;
    }

    public void enableAdvancedProfiling() {
        RunnerAndConfigurationSettings configurationSettings;
        AndroidRunConfigurationBase androidConfiguration = null;
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        if (runManager != null && (configurationSettings = runManager.getSelectedConfiguration()) != null && configurationSettings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            androidConfiguration = (AndroidRunConfigurationBase)configurationSettings.getConfiguration();
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(true);
        }
        EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(this.myProject);
        dialog2.show();
        if (androidConfiguration != null) {
            androidConfiguration.getProfilerState().setCheckAdvancedProfiling(false);
        }
    }

    @NotNull
    public FeatureConfig getFeatureConfig() {
        return new FeatureConfig(){

            public boolean isAtraceEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_ATRACE.get();
            }

            public boolean isCpuApiTracingEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_API_TRACING.get();
            }

            public boolean isCpuNewRecordingWorkflowEnabled() {
                return (Boolean)StudioFlags.PROFILER_CPU_NEW_RECORDING_WORKFLOW.get();
            }

            public boolean isEnergyProfilerEnabled() {
                return (Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get();
            }

            public boolean isExportCpuTraceEnabled() {
                return (Boolean)StudioFlags.PROFILER_EXPORT_CPU_TRACE.get();
            }

            public boolean isImportCpuTraceEnabled() {
                return (Boolean)StudioFlags.PROFILER_IMPORT_CPU_TRACE.get();
            }

            public boolean isJniReferenceTrackingEnabled() {
                return (Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get();
            }

            public boolean isLiveAllocationsEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get();
            }

            public boolean isLiveAllocationsSamplingEnabled() {
                return (Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get();
            }

            public boolean isMemoryCaptureFilterEnabled() {
                return (Boolean)StudioFlags.PROFILER_MEMORY_CAPTURE_FILTER.get();
            }

            public boolean isMemorySnapshotEnabled() {
                return (Boolean)StudioFlags.PROFILER_MEMORY_SNAPSHOT.get();
            }

            public boolean isPerfettoEnabled() {
                return (Boolean)StudioFlags.PROFILER_USE_PERFETTO.get();
            }

            public boolean isPerformanceMonitoringEnabled() {
                return (Boolean)StudioFlags.PROFILER_PERFORMANCE_MONITORING.get();
            }

            public boolean isSessionImportEnabled() {
                return (Boolean)StudioFlags.PROFILER_IMPORT_SESSION.get();
            }

            public boolean isSimpleperfHostEnabled() {
                return (Boolean)StudioFlags.PROFILER_SIMPLEPERF_HOST.get();
            }

            public boolean isFragmentsEnabled() {
                return (Boolean)StudioFlags.PROFILER_FRAGMENT_PROFILER_ENABLED.get();
            }

            public boolean isStartupCpuProfilingEnabled() {
                return (Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get();
            }

            public boolean isUnifiedPipelineEnabled() {
                return (Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get();
            }
        };
    }

    @NotNull
    public ProfilerPreferences getTemporaryProfilerPreferences() {
        return this.myTemporaryPreferences;
    }

    @NotNull
    public ProfilerPreferences getPersistentProfilerPreferences() {
        return this.myPersistentPreferences;
    }

    public void openParseLargeTracesDialog(Runnable yesCallback, Runnable noCallback) {
        int dialogResult = Messages.showYesNoDialog((Project)this.myProject, (String)"The trace file generated is large, and Android Studio may become unresponsive while it parses the data. Do you want to continue?\n\nWarning: If you select \"No\", Android Studio discards the trace data and you will need to capture a new method trace.", (String)"Trace File Too Large", (Icon)Messages.getWarningIcon());
        if (dialogResult == 0) {
            yesCallback.run();
        } else {
            noCallback.run();
        }
    }

    public <T> T openListBoxChooserDialog(@NotNull String title, @Nullable String message2, @NotNull T[] options, @NotNull Function<T, String> listBoxPresentationAdapter) {
        Object[] selectedValue = new Object[1];
        Supplier<Object> dialog2 = () -> {
            ListBoxChooserDialog<Object> listBoxDialog = new ListBoxChooserDialog<Object>(title, message2, options, listBoxPresentationAdapter);
            listBoxDialog.show();
            return listBoxDialog.getExitCode() != 0 ? null : listBoxDialog.getSelectedValue();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            selectedValue[0] = dialog2.get();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                SwingUtilities.invokeLater(() -> {
                    selectedValue[0] = dialog2.get();
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (T)selectedValue[0];
    }

    @NotNull
    public TracePreProcessor getSimpleperfTracePreProcessor() {
        return this.mySimpleperfSampleReporter;
    }

    @NotNull
    private Set<File> getNativeSymbolsDirectories() {
        String arch = this.myCodeNavigator.fetchCpuAbiArch();
        Map<String, Set<File>> archToDirectories = SymbolFilesLocatorKt.getArchToSymDirsMap(this.myProject);
        return archToDirectories.containsKey(arch) ? archToDirectories.get(arch) : Collections.emptySet();
    }

    public List<ProfilingConfiguration> getUserCpuProfilerConfigs() {
        CpuProfilerConfigsState configsState = CpuProfilerConfigsState.getInstance(this.myProject);
        CpuProfilingConfigService oldService = CpuProfilingConfigService.getInstance(this.myProject);
        oldService.getConfigurations().forEach(old -> configsState.addUserConfig(CpuProfilerConfigConverter.fromProto(old.toProto())));
        oldService.setConfigurations(Collections.emptyList());
        return CpuProfilerConfigConverter.toProto(configsState.getUserConfigs()).stream().map(ProfilingConfiguration::fromProto).collect(Collectors.toList());
    }

    public List<ProfilingConfiguration> getDefaultCpuProfilerConfigs() {
        return CpuProfilerConfigConverter.toProto(CpuProfilerConfigsState.getDefaultConfigs()).stream().map(ProfilingConfiguration::fromProto).collect(Collectors.toList());
    }

    public boolean isNativeProfilingConfigurationPreferred() {
        ImmutableList nativeExtensions = ImmutableList.of((Object)"c", (Object)"cc", (Object)"cpp", (Object)"cxx", (Object)"c++", (Object)"h", (Object)"hh", (Object)"hpp", (Object)"hxx", (Object)"h++");
        return Arrays.stream(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).anyMatch(file -> {
            String extension = file.getExtension();
            return extension != null && nativeExtensions.contains((Object)extension.toLowerCase());
        });
    }

    public void showNotification(@NotNull Notification notification) {
        NotificationType type = null;
        switch (notification.getSeverity()) {
            case INFO: {
                type = NotificationType.INFORMATION;
                break;
            }
            case WARNING: {
                type = NotificationType.WARNING;
                break;
            }
            case ERROR: {
                type = NotificationType.ERROR;
            }
        }
        Notification.UrlData urlData = notification.getUrlData();
        if (urlData != null) {
            OpenUrlHyperlink hyperlink = new OpenUrlHyperlink(urlData.getUrl(), urlData.getText());
            AndroidNotification.getInstance(this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, false, hyperlink);
        } else {
            AndroidNotification.getInstance(this.myProject).showBalloon(notification.getTitle(), notification.getText(), type, AndroidNotification.BALLOON_GROUP, new NotificationHyperlink[0]);
        }
    }

    public void reportNoPiiException(@NotNull Throwable ex) {
        IntellijProfilerServices.getLogger().error((Throwable)new NoPiiException(ex));
    }
}

