/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuTraceProfiler;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class StudioLegacyCpuTraceProfiler
implements LegacyCpuTraceProfiler {
    @NotNull
    private IDevice myDevice;
    @NotNull
    private final Object myLegacyProfilingLock = new Object();
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myServiceStub;
    @NotNull
    private final Map<Integer, LegacyProfilingRecord> myLegacyProfilingRecord = new HashMap<Integer, LegacyProfilingRecord>();

    private static Logger getLogger() {
        return Logger.getInstance(StudioLegacyCpuTraceProfiler.class);
    }

    public StudioLegacyCpuTraceProfiler(@NotNull IDevice device, @NotNull CpuServiceGrpc.CpuServiceBlockingStub cpuStub) {
        this.myDevice = device;
        this.myServiceStub = cpuStub;
        LegacyProfilingHandler profilingHandler = LegacyProfilingHandler.getInstance();
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)profilingHandler);
        profilingHandler.addProfilingRecords(this.myDevice, this.myLegacyProfilingRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStartResponse startProfilingApp(CpuProfiler.CpuProfilingAppStartRequest request) {
        Client client;
        int pid = request.getSession().getPid();
        CpuProfiler.CpuProfilingAppStartResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStartResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        if (client == null) {
            return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE).setErrorMessage("App is not running.").build();
        }
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(pid);
            if (record != null && client.getClientData().getMethodProfilingStatus() != ClientData.MethodProfilingStatus.OFF) {
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE).setErrorMessage("Start request ignored. The app has an on-going profiling session.").build();
            }
            DdmPreferences.setProfilerBufferSizeMb((int)request.getConfiguration().getBufferSizeInMb());
            long nowNs = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
            record = new LegacyProfilingRecord(request, nowNs, responseBuilder);
            this.myLegacyProfilingRecord.put(pid, record);
            try {
                if (request.getConfiguration().getTraceType() == Cpu.CpuTraceType.ATRACE) {
                    responseBuilder.mergeFrom(this.myServiceStub.startProfilingApp(request));
                } else if (request.getConfiguration().getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    assert (request.getConfiguration().getTraceType() == Cpu.CpuTraceType.ART);
                    client.startSamplingProfiler(request.getConfiguration().getSamplingIntervalUs(), TimeUnit.MICROSECONDS);
                } else {
                    assert (request.getConfiguration().getTraceType() == Cpu.CpuTraceType.ART);
                    client.startMethodTracer();
                }
                record.myStartLatch.await(100L, TimeUnit.MILLISECONDS);
                if (record.myStartFailed) {
                    this.myLegacyProfilingRecord.remove(pid);
                } else {
                    responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS);
                }
            }
            catch (IOException | InterruptedException e) {
                responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE);
                responseBuilder.setErrorMessage("Failed: " + e);
                StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy startProfilingAppDdms: " + e);
            }
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.CpuProfilingAppStopResponse stopProfilingApp(CpuProfiler.CpuProfilingAppStopRequest request) {
        int pid = request.getSession().getPid();
        CpuProfiler.CpuProfilingAppStopResponse.Builder responseBuilder = CpuProfiler.CpuProfilingAppStopResponse.newBuilder();
        String appPkgName = this.myDevice.getClientName(pid);
        Client client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            if (client == null) {
                this.myLegacyProfilingRecord.remove(pid);
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.APP_PROCESS_DIED).setErrorMessage("App is not running.").build();
            }
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(pid);
            if (this.isMethodProfilingStatusOff(record, client)) {
                return responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.NO_ONGOING_PROFILING).setErrorMessage("The app is not being profiled.").build();
            }
            record.setStopResponseBuilder(responseBuilder);
            try {
                if (record.myStartRequest.getConfiguration().getTraceType() == Cpu.CpuTraceType.ATRACE) {
                    CpuProfiler.CpuProfilingAppStopResponse response = this.myServiceStub.stopProfilingApp(request);
                    responseBuilder.mergeFrom(response);
                    record.myStopLatch.countDown();
                } else if (record.myStartRequest.getConfiguration().getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    assert (record.myStartRequest.getConfiguration().getTraceType() == Cpu.CpuTraceType.ART);
                    client.stopSamplingProfiler();
                } else {
                    assert (record.myStartRequest.getConfiguration().getTraceType() == Cpu.CpuTraceType.ART);
                    client.stopMethodTracer();
                }
                record.myStopLatch.await();
            }
            catch (IOException | InterruptedException e) {
                responseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.STOP_COMMAND_FAILED);
                responseBuilder.setErrorMessage("Failed: " + e);
                StudioLegacyCpuTraceProfiler.getLogger().error("Exception while CpuServiceProxy stopProfilingApp: " + e);
            }
            this.myLegacyProfilingRecord.remove(pid);
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CpuProfiler.ProfilingStateResponse checkAppProfilingState(CpuProfiler.ProfilingStateRequest request) {
        Client client;
        int pid = request.getSession().getPid();
        long nowNs = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        CpuProfiler.ProfilingStateResponse.Builder responseBuilder = CpuProfiler.ProfilingStateResponse.newBuilder().setCheckTimestamp(nowNs);
        String appPkgName = this.myDevice.getClientName(pid);
        Client client2 = client = appPkgName != null ? this.myDevice.getClient(appPkgName) : null;
        if (client == null) {
            return responseBuilder.setBeingProfiled(false).build();
        }
        Object object = this.myLegacyProfilingLock;
        synchronized (object) {
            LegacyProfilingRecord record = this.myLegacyProfilingRecord.get(pid);
            if (this.isMethodProfilingStatusOff(record, client)) {
                return responseBuilder.setBeingProfiled(false).build();
            }
            return responseBuilder.setBeingProfiled(true).setConfiguration(record.myStartRequest.getConfiguration()).setStartTimestamp(record.myStartRequestTimestamp).build();
        }
    }

    private boolean isMethodProfilingStatusOff(LegacyProfilingRecord record, Client client) {
        return record == null || client.getClientData().getMethodProfilingStatus() == ClientData.MethodProfilingStatus.OFF && record.myStartRequest.getConfiguration().getTraceType() == Cpu.CpuTraceType.ART;
    }

    private static class LegacyProfilingRecord {
        @NotNull
        final CpuProfiler.CpuProfilingAppStartRequest myStartRequest;
        long myStartRequestTimestamp;
        @NotNull
        CpuProfiler.CpuProfilingAppStartResponse.Builder myStartResponseBuilder;
        @NotNull
        CountDownLatch myStartLatch = new CountDownLatch(1);
        @NotNull
        CountDownLatch myStopLatch = new CountDownLatch(1);
        boolean myStartFailed = false;
        CpuProfiler.CpuProfilingAppStopResponse.Builder myStopResponseBuilder;

        public LegacyProfilingRecord(@NotNull CpuProfiler.CpuProfilingAppStartRequest request, long timestamp, @NotNull CpuProfiler.CpuProfilingAppStartResponse.Builder startResponseBuilder) {
            this.myStartRequest = request;
            this.myStartRequestTimestamp = timestamp;
            this.myStartResponseBuilder = startResponseBuilder;
        }

        public void setStopResponseBuilder(@NotNull CpuProfiler.CpuProfilingAppStopResponse.Builder builder) {
            this.myStopResponseBuilder = builder;
        }

        public CpuProfiler.CpuProfilingAppStopResponse.Builder getStopResponseBuilder() {
            return this.myStopResponseBuilder;
        }
    }

    private static class LegacyProfilingHandler
    implements ClientData.IMethodProfilingHandler {
        @NotNull
        private final Map<IDevice, Map<Integer, LegacyProfilingRecord>> myProfilingRecords = new HashMap<IDevice, Map<Integer, LegacyProfilingRecord>>();
        private static LegacyProfilingHandler ourInstance;

        private LegacyProfilingHandler() {
        }

        public static synchronized LegacyProfilingHandler getInstance() {
            if (ourInstance == null) {
                ourInstance = new LegacyProfilingHandler();
            }
            return ourInstance;
        }

        public void onSuccess(String remoteFilePath, Client client) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                assert (stopResponseBuilder != null);
                stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.CANNOT_COPY_FILE);
                stopResponseBuilder.setErrorMessage("Method profiling: Older devices (API level < 10) are not supported. Please use DDMS.");
                record.myStopLatch.countDown();
            }
        }

        public void onSuccess(byte[] data, Client client) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                assert (stopResponseBuilder != null);
                stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS);
                stopResponseBuilder.setTrace(ByteString.copyFrom((byte[])data));
                stopResponseBuilder.setTraceId(System.nanoTime());
                record.myStopLatch.countDown();
            }
        }

        public void onStartFailure(Client client, String message2) {
        }

        public void onEndFailure(Client client, String message2) {
            LegacyProfilingRecord record = this.myProfilingRecords.get(client.getDevice()).get(client.getClientData().getPid());
            if (record != null) {
                CpuProfiler.CpuProfilingAppStopResponse.Builder stopResponseBuilder = record.getStopResponseBuilder();
                if (stopResponseBuilder != null) {
                    stopResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStopResponse.Status.STOP_COMMAND_FAILED);
                    stopResponseBuilder.setErrorMessage("Failed to stop profiling: " + message2);
                    record.myStopLatch.countDown();
                } else {
                    record.myStartFailed = true;
                    record.myStartResponseBuilder.setStatus(CpuProfiler.CpuProfilingAppStartResponse.Status.FAILURE);
                    record.myStartResponseBuilder.setErrorMessage("Failed to start profiling: " + message2);
                    record.myStartLatch.countDown();
                }
            }
        }

        public void addProfilingRecords(@NotNull IDevice device, @NotNull Map<Integer, LegacyProfilingRecord> record) {
            this.myProfilingRecords.put(device, record);
        }
    }
}

