/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.analytics;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CpuApiTracingMetadata;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.CpuStartupProfilingMetadata;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.EnergyEvent;
import com.google.wireless.android.sdk.stats.EnergyEventCount;
import com.google.wireless.android.sdk.stats.EnergyEventMetadata;
import com.google.wireless.android.sdk.stats.EnergyRangeMetadata;
import com.google.wireless.android.sdk.stats.FilterMetadata;
import com.google.wireless.android.sdk.stats.ProfilerSessionCreationMetaData;
import com.google.wireless.android.sdk.stats.ProfilerSessionSelectionMetaData;
import com.google.wireless.android.sdk.stats.TransportFailureMetadata;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFeatureTracker
implements FeatureTracker {
    @Nullable
    private Common.Device myActiveDevice;
    @Nullable
    private Common.Process myActiveProcess;
    @NotNull
    private Project myTrackingProject;
    private final ImmutableMap<Class<? extends Stage>, AndroidProfilerEvent.Stage> STAGE_MAP = ImmutableMap.builder().put(NullMonitorStage.class, (Object)AndroidProfilerEvent.Stage.NULL_STAGE).put(StudioMonitorStage.class, (Object)AndroidProfilerEvent.Stage.OVERVIEW_STAGE).put(CpuProfilerStage.class, (Object)AndroidProfilerEvent.Stage.CPU_STAGE).put(MemoryProfilerStage.class, (Object)AndroidProfilerEvent.Stage.MEMORY_STAGE).put(NetworkProfilerStage.class, (Object)AndroidProfilerEvent.Stage.NETWORK_STAGE).put(EnergyProfilerStage.class, (Object)AndroidProfilerEvent.Stage.ENERGY_STAGE).build();
    private final ImmutableMap<Common.SessionMetaData.SessionType, ProfilerSessionCreationMetaData.SessionType> SESSION_TYPE_MAP = ImmutableMap.of((Object)Common.SessionMetaData.SessionType.FULL, (Object)ProfilerSessionCreationMetaData.SessionType.FULL_SESSION, (Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.MEMORY_CAPTURE, (Object)Common.SessionMetaData.SessionType.CPU_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.CPU_CAPTURE);
    private final ImmutableMap<SessionsManager.SessionCreationSource, ProfilerSessionCreationMetaData.CreationSource> SESSION_CREATION_SOURCE_MAP = ImmutableMap.of((Object)SessionsManager.SessionCreationSource.MANUAL, (Object)ProfilerSessionCreationMetaData.CreationSource.MANUAL);
    private final ImmutableMap<Class<? extends SessionArtifact>, ProfilerSessionSelectionMetaData.ArtifactType> SESSION_ARTIFACT_MAP = ImmutableMap.of(SessionItem.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_SESSION, HprofSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_HPROF, CpuCaptureSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_CPU_CAPTURE, LegacyAllocationsSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_LEGACY_ALLOCATIONS);
    private final ImmutableMap<Class<? extends Exception>, TransportFailureMetadata.FailureType> TRANSPORT_FAILURE_MAP = ImmutableMap.builder().put(TimeoutException.class, (Object)TransportFailureMetadata.FailureType.TIMEOUT).put(InterruptedException.class, (Object)TransportFailureMetadata.FailureType.INTERRUPTED).put(IOException.class, (Object)TransportFailureMetadata.FailureType.IO).put(SyncException.class, (Object)TransportFailureMetadata.FailureType.SYNC).put(ShellCommandUnresponsiveException.class, (Object)TransportFailureMetadata.FailureType.SHELL_COMMAND_UNRESPONSIVE).put(AdbCommandRejectedException.class, (Object)TransportFailureMetadata.FailureType.ADB_COMMAND_REJECTED).build();
    private static final ImmutableMap<CpuCaptureMetadata.CaptureStatus, CpuCaptureMetadata.CaptureStatus> CPU_CAPTURE_STATUS_MAP = ImmutableMap.builder().put((Object)CpuCaptureMetadata.CaptureStatus.SUCCESS, (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING, (Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING).put((Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE).build();
    @NotNull
    private AndroidProfilerEvent.Stage myCurrStage = AndroidProfilerEvent.Stage.UNKNOWN_STAGE;

    public StudioFeatureTracker(@NotNull Project trackingProject) {
        this.myTrackingProject = trackingProject;
    }

    public void trackPreTransportDaemonStarts(@NotNull Common.Device transportDevice) {
        this.newTracker(AndroidProfilerEvent.Type.PRE_TRANSPORT_DAEMON_STARTS).setDevice(transportDevice).track();
    }

    public void trackTransportDaemonFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_DAEMON_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackTransportProxyCreationFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_PROXY_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackProfilerInitializationFailed() {
        this.track(AndroidProfilerEvent.Type.PROFILER_INITIALIZATION_FAILED);
    }

    public void trackEnterStage(@NotNull Class<? extends Stage> stage) {
        this.myCurrStage = (AndroidProfilerEvent.Stage)this.STAGE_MAP.getOrDefault(stage, (Object)AndroidProfilerEvent.Stage.UNKNOWN_STAGE);
        this.track(AndroidProfilerEvent.Type.STAGE_ENTERED);
    }

    public void trackRunWithProfiling() {
        this.track(AndroidProfilerEvent.Type.RUN_WITH_PROFILING);
    }

    public void trackAutoProfilingRequested() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_REQUESTED);
    }

    public void trackAutoProfilingSucceeded() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_SUCCEEDED);
    }

    public void trackProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackAdvancedProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.ADVANCED_PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackChangeDevice(@Nullable Common.Device device) {
        if (this.myActiveDevice != device) {
            this.myActiveDevice = device;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_DEVICE).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackChangeProcess(@Nullable Common.Process process) {
        if (this.myActiveProcess != process) {
            this.myActiveProcess = process;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_PROCESS).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackSessionDropdownClicked() {
        this.track(AndroidProfilerEvent.Type.SESSION_DROPDOWN_CLICKED);
    }

    public void trackCreateSession(Common.SessionMetaData.SessionType sessionType, SessionsManager.SessionCreationSource sourceType) {
        ProfilerSessionCreationMetaData.Builder builder = ProfilerSessionCreationMetaData.newBuilder().setCreatedType((ProfilerSessionCreationMetaData.SessionType)this.SESSION_TYPE_MAP.getOrDefault((Object)sessionType, (Object)ProfilerSessionCreationMetaData.SessionType.UNKNOWN_SESSION)).setCreationSource((ProfilerSessionCreationMetaData.CreationSource)this.SESSION_CREATION_SOURCE_MAP.getOrDefault((Object)sourceType, (Object)ProfilerSessionCreationMetaData.CreationSource.UNKNOWN_SOURCE));
        this.newTracker(AndroidProfilerEvent.Type.SESSION_CREATED).setSessionCreationMetadata(builder.build()).track();
    }

    public void trackStopSession() {
        this.track(AndroidProfilerEvent.Type.SESSION_STOPPED);
    }

    public void trackSessionsPanelStateChanged(boolean isExpanded) {
        this.track(isExpanded ? AndroidProfilerEvent.Type.SESSION_UI_EXPANDED : AndroidProfilerEvent.Type.SESSION_UI_COLLAPSED);
    }

    public void trackSessionsPanelResized() {
        this.track(AndroidProfilerEvent.Type.SESSION_UI_RESIZED);
    }

    public void trackSessionArtifactSelected(@NotNull SessionArtifact artifact, boolean isSessionLive) {
        ProfilerSessionSelectionMetaData.Builder builder = ProfilerSessionSelectionMetaData.newBuilder().setSelectedType((ProfilerSessionSelectionMetaData.ArtifactType)this.SESSION_ARTIFACT_MAP.getOrDefault(artifact.getClass(), (Object)ProfilerSessionSelectionMetaData.ArtifactType.UNKNOWN_ARTIFACT_TYPE)).setIsSessionAlive(isSessionLive);
        this.newTracker(AndroidProfilerEvent.Type.SESSION_ARTIFACT_SELECTED).setSessionSelectionMetadata(builder.build()).track();
    }

    public void trackGoBack() {
        this.track(AndroidProfilerEvent.Type.GO_BACK);
    }

    public void trackSelectMonitor() {
        this.track(AndroidProfilerEvent.Type.SELECT_MONITOR);
    }

    public void trackZoomIn() {
        this.track(AndroidProfilerEvent.Type.ZOOM_IN);
    }

    public void trackZoomOut() {
        this.track(AndroidProfilerEvent.Type.ZOOM_OUT);
    }

    public void trackResetZoom() {
        this.track(AndroidProfilerEvent.Type.ZOOM_RESET);
    }

    public void trackToggleStreaming() {
        this.track(AndroidProfilerEvent.Type.GO_LIVE);
    }

    public void trackNavigateToCode() {
        this.track(AndroidProfilerEvent.Type.NAVIGATE_TO_CODE);
    }

    public void trackSelectCpuKernelElement() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_CLICKED);
    }

    public void trackToggleCpuKernelHideablePanel() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_TOGGLED);
    }

    public void trackToggleCpuThreadsHideablePanel() {
        this.track(AndroidProfilerEvent.Type.THREADS_VIEW_TOGGLED);
    }

    public void trackSelectRange() {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_RANGE).setDevice(this.myActiveDevice).track();
    }

    public void trackCaptureTrace(@NotNull com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_TRACE).setDevice(this.myActiveDevice).setCpuCaptureMetadata(cpuCaptureMetadata).track();
    }

    public void trackImportTrace(@NotNull Cpu.CpuTraceType profilerType, boolean success) {
        CpuImportTraceMetadata.Builder metadata = CpuImportTraceMetadata.newBuilder();
        metadata.setImportStatus(success ? CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_SUCCESS : CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_FAILURE);
        switch (profilerType) {
            case ART: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ART_TECHNOLOGY);
                break;
            }
            case SIMPLEPERF: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.SIMPLEPERF_TECHNOLOGY);
                break;
            }
            case ATRACE: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ATRACE_TECHNOLOGY);
                break;
            }
            default: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.UNKNOWN_TECHNOLOGY);
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_IMPORT_TRACE).setDevice(this.myActiveDevice).setCpuImportTraceMetadata(metadata.build()).track();
    }

    public void trackCpuStartupProfiling(@NotNull ProfilingConfiguration configuration) {
        this.newTracker(AndroidProfilerEvent.Type.CPU_STARTUP_PROFILING).setDevice(this.myActiveDevice).setCpuStartupProfilingConfiguration(configuration).track();
    }

    public void trackCpuApiTracing(boolean sampling, boolean pathProvided, int bufferSize, int flags, int intervalUs) {
        CpuApiTracingMetadata metadata = CpuApiTracingMetadata.newBuilder().setUseSampling(sampling).setArgTracePath(pathProvided).setArgBufferSize(bufferSize).setArgFlags(flags).setArgIntervalUs(intervalUs).build();
        this.newTracker(AndroidProfilerEvent.Type.CPU_API_TRACING).setDevice(this.myActiveDevice).setCpuApiTracingMetadata(metadata).track();
    }

    public void trackSelectThread() {
        this.track(AndroidProfilerEvent.Type.SELECT_THREAD);
    }

    public void trackSelectCaptureTopDown() {
        this.track(AndroidProfilerEvent.Type.SELECT_TOP_DOWN);
    }

    public void trackSelectCaptureBottomUp() {
        this.track(AndroidProfilerEvent.Type.SELECT_BOTTOM_UP);
    }

    public void trackSelectCaptureFlameChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_FLAME_CHART);
    }

    public void trackSelectCaptureCallChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_CALL_CHART);
    }

    public void trackForceGc() {
        this.track(AndroidProfilerEvent.Type.FORCE_GC);
    }

    public void trackDumpHeap() {
        this.track(AndroidProfilerEvent.Type.SNAPSHOT_HPROF);
    }

    public void trackRecordAllocations() {
        this.track(AndroidProfilerEvent.Type.CAPTURE_ALLOCATIONS);
    }

    public void trackExportHeap() {
        this.track(AndroidProfilerEvent.Type.EXPORT_HPROF);
    }

    public void trackExportAllocation() {
        this.track(AndroidProfilerEvent.Type.EXPORT_ALLOCATION);
    }

    public void trackChangeClassArrangment() {
        this.track(AndroidProfilerEvent.Type.ARRANGE_CLASSES);
    }

    public void trackSelectMemoryStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_STACK);
    }

    public void trackSelectMemoryReferences() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_REFERENCES);
    }

    public void trackSelectMemoryHeap(@NotNull String heapName) {
        AndroidProfilerEvent.MemoryHeap heapType;
        switch (heapName) {
            case "default": {
                heapType = AndroidProfilerEvent.MemoryHeap.DEFAULT_HEAP;
                break;
            }
            case "app": {
                heapType = AndroidProfilerEvent.MemoryHeap.APP_HEAP;
                break;
            }
            case "image": {
                heapType = AndroidProfilerEvent.MemoryHeap.IMAGE_HEAP;
                break;
            }
            case "zygote": {
                heapType = AndroidProfilerEvent.MemoryHeap.ZYGOTE_HEAP;
                break;
            }
            case "JNI": {
                heapType = AndroidProfilerEvent.MemoryHeap.JNI_HEAP;
                break;
            }
            default: {
                StudioFeatureTracker.getLogger().error("Attempt to report selection of unknown heap name: " + heapName);
                return;
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_MEMORY_HEAP).setMemoryHeapId(heapType).track();
    }

    public void trackSelectNetworkRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTION);
    }

    public void trackSelectNetworkDetailsOverview() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_OVERVIEW);
    }

    public void trackSelectNetworkDetailsHeaders() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_HEADERS);
    }

    public void trackSelectNetworkDetailsResponse() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_RESPONSE);
    }

    public void trackSelectNetworkDetailsRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_REQUEST);
    }

    public void trackSelectNetworkDetailsStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_STACK);
    }

    public void trackSelectNetworkDetailsError() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_ERROR);
    }

    public void trackSelectNetworkConnectionsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_CONNECTION_VIEW);
    }

    public void trackSelectNetworkThreadsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_THREADS_VIEW);
    }

    public void trackOpenProfilingConfigDialog() {
        this.track(AndroidProfilerEvent.Type.OPEN_CPU_CONFIG_DIALOG);
    }

    public void trackCreateCustomProfilingConfig() {
        this.track(AndroidProfilerEvent.Type.CREATE_CPU_CONFIG);
    }

    public void trackSelectEnergyRange(@NotNull com.android.tools.profilers.analytics.energy.EnergyRangeMetadata rangeMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_RANGE).setEnergyRangeMetadata(rangeMetadata).track();
    }

    public void trackSelectEnergyEvent(@NotNull EnergyEventMetadata eventMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_EVENT).setEnergyEventMetadata(eventMetadata).track();
    }

    public void trackFilterMetadata(@NotNull com.android.tools.profilers.analytics.FilterMetadata filterMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.FILTER).setFilterMetadata(filterMetadata).track();
    }

    @NotNull
    private Tracker newTracker(AndroidProfilerEvent.Type eventType) {
        return new Tracker(this.myTrackingProject, eventType, this.myCurrStage);
    }

    private void track(AndroidProfilerEvent.Type eventType) {
        this.newTracker(eventType).track();
    }

    private static final Logger getLogger() {
        return Logger.getInstance(StudioFeatureTracker.class);
    }

    private static final class Tracker {
        @NotNull
        private final AndroidProfilerEvent.Type myEventType;
        @NotNull
        private final AndroidProfilerEvent.Stage myCurrStage;
        @NotNull
        private final Project myTrackingProject;
        @Nullable
        private Common.Device myDevice;
        @Nullable
        private com.android.tools.profilers.cpu.CpuCaptureMetadata myCpuCaptureMetadata;
        @Nullable
        private CpuImportTraceMetadata myCpuImportTraceMetadata;
        @Nullable
        private com.android.tools.profilers.analytics.FilterMetadata myFeatureMetadata;
        @Nullable
        private CpuApiTracingMetadata myCpuApiTracingMetadata;
        @Nullable
        private com.android.tools.profilers.analytics.energy.EnergyRangeMetadata myEnergyRangeMetadata;
        @Nullable
        private EnergyEventMetadata myEnergyEventMetadata;
        @Nullable
        private ProfilerSessionCreationMetaData mySessionCreationMetadata;
        @Nullable
        private ProfilerSessionSelectionMetaData mySessionArtifactMetadata;
        @Nullable
        private ProfilingConfiguration myCpuStartupProfilingConfiguration;
        @Nullable
        private TransportFailureMetadata myTransportFailureMetadata;
        private AndroidProfilerEvent.MemoryHeap myMemoryHeap = AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;

        public Tracker(@NotNull Project trackingProject, @NotNull AndroidProfilerEvent.Type eventType, @NotNull AndroidProfilerEvent.Stage stage) {
            this.myEventType = eventType;
            this.myCurrStage = stage;
            this.myTrackingProject = trackingProject;
        }

        @NotNull
        public Tracker setDevice(@Nullable Common.Device device) {
            this.myDevice = device;
            return this;
        }

        @NotNull
        public Tracker setCpuCaptureMetadata(@Nullable com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
            this.myCpuCaptureMetadata = cpuCaptureMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuImportTraceMetadata(CpuImportTraceMetadata cpuImportTraceMetadata) {
            this.myCpuImportTraceMetadata = cpuImportTraceMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuStartupProfilingConfiguration(@Nullable ProfilingConfiguration configuration) {
            this.myCpuStartupProfilingConfiguration = configuration;
            return this;
        }

        @NotNull
        public Tracker setCpuApiTracingMetadata(@Nullable CpuApiTracingMetadata metadata) {
            this.myCpuApiTracingMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setFilterMetadata(@Nullable com.android.tools.profilers.analytics.FilterMetadata filterMetadata) {
            this.myFeatureMetadata = filterMetadata;
            return this;
        }

        @NotNull
        public Tracker setEnergyRangeMetadata(@Nullable com.android.tools.profilers.analytics.energy.EnergyRangeMetadata energyRangeMetadata) {
            this.myEnergyRangeMetadata = energyRangeMetadata;
            return this;
        }

        @NotNull
        public Tracker setEnergyEventMetadata(@Nullable EnergyEventMetadata energyEventMetadata) {
            this.myEnergyEventMetadata = energyEventMetadata;
            return this;
        }

        @NotNull
        public Tracker setMemoryHeapId(AndroidProfilerEvent.MemoryHeap heap) {
            this.myMemoryHeap = heap;
            return this;
        }

        @NotNull
        public Tracker setSessionCreationMetadata(ProfilerSessionCreationMetaData metadata) {
            this.mySessionCreationMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setSessionSelectionMetadata(ProfilerSessionSelectionMetaData metadata) {
            this.mySessionArtifactMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setTransportFailureMetadata(TransportFailureMetadata metadata) {
            this.myTransportFailureMetadata = metadata;
            return this;
        }

        public void track() {
            AndroidProfilerEvent.Builder profilerEvent = AndroidProfilerEvent.newBuilder().setStage(this.myCurrStage).setType(this.myEventType);
            this.populateCpuCaptureMetadata(profilerEvent);
            this.populateFilterMetadata(profilerEvent);
            this.populateEnergyRangeMetadata(profilerEvent);
            this.populateEnergyEventMetadata(profilerEvent);
            switch (this.myEventType) {
                case SELECT_MEMORY_HEAP: {
                    profilerEvent.setMemoryHeap(this.myMemoryHeap);
                    break;
                }
                case SESSION_CREATED: {
                    profilerEvent.setSessionStartMetadata(this.mySessionCreationMetadata);
                    break;
                }
                case SESSION_ARTIFACT_SELECTED: {
                    profilerEvent.setSessionArtifactMetadata(this.mySessionArtifactMetadata);
                    break;
                }
                case TRANSPORT_DAEMON_FAILED: 
                case TRANSPORT_PROXY_FAILED: {
                    assert (this.myTransportFailureMetadata != null);
                    profilerEvent.setTransportFailureMetadata(this.myTransportFailureMetadata);
                    break;
                }
                case CPU_API_TRACING: {
                    profilerEvent.setCpuApiTracingMetadata(this.myCpuApiTracingMetadata);
                    break;
                }
                case CPU_STARTUP_PROFILING: {
                    profilerEvent.setCpuStartupProfilingMetadata(CpuStartupProfilingMetadata.newBuilder().setProfilingConfig(this.toStatsCpuProfilingConfig(this.myCpuStartupProfilingConfiguration)));
                    break;
                }
                case CPU_IMPORT_TRACE: {
                    assert (this.myCpuImportTraceMetadata != null);
                    profilerEvent.setCpuImportTraceMetadata(this.myCpuImportTraceMetadata);
                    break;
                }
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(profilerEvent);
            if (this.myDevice != null) {
                event.setDeviceInfo(DeviceInfo.newBuilder().setManufacturer(this.myDevice.getManufacturer()).setModel(this.myDevice.getModel()).setBuildVersionRelease(this.myDevice.getVersion()).setBuildApiLevelFull(new AndroidVersion(this.myDevice.getApiLevel(), this.myDevice.getCodename()).getApiString()).setDeviceType(this.myDevice.getIsEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).build());
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myTrackingProject));
        }

        private void populateEnergyRangeMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myEnergyRangeMetadata == null) {
                return;
            }
            EnergyRangeMetadata.Builder builder = EnergyRangeMetadata.newBuilder();
            this.myEnergyRangeMetadata.getEventCounts().forEach(eventCount -> builder.addEventCounts(EnergyEventCount.newBuilder().setType(this.toEnergyType(eventCount.getKind())).setCount(eventCount.getCount()).build()));
            profilerEvent.setEnergyRangeMetadata(builder.build());
        }

        private void populateEnergyEventMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myEnergyEventMetadata == null || this.myEnergyEventMetadata.getSubevents().isEmpty()) {
                return;
            }
            EnergyEventMetadata.Builder builder = com.google.wireless.android.sdk.stats.EnergyEventMetadata.newBuilder();
            List subevents = this.myEnergyEventMetadata.getSubevents();
            EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)subevents.get(0);
            builder.setType(this.toEnergyType(firstEvent));
            EnergyEvent.Subtype eventSubtype = this.toEnergySubtype(firstEvent);
            if (eventSubtype != null) {
                builder.setSubtype(eventSubtype);
            }
            for (EnergyProfiler.EnergyEvent event : subevents) {
                builder.addSubevents(this.toEnergySubevent(event));
            }
            profilerEvent.setEnergyEventMetadata(builder);
        }

        private void populateFilterMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myFeatureMetadata != null) {
                FilterMetadata.Builder filterMetadata = FilterMetadata.newBuilder();
                filterMetadata.setFeaturesUsed((long)this.myFeatureMetadata.getFeaturesUsed());
                filterMetadata.setMatchedElements(this.myFeatureMetadata.getMatchedElementCount());
                filterMetadata.setTotalElements(this.myFeatureMetadata.getTotalElementCount());
                filterMetadata.setSearchLength(this.myFeatureMetadata.getFilterTextLength());
                switch (this.myFeatureMetadata.getView()) {
                    case UNKNOWN_FILTER_VIEW: {
                        filterMetadata.setActiveView(FilterMetadata.View.UNKNOWN_FILTER_VIEW);
                        break;
                    }
                    case CPU_TOP_DOWN: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_TOP_DOWN);
                        break;
                    }
                    case CPU_BOTTOM_UP: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_BOTTOM_UP);
                        break;
                    }
                    case CPU_FLAME_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_FLAME_CHART);
                        break;
                    }
                    case CPU_CALL_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_CALL_CHART);
                        break;
                    }
                    case MEMORY_CALLSTACK: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CALLSTACK);
                        break;
                    }
                    case MEMORY_PACKAGE: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_PACKAGE);
                        break;
                    }
                    case MEMORY_CLASS: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CLASS);
                        break;
                    }
                    case NETWORK_CONNECTIONS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_CONNECTIONS);
                        break;
                    }
                    case NETWORK_THREADS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_THREADS);
                    }
                }
                profilerEvent.setFilterMetadata(filterMetadata);
            }
        }

        private void populateCpuCaptureMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myCpuCaptureMetadata != null) {
                CpuCaptureMetadata.Builder captureMetadata = CpuCaptureMetadata.newBuilder().setCaptureDurationMs(this.myCpuCaptureMetadata.getCaptureDurationMs()).setRecordDurationMs(this.myCpuCaptureMetadata.getRecordDurationMs()).setTraceFileSizeBytes(this.myCpuCaptureMetadata.getTraceFileSizeBytes()).setParsingTimeMs(this.myCpuCaptureMetadata.getParsingTimeMs()).setStoppingTimeMs(this.myCpuCaptureMetadata.getStoppingTimeMs()).setCaptureStatus((CpuCaptureMetadata.CaptureStatus)CPU_CAPTURE_STATUS_MAP.getOrDefault((Object)this.myCpuCaptureMetadata.getStatus(), (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS));
                captureMetadata.setProfilingConfig(this.toStatsCpuProfilingConfig(this.myCpuCaptureMetadata.getProfilingConfiguration()));
                if (this.myCpuCaptureMetadata.getProfilingConfiguration().getTraceType() == Cpu.CpuTraceType.ART) {
                    captureMetadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
                }
                profilerEvent.setCpuCaptureMetadata(captureMetadata);
            }
        }

        @NotNull
        private CpuProfilingConfig toStatsCpuProfilingConfig(@NotNull ProfilingConfiguration config) {
            CpuProfilingConfig.Builder cpuConfigInfo = CpuProfilingConfig.newBuilder().setSampleInterval(config.getProfilingSamplingIntervalUs()).setSizeLimit(config.getProfilingBufferSizeInMb());
            switch (config.getTraceType()) {
                case ART: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ART);
                    break;
                }
                case SIMPLEPERF: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.SIMPLE_PERF);
                    break;
                }
                case ATRACE: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ATRACE);
                    break;
                }
            }
            switch (config.getMode()) {
                case SAMPLED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.SAMPLED);
                    break;
                }
                case INSTRUMENTED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.INSTRUMENTED);
                    break;
                }
            }
            return cpuConfigInfo.build();
        }

        @NotNull
        private EnergyEvent.Type toEnergyType(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            return this.toEnergyType(EnergyDuration.Kind.from((EnergyProfiler.EnergyEvent)energyEvent));
        }

        @NotNull
        private EnergyEvent.Type toEnergyType(@NotNull EnergyDuration.Kind energyKind) {
            switch (energyKind) {
                case WAKE_LOCK: {
                    return EnergyEvent.Type.WAKE_LOCK;
                }
                case ALARM: {
                    return EnergyEvent.Type.ALARM;
                }
                case JOB: {
                    return EnergyEvent.Type.JOB;
                }
                case LOCATION: {
                    return EnergyEvent.Type.LOCATION;
                }
            }
            return EnergyEvent.Type.UNKNOWN_EVENT_TYPE;
        }

        @Nullable
        private EnergyEvent.Subtype toEnergySubtype(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            if (energyEvent.getMetadataCase() == EnergyProfiler.EnergyEvent.MetadataCase.WAKE_LOCK_ACQUIRED) {
                EnergyProfiler.WakeLockAcquired wakeLockAcquired = energyEvent.getWakeLockAcquired();
                switch (wakeLockAcquired.getLevel()) {
                    case PARTIAL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PARTIAL;
                    }
                    case SCREEN_DIM_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_DIM;
                    }
                    case SCREEN_BRIGHT_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_BRIGHT;
                    }
                    case FULL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_FULL;
                    }
                    case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PROXIMITY_SCREEN_OFF;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            if (energyEvent.getMetadataCase() == EnergyProfiler.EnergyEvent.MetadataCase.ALARM_SET) {
                EnergyProfiler.AlarmSet alarmSet = energyEvent.getAlarmSet();
                switch (alarmSet.getType()) {
                    case RTC: {
                        return EnergyEvent.Subtype.ALARM_RTC;
                    }
                    case RTC_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_RTC_WAKEUP;
                    }
                    case ELAPSED_REALTIME: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME;
                    }
                    case ELAPSED_REALTIME_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME_WAKEUP;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            return null;
        }

        @NotNull
        private EnergyEvent.Subevent toEnergySubevent(@NotNull EnergyProfiler.EnergyEvent energyEvent) {
            switch (energyEvent.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: {
                    return EnergyEvent.Subevent.WAKE_LOCK_ACQUIRED;
                }
                case WAKE_LOCK_RELEASED: {
                    return EnergyEvent.Subevent.WAKE_LOCK_RELEASED;
                }
                case ALARM_SET: {
                    return EnergyEvent.Subevent.ALARM_SET;
                }
                case ALARM_CANCELLED: {
                    return EnergyEvent.Subevent.ALARM_CANCELLED;
                }
                case ALARM_FIRED: {
                    return EnergyEvent.Subevent.ALARM_FIRED;
                }
                case JOB_SCHEDULED: {
                    return EnergyEvent.Subevent.JOB_SCHEDULED;
                }
                case JOB_STARTED: {
                    return EnergyEvent.Subevent.JOB_STARTED;
                }
                case JOB_STOPPED: {
                    return EnergyEvent.Subevent.JOB_STOPPED;
                }
                case JOB_FINISHED: {
                    return EnergyEvent.Subevent.JOB_FINISHED;
                }
                case LOCATION_UPDATE_REQUESTED: {
                    return EnergyEvent.Subevent.LOCATION_UPDATE_REQUESTED;
                }
                case LOCATION_UPDATE_REMOVED: {
                    return EnergyEvent.Subevent.LOCATION_UPDATE_REMOVED;
                }
                case LOCATION_CHANGED: {
                    return EnergyEvent.Subevent.LOCATION_CHANGED;
                }
            }
            return EnergyEvent.Subevent.UNKNOWN_ENERGY_SUBEVENT;
        }
    }
}

