/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.dataviewer;

import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDataViewer
implements DataViewer {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DataViewer.Style myStyle;

    public static IntellijDataViewer createRawTextViewer(@NotNull byte[] content) {
        JTextArea textArea = new JTextArea(new String(content));
        textArea.setLineWrap(true);
        textArea.setFont(ProfilerFonts.H4_FONT);
        textArea.setEditable(false);
        textArea.setBackground(null);
        return new IntellijDataViewer(textArea, DataViewer.Style.RAW);
    }

    @NotNull
    public static IntellijDataViewer createPrettyViewerIfPossible(@NotNull Project project, @NotNull byte[] content, @Nullable FileType fileType) {
        try {
            PsiFile psiFile;
            Language language;
            final EditorFactory editorFactory = EditorFactory.getInstance();
            String contentStr = new String(content).replace("\r\n", "\n");
            DataViewer.Style style = DataViewer.Style.RAW;
            Document document = null;
            if (fileType instanceof LanguageFileType && !(language = ((LanguageFileType)fileType).getLanguage()).is((Language)PlainTextLanguage.INSTANCE) && (psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(language, (CharSequence)contentStr)) != null) {
                ReformatCodeProcessor processor = new ReformatCodeProcessor(psiFile, false);
                processor.run();
                document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                if (document != null) {
                    style = DataViewer.Style.PRETTY;
                }
            }
            if (document == null) {
                document = editorFactory.createDocument(contentStr.toCharArray());
            }
            final EditorEx editor2 = (EditorEx)editorFactory.createViewer(document);
            editor2.setCaretVisible(false);
            EditorSettings settings = editor2.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setUseSoftWraps(true);
            settings.setSoftMargins(Collections.emptyList());
            settings.setRightMarginShown(false);
            settings.setFoldingOutlineShown(true);
            CodeFoldingManager.getInstance((Project)project).updateFoldRegions((Editor)editor2);
            if (fileType != null) {
                editor2.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
            }
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    editorFactory.releaseEditor((Editor)editor2);
                }
            });
            return new IntellijDataViewer(editor2.getComponent(), style);
        }
        catch (AssertionError | Exception e) {
            return IntellijDataViewer.createInvalidViewer();
        }
    }

    @NotNull
    public static IntellijDataViewer createInvalidViewer() {
        JLabel component = new JLabel("No preview available", 0);
        component.setFont(component.getFont().deriveFont(14.0f));
        return new IntellijDataViewer(component, DataViewer.Style.INVALID);
    }

    private IntellijDataViewer(@NotNull JComponent component, @NotNull DataViewer.Style style) {
        this.myComponent = component;
        this.myStyle = style;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public DataViewer.Style getStyle() {
        return this.myStyle;
    }
}

