/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class MemoryServiceProxy
extends ServiceProxy {
    static final MemoryProfiler.LegacyAllocationEventsResponse NOT_FOUND_RESPONSE = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder().setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_FOUND).build();
    @NotNull
    private Executor myFetchExecutor;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private BiFunction<IDevice, Integer, LegacyAllocationTracker> myTrackerSupplier;
    private boolean myUseLegacyTracking;
    private final Object myUpdatingDataLock;
    private TLongObjectHashMap<LegacyAllocationTracker> myLegacyTrackers;
    private TLongObjectHashMap<TLongObjectHashMap<AllocationTrackingData>> myTrackingData;
    private TLongObjectHashMap<MemoryProfiler.AllocationsInfo> myInProgressTrackingInfo;
    private TLongObjectHashMap<TLongObjectHashMap<MemoryProfiler.AllocatedClass>> myAllocatedClasses;
    private TLongObjectHashMap<TIntObjectHashMap<MemoryProfiler.AllocationStack>> myAllocationStacks;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryServiceProxy.class);
    }

    public MemoryServiceProxy(@NotNull IDevice device, @NotNull ManagedChannel channel, @NotNull Executor fetchExecutor, @NotNull BiFunction<IDevice, Integer, LegacyAllocationTracker> legacyTrackerSupplier) {
        super(MemoryServiceGrpc.getServiceDescriptor());
        this.myServiceStub = MemoryServiceGrpc.newBlockingStub((Channel)channel);
        this.myDevice = device;
        this.myFetchExecutor = fetchExecutor;
        this.myTrackerSupplier = legacyTrackerSupplier;
        this.myUpdatingDataLock = new Object();
        if (!((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue() || this.myDevice.getVersion().getFeatureLevel() < 26) {
            this.myUseLegacyTracking = true;
            this.myLegacyTrackers = new TLongObjectHashMap();
            this.myTrackingData = new TLongObjectHashMap();
            this.myInProgressTrackingInfo = new TLongObjectHashMap();
            this.myAllocatedClasses = new TLongObjectHashMap();
            this.myAllocationStacks = new TLongObjectHashMap();
        }
    }

    public void startMonitoringApp(MemoryProfiler.MemoryStartRequest request, StreamObserver<MemoryProfiler.MemoryStartResponse> responseObserver) {
        if (this.myUseLegacyTracking && !this.myLegacyTrackers.contains(request.getSession().getSessionId())) {
            this.myLegacyTrackers.put(request.getSession().getSessionId(), (Object)this.myTrackerSupplier.apply(this.myDevice, request.getSession().getPid()));
            this.myTrackingData.put(request.getSession().getSessionId(), (Object)new TLongObjectHashMap());
            this.myAllocatedClasses.put(request.getSession().getSessionId(), (Object)new TLongObjectHashMap());
            this.myAllocationStacks.put(request.getSession().getSessionId(), (Object)new TIntObjectHashMap());
        }
        responseObserver.onNext((Object)this.myServiceStub.startMonitoringApp(request));
        responseObserver.onCompleted();
    }

    public void stopMonitoringApp(MemoryProfiler.MemoryStopRequest request, StreamObserver<MemoryProfiler.MemoryStopResponse> responseObserver) {
        if (this.myUseLegacyTracking) {
            this.myLegacyTrackers.remove(request.getSession().getSessionId());
            this.myTrackingData.remove(request.getSession().getSessionId());
            this.myInProgressTrackingInfo.remove(request.getSession().getSessionId());
            this.myAllocatedClasses.remove(request.getSession().getSessionId());
            this.myAllocationStacks.remove(request.getSession().getSessionId());
        }
        responseObserver.onNext((Object)this.myServiceStub.stopMonitoringApp(request));
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver) {
        try {
            MemoryProfiler.MemoryData data = this.myServiceStub.getData(request);
            if (this.myUseLegacyTracking) {
                Object object = this.myUpdatingDataLock;
                synchronized (object) {
                    TLongObjectHashMap infos = (TLongObjectHashMap)this.myTrackingData.get(request.getSession().getSessionId());
                    MemoryProfiler.MemoryData.Builder rebuilder = data.toBuilder();
                    long requestStartTime = request.getStartTime();
                    long requestEndTime = request.getEndTime();
                    ArrayList<MemoryProfiler.AllocationsInfo> infosToReturn = new ArrayList<MemoryProfiler.AllocationsInfo>();
                    infos.forEachValue(trackingData -> {
                        if (trackingData.myInfo.getStartTime() <= requestEndTime && trackingData.myInfo.getEndTime() > requestStartTime) {
                            infosToReturn.add(trackingData.myInfo);
                        }
                        return true;
                    });
                    infosToReturn.sort(Comparator.comparingLong(MemoryProfiler.AllocationsInfo::getStartTime));
                    for (int i2 = 0; i2 < infosToReturn.size(); ++i2) {
                        MemoryProfiler.AllocationsInfo info = (MemoryProfiler.AllocationsInfo)infosToReturn.get(i2);
                        rebuilder.addAllocationsInfo(info);
                        long infoMax = info.getEndTime() == Long.MAX_VALUE ? info.getStartTime() : info.getEndTime();
                        rebuilder.setEndTimestamp(Math.max(rebuilder.getEndTimestamp(), infoMax));
                    }
                    data = rebuilder.build();
                }
            }
            responseObserver.onNext((Object)data);
            responseObserver.onCompleted();
        }
        catch (RuntimeException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    public void trackAllocations(MemoryProfiler.TrackAllocationsRequest request, StreamObserver<MemoryProfiler.TrackAllocationsResponse> responseObserver) {
        long sessionId = request.getSession().getSessionId();
        long timestamp = request.getRequestTime();
        MemoryProfiler.TrackAllocationsResponse response = this.myUseLegacyTracking ? (request.getEnabled() ? this.enableAllocations(timestamp, sessionId) : this.disableAllocations(timestamp, sessionId)) : this.myServiceStub.trackAllocations(request);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest request, StreamObserver<MemoryProfiler.LegacyAllocationEventsResponse> responseObserver) {
        assert (this.myUseLegacyTracking);
        TLongObjectHashMap datas = (TLongObjectHashMap)this.myTrackingData.get(request.getSession().getSessionId());
        if (datas == null || !datas.containsKey(request.getStartTime()) || ((AllocationTrackingData)datas.get((long)request.getStartTime())).myDataParsingLatch == null) {
            responseObserver.onNext((Object)NOT_FOUND_RESPONSE);
        } else {
            AllocationTrackingData data = (AllocationTrackingData)datas.get(request.getStartTime());
            try {
                assert (data.myDataParsingLatch != null);
                data.myDataParsingLatch.await();
                Object object = this.myUpdatingDataLock;
                synchronized (object) {
                    assert (data.myEventsResponse != null);
                    responseObserver.onNext((Object)data.myEventsResponse);
                }
            }
            catch (InterruptedException e) {
                MemoryServiceProxy.getLogger().error("Exception while waiting for Allocation Tracking parsing results: " + e);
            }
        }
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLegacyAllocationDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        assert (this.myUseLegacyTracking);
        TLongObjectHashMap datas = (TLongObjectHashMap)this.myTrackingData.get(request.getSession().getSessionId());
        if (datas == null || !datas.containsKey(request.getDumpTime()) || ((AllocationTrackingData)datas.get((long)request.getDumpTime())).myDataParsingLatch == null) {
            responseObserver.onNext((Object)MemoryProfiler.DumpDataResponse.newBuilder().setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_FOUND).build());
        } else {
            AllocationTrackingData data = (AllocationTrackingData)datas.get(request.getDumpTime());
            try {
                assert (data.myDataParsingLatch != null);
                data.myDataParsingLatch.await();
                Object object = this.myUpdatingDataLock;
                synchronized (object) {
                    assert (data.myDumpDataResponse != null);
                    responseObserver.onNext((Object)data.myDumpDataResponse);
                }
            }
            catch (InterruptedException e) {
                MemoryServiceProxy.getLogger().error("Exception while waiting for Allocation Tracking parsing results: " + e);
            }
        }
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationContexts(MemoryProfiler.LegacyAllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        assert (this.myUseLegacyTracking);
        MemoryProfiler.AllocationContextsResponse.Builder builder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        if (this.myAllocatedClasses.containsKey(request.getSession().getSessionId())) {
            TLongObjectHashMap klasses = (TLongObjectHashMap)this.myAllocatedClasses.get(request.getSession().getSessionId());
            request.getClassIdsList().forEach(id -> {
                if (klasses.contains((long)id.intValue())) {
                    builder.addAllocatedClasses((MemoryProfiler.AllocatedClass)klasses.get((long)id.intValue()));
                } else {
                    MemoryServiceProxy.getLogger().debug("Class data cannot be found for id: " + id);
                }
            });
        }
        if (this.myAllocationStacks.containsKey(request.getSession().getSessionId())) {
            TIntObjectHashMap stacks = (TIntObjectHashMap)this.myAllocationStacks.get(request.getSession().getSessionId());
            request.getStackIdsList().forEach(id -> {
                if (stacks.contains(id.intValue())) {
                    builder.addAllocationStacks((MemoryProfiler.AllocationStack)stacks.get(id.intValue()));
                } else {
                    MemoryServiceProxy.getLogger().debug("Stack data cannot be found for id: " + id);
                }
            });
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryProfiler.TrackAllocationsResponse enableAllocations(long startTimeNs, long sessionId) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            if (this.myInProgressTrackingInfo.get(sessionId) != null) {
                return MemoryProfiler.TrackAllocationsResponse.newBuilder().setStatus(MemoryProfiler.TrackAllocationsResponse.Status.IN_PROGRESS).build();
            }
            TLongObjectHashMap datas = (TLongObjectHashMap)this.myTrackingData.get(sessionId);
            MemoryProfiler.TrackAllocationsResponse.Builder responseBuilder = MemoryProfiler.TrackAllocationsResponse.newBuilder();
            LegacyAllocationTracker tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(sessionId);
            boolean success = tracker.trackAllocations(startTimeNs, startTimeNs, true, null, null);
            if (success) {
                MemoryProfiler.AllocationsInfo newInfo = MemoryProfiler.AllocationsInfo.newBuilder().setStartTime(startTimeNs).setEndTime(Long.MAX_VALUE).setStatus(MemoryProfiler.AllocationsInfo.Status.IN_PROGRESS).setLegacy(true).build();
                responseBuilder.setInfo(newInfo);
                responseBuilder.setStatus(MemoryProfiler.TrackAllocationsResponse.Status.SUCCESS);
                AllocationTrackingData newData = new AllocationTrackingData();
                newData.myInfo = newInfo;
                datas.put(startTimeNs, (Object)newData);
                this.myInProgressTrackingInfo.put(sessionId, (Object)newInfo);
            } else {
                responseBuilder.setStatus(MemoryProfiler.TrackAllocationsResponse.Status.FAILURE_UNKNOWN);
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryProfiler.TrackAllocationsResponse disableAllocations(long endtimeNs, long sessionId) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            MemoryProfiler.AllocationsInfo lastInfo = (MemoryProfiler.AllocationsInfo)this.myInProgressTrackingInfo.get(sessionId);
            if (lastInfo == null) {
                return MemoryProfiler.TrackAllocationsResponse.newBuilder().setStatus(MemoryProfiler.TrackAllocationsResponse.Status.NOT_ENABLED).build();
            }
            LegacyAllocationTracker tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(sessionId);
            TLongObjectHashMap datas = (TLongObjectHashMap)this.myTrackingData.get(sessionId);
            MemoryProfiler.TrackAllocationsResponse.Builder responseBuilder = MemoryProfiler.TrackAllocationsResponse.newBuilder();
            boolean success = tracker.trackAllocations(lastInfo.getStartTime(), endtimeNs, false, this.myFetchExecutor, (bytes, classes, stacks, allocations) -> this.saveAllocationData(sessionId, lastInfo.getStartTime(), bytes, classes, stacks, allocations));
            MemoryProfiler.AllocationsInfo.Builder lastInfoBuilder = lastInfo.toBuilder();
            lastInfoBuilder.setEndTime(endtimeNs);
            if (success) {
                lastInfoBuilder.setStatus(MemoryProfiler.AllocationsInfo.Status.COMPLETED);
                responseBuilder.setStatus(MemoryProfiler.TrackAllocationsResponse.Status.SUCCESS);
                ((AllocationTrackingData)datas.get((long)lastInfo.getStartTime())).myDataParsingLatch = new CountDownLatch(1);
            } else {
                lastInfoBuilder.setStatus(MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN);
                responseBuilder.setStatus(MemoryProfiler.TrackAllocationsResponse.Status.FAILURE_UNKNOWN);
            }
            MemoryProfiler.AllocationsInfo updatedInfo = lastInfoBuilder.build();
            responseBuilder.setInfo(updatedInfo);
            ((AllocationTrackingData)datas.get((long)lastInfo.getStartTime())).myInfo = updatedInfo;
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllocationData(long sessionId, long infoId, byte[] rawBytes, @NotNull List<MemoryProfiler.AllocatedClass> classes, @NotNull List<MemoryProfiler.AllocationStack> stacks, @NotNull List<MemoryProfiler.LegacyAllocationEvent> events) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            TLongObjectHashMap datas = (TLongObjectHashMap)this.myTrackingData.get(sessionId);
            assert (datas.contains(infoId));
            AllocationTrackingData trackingData = (AllocationTrackingData)datas.get(infoId);
            MemoryProfiler.LegacyAllocationEventsResponse.Builder eventResponseBuilder = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder();
            MemoryProfiler.DumpDataResponse.Builder dumpResponseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
            try {
                if (rawBytes == null) {
                    eventResponseBuilder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
                    dumpResponseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
                } else {
                    eventResponseBuilder.addAllEvents(events).setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.SUCCESS);
                    dumpResponseBuilder.setData(ByteString.copyFrom((byte[])rawBytes)).setStatus(MemoryProfiler.DumpDataResponse.Status.SUCCESS);
                }
                trackingData.myEventsResponse = eventResponseBuilder.build();
                trackingData.myDumpDataResponse = dumpResponseBuilder.build();
                classes.forEach(klass -> {
                    MemoryProfiler.AllocatedClass cfr_ignored_0 = (MemoryProfiler.AllocatedClass)((TLongObjectHashMap)this.myAllocatedClasses.get(sessionId)).put((long)klass.getClassId(), klass);
                });
                stacks.forEach(stack -> {
                    MemoryProfiler.AllocationStack cfr_ignored_0 = (MemoryProfiler.AllocationStack)((TIntObjectHashMap)this.myAllocationStacks.get(sessionId)).put(stack.getStackId(), stack);
                });
            }
            finally {
                ((AllocationTrackingData)datas.get((long)infoId)).myDataParsingLatch.countDown();
                this.myInProgressTrackingInfo.remove(sessionId);
            }
        }
    }

    public void forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest request, StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse> observer) {
        if (this.myDevice.isOnline()) {
            int processId = request.getSession().getPid();
            for (Client client : this.myDevice.getClients()) {
                if (processId != client.getClientData().getPid()) continue;
                client.executeGarbageCollector();
                break;
            }
        }
        observer.onNext((Object)MemoryProfiler.ForceGarbageCollectionResponse.newBuilder().build());
        observer.onCompleted();
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap<MethodDescriptor, ServerCallHandler> overrides = new HashMap<MethodDescriptor, ServerCallHandler>();
        overrides.put(MemoryServiceGrpc.METHOD_START_MONITORING_APP, ServerCalls.asyncUnaryCall((request, observer) -> this.startMonitoringApp((MemoryProfiler.MemoryStartRequest)request, (StreamObserver<MemoryProfiler.MemoryStartResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_STOP_MONITORING_APP, ServerCalls.asyncUnaryCall((request, observer) -> this.stopMonitoringApp((MemoryProfiler.MemoryStopRequest)request, (StreamObserver<MemoryProfiler.MemoryStopResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_GET_DATA, ServerCalls.asyncUnaryCall((request, observer) -> this.getData((MemoryProfiler.MemoryRequest)request, (StreamObserver<MemoryProfiler.MemoryData>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_TRACK_ALLOCATIONS, ServerCalls.asyncUnaryCall((request, observer) -> this.trackAllocations((MemoryProfiler.TrackAllocationsRequest)request, (StreamObserver<MemoryProfiler.TrackAllocationsResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_GET_LEGACY_ALLOCATION_EVENTS, ServerCalls.asyncUnaryCall((request, observer) -> this.getLegacyAllocationEvents((MemoryProfiler.LegacyAllocationEventsRequest)request, (StreamObserver<MemoryProfiler.LegacyAllocationEventsResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_GET_LEGACY_ALLOCATION_CONTEXTS, ServerCalls.asyncUnaryCall((request, observer) -> this.getLegacyAllocationContexts((MemoryProfiler.LegacyAllocationContextsRequest)request, (StreamObserver<MemoryProfiler.AllocationContextsResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_GET_LEGACY_ALLOCATION_DUMP, ServerCalls.asyncUnaryCall((request, observer) -> this.getLegacyAllocationDump((MemoryProfiler.DumpDataRequest)request, (StreamObserver<MemoryProfiler.DumpDataResponse>)observer)));
        overrides.put(MemoryServiceGrpc.METHOD_FORCE_GARBAGE_COLLECTION, ServerCalls.asyncUnaryCall((request, observer) -> this.forceGarbageCollection((MemoryProfiler.ForceGarbageCollectionRequest)request, (StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse>)observer)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }

    private static class AllocationTrackingData {
        @NotNull
        MemoryProfiler.AllocationsInfo myInfo;
        MemoryProfiler.LegacyAllocationEventsResponse myEventsResponse;
        MemoryProfiler.DumpDataResponse myDumpDataResponse;
        CountDownLatch myDataParsingLatch;

        private AllocationTrackingData() {
        }
    }
}

