/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.StudioLegacyCpuTraceProfiler;
import com.android.tools.idea.profilers.perfd.CpuServiceProxy;
import com.android.tools.idea.profilers.perfd.EnergyServiceProxy;
import com.android.tools.idea.profilers.perfd.EventServiceProxy;
import com.android.tools.idea.profilers.perfd.MemoryServiceProxy;
import com.android.tools.idea.profilers.perfd.NetworkServiceProxy;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxy;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class ProfilerServiceProxyManager {
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryServiceProxy";

    public static void registerProxies(TransportProxy transportProxy) {
        IDevice device = transportProxy.getDevice();
        ManagedChannel transportChannel = transportProxy.getTransportChannel();
        transportProxy.registerProxyService(new ProfilerServiceProxy(transportChannel));
        transportProxy.registerProxyService(new EventServiceProxy(device, transportChannel));
        transportProxy.registerProxyService(new CpuServiceProxy(device, transportChannel, new StudioLegacyCpuTraceProfiler(device, CpuServiceGrpc.newBlockingStub((Channel)transportChannel))));
        transportProxy.registerProxyService(new MemoryServiceProxy(device, transportChannel, Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), (d, p) -> new StudioLegacyAllocationTracker((IDevice)d, (int)p)));
        transportProxy.registerProxyService(new NetworkServiceProxy(transportChannel));
        transportProxy.registerProxyService(new EnergyServiceProxy(transportChannel));
    }
}

