/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilingConfigPanel;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilingConfigurationsDialog
extends SingleConfigurableEditor {
    @NotNull
    private final CpuProfilerConfigModel myProfilerModel;
    @NotNull
    private Consumer<ProfilingConfiguration> myOnCloseCallback;
    private final int myDeviceLevel;

    public CpuProfilingConfigurationsDialog(@NotNull Project project, int deviceLevel, @NotNull CpuProfilerConfigModel model2, @NotNull Consumer<ProfilingConfiguration> onCloseCallback, @NotNull FeatureTracker featureTracker) {
        super(project, (Configurable)new ProfilingConfigurable(project, model2, deviceLevel, featureTracker), DialogWrapper.IdeModalityType.IDE);
        this.myProfilerModel = model2;
        this.myOnCloseCallback = onCloseCallback;
        this.myDeviceLevel = deviceLevel;
        this.setHorizontalStretch(1.3f);
    }

    @Nullable
    private ProfilingConfiguration getSelectedConfiguration() {
        ProfilingConfigurable configurable = (ProfilingConfigurable)this.getConfigurable();
        return configurable.getSelectedConfiguration();
    }

    public void dispose() {
        ProfilingConfiguration selectedConfig = this.myProfilerModel.getProfilingConfiguration();
        if (this.getExitCode() == 0) {
            selectedConfig = this.getSelectedConfiguration();
        }
        super.dispose();
        boolean selectedConfigSupported = selectedConfig != null && selectedConfig.isDeviceLevelSupported(this.myDeviceLevel);
        this.myOnCloseCallback.accept((ProfilingConfiguration)(selectedConfigSupported ? selectedConfig : null));
    }

    private static class ProfilingConfigurable
    implements Configurable {
        private static final String ADD = "Add";
        private static final String MOVE_DOWN = "Move Down";
        private static final String MOVE_UP = "Move Up";
        private static final String REMOVE = "Remove";
        private final JBSplitter mySplitter = new JBSplitter("ProfilingConfigurable.dividerProportion", 0.3f);
        @NotNull
        private final JList<ProfilingConfiguration> myConfigurations;
        @NotNull
        private final DefaultListModel<ProfilingConfiguration> myConfigurationsModel;
        private int myDefaultConfigurationsCount;
        private final Project myProject;
        private final FeatureTracker myFeatureTracker;
        private CpuProfilingConfigPanel myProfilersPanel;
        private CpuProfilerConfigModel myProfilerModel;
        private int myDeviceLevel;

        public ProfilingConfigurable(Project project, CpuProfilerConfigModel model2, int deviceLevel, FeatureTracker featureTracker) {
            this.myProject = project;
            this.myFeatureTracker = featureTracker;
            this.myProfilerModel = model2;
            this.myDeviceLevel = deviceLevel;
            this.myProfilersPanel = new CpuProfilingConfigPanel(this.myDeviceLevel);
            this.myConfigurationsModel = new DefaultListModel();
            this.myConfigurations = new JBList(this.myConfigurationsModel);
            this.setUpConfigurationsList();
            this.selectConfiguration(this.myProfilerModel.getProfilingConfiguration());
        }

        @Nullable
        public String getHelpTopic() {
            return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "r/studio-ui/cpu-recording-configurations-help-link.html";
        }

        private void setUpConfigurationsList() {
            this.myConfigurations.setSelectionMode(0);
            this.myConfigurations.setCellRenderer(new ProfilingConfigurationsListCellRenderer());
            this.myConfigurations.addListSelectionListener(e -> {
                int index = this.myConfigurations.getSelectedIndex();
                this.myProfilersPanel.setConfiguration(index < 0 ? null : this.myConfigurationsModel.get(index), index >= this.getCustomConfigurationCount());
            });
            for (ProfilingConfiguration configuration : this.myProfilerModel.getCustomProfilingConfigurations()) {
                this.myConfigurationsModel.addElement(configuration);
            }
            for (ProfilingConfiguration configuration : this.myProfilerModel.getDefaultProfilingConfigurations()) {
                this.myConfigurationsModel.addElement(configuration);
            }
            this.myDefaultConfigurationsCount = this.myProfilerModel.getDefaultProfilingConfigurations().size();
        }

        private int getCustomConfigurationCount() {
            return this.myConfigurationsModel.size() - this.myDefaultConfigurationsCount;
        }

        private void selectConfiguration(ProfilingConfiguration configuration) {
            for (int i2 = 0; i2 < this.myConfigurationsModel.size(); ++i2) {
                if (!configuration.getName().equals(this.myConfigurationsModel.get(i2).getName())) continue;
                this.myConfigurations.setSelectedIndex(i2);
                return;
            }
        }

        public ProfilingConfiguration getSelectedConfiguration() {
            return this.myConfigurations.getSelectedValue();
        }

        private JComponent createLeftPanel() {
            MyAddAction addAction = new MyAddAction();
            MyRemoveAction removeAction = new MyRemoveAction();
            MyMoveAction moveUpAction = new MyMoveAction(MOVE_UP, -1, IconUtil.getMoveUpIcon());
            MyMoveAction moveDownAction = new MyMoveAction(MOVE_DOWN, 1, IconUtil.getMoveUpIcon());
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myConfigurations).setAsUsualTopToolbar().setMoveUpAction((AnActionButtonRunnable)moveUpAction).setMoveUpActionUpdater((AnActionButtonUpdater)moveUpAction).setMoveUpActionName(MOVE_UP).setMoveDownAction((AnActionButtonRunnable)moveDownAction).setMoveDownActionUpdater((AnActionButtonUpdater)moveDownAction).setMoveDownActionName(MOVE_DOWN).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction).setRemoveActionName(REMOVE).setAddAction((AnActionButtonRunnable)addAction).setAddActionUpdater((AnActionButtonUpdater)addAction).setAddActionName(ADD).setMinimumSize((Dimension)new JBDimension(200, 200)).setForcedDnD();
            return toolbarDecorator.createPanel();
        }

        @Nls
        public String getDisplayName() {
            return "CPU Recording Configurations";
        }

        @Nullable
        public JComponent createComponent() {
            JPanel mainComponent = new JPanel(new BorderLayout());
            this.mySplitter.setFirstComponent(this.createLeftPanel());
            this.mySplitter.setHonorComponentsMinimumSize(true);
            this.mySplitter.setSecondComponent(this.myProfilersPanel.getComponent());
            mainComponent.add((Component)this.mySplitter, "Center");
            mainComponent.setPreferredSize(new Dimension(800, 600));
            return mainComponent;
        }

        public void apply() throws ConfigurationException {
            HashSet<String> configNames = new HashSet<String>();
            ArrayList<CpuProfilerConfig> configsToSave = new ArrayList<CpuProfilerConfig>();
            for (int i2 = 0; i2 < this.myConfigurationsModel.getSize(); ++i2) {
                ProfilingConfiguration config = this.myConfigurationsModel.getElementAt(i2);
                String configName = config.getName();
                if (StringUtil.isEmpty((String)configName)) {
                    throw new ConfigurationException("Empty configuration names are not allowed. Please rename or delete them before continuing.");
                }
                if (configNames.contains(configName)) {
                    throw new ConfigurationException("Configuration with name \"" + configName + "\" already exists.");
                }
                configNames.add(configName);
                if (ProfilingConfigurable.isDefaultConfig(config)) continue;
                configsToSave.add(CpuProfilerConfigConverter.fromProto(config.toProto()));
            }
            CpuProfilerConfigsState.getInstance(this.myProject).setUserConfigs(configsToSave);
        }

        public boolean isModified() {
            return true;
        }

        private static boolean isDefaultConfig(@NotNull ProfilingConfiguration configuration) {
            return CpuProfilerConfigsState.getDefaultConfigs().stream().anyMatch(c -> c.getName().equals(configuration.getName()));
        }

        private class MyMoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            private int myMoveDownCount;

            public MyMoveAction(String actionText, int moveDownCount, Icon icon2) {
                super(actionText, null, icon2);
                this.myMoveDownCount = moveDownCount;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.moveSelectedElement();
            }

            public void run(AnActionButton button2) {
                this.moveSelectedElement();
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return this.validSelectionExists();
            }

            private void moveSelectedElement() {
                if (this.validSelectionExists()) {
                    int origin = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    int dest = origin + this.myMoveDownCount;
                    ProfilingConfiguration temp = (ProfilingConfiguration)ProfilingConfigurable.this.myConfigurationsModel.get(origin);
                    ProfilingConfigurable.this.myConfigurationsModel.set(origin, ProfilingConfigurable.this.myConfigurationsModel.get(dest));
                    ProfilingConfigurable.this.myConfigurationsModel.set(dest, temp);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(dest);
                }
            }

            private boolean validSelectionExists() {
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() < 0) {
                    return false;
                }
                if (ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= ProfilingConfigurable.this.getCustomConfigurationCount()) {
                    return false;
                }
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount >= 0 && ProfilingConfigurable.this.myConfigurations.getSelectedIndex() + this.myMoveDownCount < ProfilingConfigurable.this.getCustomConfigurationCount();
            }
        }

        private class MyRemoveAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            public MyRemoveAction() {
                super("Remove Configuration", "Remove the selected configuration", IconUtil.getRemoveIcon());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.removeSelectedConfiguration();
            }

            public void run(AnActionButton button2) {
                this.removeSelectedConfiguration();
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return this.nonDefaultSelectionExists();
            }

            private boolean nonDefaultSelectionExists() {
                int index = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                return ProfilingConfigurable.this.myConfigurations.getSelectedIndex() >= 0 && index < ProfilingConfigurable.this.getCustomConfigurationCount();
            }

            private void removeSelectedConfiguration() {
                if (this.nonDefaultSelectionExists()) {
                    int removedIndex = ProfilingConfigurable.this.myConfigurations.getSelectedIndex();
                    ProfilingConfigurable.this.myConfigurationsModel.remove(removedIndex);
                    ProfilingConfigurable.this.myConfigurations.setSelectedIndex(removedIndex);
                }
            }
        }

        private class MyAddAction
        extends AnAction
        implements AnActionButtonRunnable,
        AnActionButtonUpdater {
            public MyAddAction() {
                super("Add Configuration", "Add a new configuration", IconUtil.getAddIcon());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                this.addConfiguration();
            }

            public void run(AnActionButton button2) {
                this.addConfiguration();
            }

            public boolean isEnabled(@NotNull AnActionEvent e) {
                return true;
            }

            private void addConfiguration() {
                ProfilingConfiguration configuration = new ProfilingConfiguration(this.getUniqueName("Unnamed"), Cpu.CpuTraceType.ART, Cpu.CpuTraceMode.SAMPLED);
                int lastConfigurationIndex = ProfilingConfigurable.this.getCustomConfigurationCount();
                ProfilingConfigurable.this.myConfigurationsModel.insertElementAt(configuration, lastConfigurationIndex);
                ProfilingConfigurable.this.myConfigurations.setSelectedIndex(lastConfigurationIndex);
                ProfilingConfigurable.this.myFeatureTracker.trackCreateCustomProfilingConfig();
                ProfilingConfigurable.this.myProfilersPanel.getPreferredFocusComponent().requestFocusInWindow();
            }

            @NotNull
            private String getUniqueName(@NotNull String name) {
                HashSet<String> names = new HashSet<String>();
                Enumeration configurations = ProfilingConfigurable.this.myConfigurationsModel.elements();
                while (configurations.hasMoreElements()) {
                    names.add(((ProfilingConfiguration)configurations.nextElement()).getName());
                }
                String uniqueName = name;
                int i2 = 1;
                while (names.contains(uniqueName)) {
                    uniqueName = String.format("%s (%d)", name, i2++);
                }
                return uniqueName;
            }
        }

        private class ProfilingConfigurationsListCellRenderer
        implements ListCellRenderer<ProfilingConfiguration> {
            private JLabel myLabel = new JLabel();

            public ProfilingConfigurationsListCellRenderer() {
                EmptyBorder marginLeft = new EmptyBorder(0, 10, 0, 0);
                this.myLabel.setBorder(marginLeft);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setPreferredSize(new Dimension(panel2.getPreferredSize().width, 25));
                panel2.setBackground(list.getBackground());
                String cellText = value2.getName();
                if (!value2.isDeviceLevelSupported(ProfilingConfigurable.this.myDeviceLevel)) {
                    cellText = cellText + String.format(" (API Level %d+)", value2.getRequiredDeviceLevel());
                }
                this.myLabel.setText(cellText);
                this.myLabel.setForeground((Color)(isSelected ? Gray._255 : JBColor.BLACK));
                if (isSelected) {
                    panel2.setBackground(ProfilerColors.CPU_PROFILING_CONFIGURATIONS_SELECTED);
                }
                panel2.add((Component)this.myLabel, "Center");
                return panel2;
            }
        }
    }
}

