/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.idea.profilers.IntellijContextMenuInstaller;
import com.android.tools.idea.profilers.stacktrace.IntelliJStackTraceView;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.StackTraceGroup;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class IntelliJStackTraceGroup
implements StackTraceGroup {
    private final Project myProject;
    private final BiFunction<Project, StackTraceModel, IntelliJStackTraceView> myViewGenerator;
    private final List<IntelliJStackTraceView> myStackTraceViews = new ArrayList<IntelliJStackTraceView>();

    public IntelliJStackTraceGroup(@NotNull Project project) {
        this(project, (p, m) -> {
            IntelliJStackTraceView view = new IntelliJStackTraceView((Project)p, (StackTraceModel)m);
            IntellijContextMenuInstaller installer = new IntellijContextMenuInstaller();
            view.installNavigationContextMenu(installer);
            view.installGenericContextMenu(installer, ContextMenuItem.SEPARATOR);
            view.installGenericContextMenu(installer, ContextMenuItem.COPY);
            return view;
        });
    }

    @VisibleForTesting
    IntelliJStackTraceGroup(@NotNull Project project, @NotNull BiFunction<Project, StackTraceModel, IntelliJStackTraceView> viewGenerator) {
        this.myProject = project;
        this.myViewGenerator = viewGenerator;
    }

    @NotNull
    public StackTraceView createStackView(@NotNull StackTraceModel model2) {
        final IntelliJStackTraceView view = this.myViewGenerator.apply(this.myProject, model2);
        this.myStackTraceViews.add(view);
        view.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (((JList)e.getSource()).getSelectedIndex() < 0) {
                    return;
                }
                IntelliJStackTraceGroup.this.myStackTraceViews.forEach(otherView -> {
                    if (otherView != view) {
                        otherView.clearSelection();
                    }
                });
            }
        });
        return view;
    }
}

