/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.profilers.stacktrace.CodeElement;
import com.android.tools.idea.profilers.stacktrace.IntelliJCodeElement;
import com.android.tools.idea.profilers.stacktrace.StackElement;
import com.android.tools.idea.profilers.stacktrace.ThreadElement;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntelliJStackTraceView
extends AspectObserver
implements StackTraceView,
DataProvider,
CopyProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StackTraceModel myModel;
    @NotNull
    private final BiFunction<Project, CodeLocation, CodeElement> myGenerator;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private final DefaultListModel<StackElement> myListModel;
    @NotNull
    private final JBList myListView;
    @NotNull
    private final StackElementRenderer myRenderer;

    public IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model2) {
        this(project, model2, IntelliJCodeElement::new);
    }

    @VisibleForTesting
    IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model2, @NotNull BiFunction<Project, CodeLocation, CodeElement> stackNavigationGenerator) {
        this.myProject = project;
        this.myModel = model2;
        this.myGenerator = stackNavigationGenerator;
        this.myListModel = new DefaultListModel();
        this.myListView = new JBList(this.myListModel);
        this.myListView.setSelectionMode(0);
        this.myListView.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myRenderer = new StackElementRenderer();
        this.myListView.setCellRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.myScrollPane = new JBScrollPane((Component)this.myListView);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        DataManager.registerDataProvider((JComponent)this.myListView, (DataProvider)this);
        this.myListView.addListSelectionListener(e -> {
            if (this.myListView.getSelectedValue() == null) {
                this.myModel.clearSelection();
            }
        });
        final Supplier<Boolean> navigationHandler = () -> {
            int index = this.myListView.getSelectedIndex();
            if (index >= 0 && index < this.myListView.getItemsCount()) {
                this.myModel.setSelectedIndex(index);
                return true;
            }
            return false;
        };
        this.myListView.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                if (keyCode == 10 && ((Boolean)navigationHandler.get()).booleanValue()) {
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                return (Boolean)navigationHandler.get();
            }
        }.installOn((Component)this.myListView);
        this.myListView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (SwingUtilities.isRightMouseButton(e) && (row = IntelliJStackTraceView.this.myListView.locationToIndex(e.getPoint())) != -1) {
                    IntelliJStackTraceView.this.myListView.setSelectedIndex(row);
                }
            }
        });
        this.myModel.addDependency((AspectObserver)this).onChange((Enum)StackTraceModel.Aspect.STACK_FRAMES, () -> {
            List stackFrames = this.myModel.getCodeLocations();
            this.myListModel.removeAllElements();
            this.myListView.clearSelection();
            stackFrames.forEach(stackFrame -> this.myListModel.addElement(this.myGenerator.apply(this.myProject, (CodeLocation)stackFrame)));
            ThreadId threadId = this.myModel.getThreadId();
            if (!threadId.equals((Object)ThreadId.INVALID_THREAD_ID)) {
                this.myListModel.addElement(new ThreadElement(threadId));
            }
        }).onChange((Enum)StackTraceModel.Aspect.SELECTED_LOCATION, () -> {
            int index = this.myModel.getSelectedIndex();
            if (this.myModel.getSelectedType() == StackTraceModel.Type.INVALID) {
                if (this.myListView.getSelectedIndex() != -1) {
                    this.myListView.clearSelection();
                }
            } else if (index >= 0 && index < this.myListView.getItemsCount()) {
                if (this.myListView.getSelectedIndex() != index) {
                    this.myListView.setSelectedIndex(index);
                }
            } else {
                throw new IndexOutOfBoundsException("View has " + this.myListView.getItemsCount() + " elements while aspect is changing to index " + index);
            }
        });
    }

    public void installNavigationContextMenu(@NotNull ContextMenuInstaller contextMenuInstaller) {
        contextMenuInstaller.installNavigationContextMenu((JComponent)this.myListView, this.myModel.getCodeNavigator(), () -> {
            int index = this.myListView.getSelectedIndex();
            if (index >= 0 && index < this.myListView.getItemsCount()) {
                return (CodeLocation)this.myModel.getCodeLocations().get(index);
            }
            return null;
        });
    }

    public void installGenericContextMenu(@NotNull ContextMenuInstaller installer, @NotNull ContextMenuItem contextMenuItem) {
        installer.installGenericContextMenu((JComponent)this.myListView, contextMenuItem);
    }

    @NotNull
    public StackTraceModel getModel() {
        return this.myModel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myScrollPane;
    }

    public void addListSelectionListener(@NotNull ListSelectionListener listener2) {
        this.myListView.addListSelectionListener(listener2);
    }

    public void clearSelection() {
        this.myListView.clearSelection();
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        int selectedIndex = this.myListView.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.myListView.getItemsCount()) {
            this.myRenderer.getListCellRendererComponent((JList)this.myListView, this.myListModel.getElementAt(selectedIndex), selectedIndex, true, false);
            String data = String.valueOf(this.myRenderer.getCharSequence(false));
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(data));
        }
    }

    @Nullable
    public Object getData(String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.myListView.getSelectedIndex();
    }

    @VisibleForTesting
    @NotNull
    JBList getListView() {
        return this.myListView;
    }

    private static final class StackElementRenderer
    extends ColoredListCellRenderer<StackElement> {
        private StackElementRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, StackElement value2, int index, boolean selected, boolean hasFocus) {
            if (value2 == null) {
                return;
            }
            this.setIpad(ProfilerLayout.LIST_ROW_INSETS);
            if (value2 instanceof CodeElement) {
                CodeElement element = (CodeElement)value2;
                if (element.getCodeLocation().isNativeCode()) {
                    this.renderNativeStackFrame(element, selected);
                } else {
                    this.renderJavaStackFrame(element, selected);
                }
            } else if (value2 instanceof ThreadElement) {
                this.renderThreadElement((ThreadElement)value2, selected);
            } else {
                this.append(value2.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private void renderJavaStackFrame(@NotNull CodeElement codeElement, boolean selected) {
            this.setIcon(PlatformIcons.METHOD_ICON);
            SimpleTextAttributes textAttribute = selected || codeElement.isInUserCode() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            CodeLocation location = codeElement.getCodeLocation();
            StringBuilder methodBuilder = new StringBuilder(codeElement.getMethodName());
            if (location.getLineNumber() != -1) {
                methodBuilder.append(":");
                methodBuilder.append(location.getLineNumber() + 1);
            }
            methodBuilder.append(", ");
            methodBuilder.append(codeElement.getSimpleClassName());
            String methodName = methodBuilder.toString();
            this.append(methodName, textAttribute, methodName);
            String packageName = " (" + codeElement.getPackageName() + ")";
            this.append(packageName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, packageName);
        }

        private void renderNativeStackFrame(@NotNull CodeElement codeElement, boolean selected) {
            this.setIcon(PlatformIcons.METHOD_ICON);
            CodeLocation location = codeElement.getCodeLocation();
            StringBuilder methodBuilder = new StringBuilder();
            if (!Strings.isNullOrEmpty((String)location.getClassName())) {
                methodBuilder.append(location.getClassName());
                methodBuilder.append("::");
            }
            methodBuilder.append(location.getMethodName());
            methodBuilder.append("(" + String.join((CharSequence)",", location.getMethodParameters()) + ") ");
            String methodName = methodBuilder.toString();
            this.append(methodName, SimpleTextAttributes.REGULAR_ATTRIBUTES, methodName);
            if (!Strings.isNullOrEmpty((String)location.getFileName())) {
                String sourceLocation = Paths.get(location.getFileName(), new String[0]).getFileName().toString();
                if (location.getLineNumber() != -1) {
                    sourceLocation = sourceLocation + ":" + String.valueOf(location.getLineNumber() + 1);
                }
                this.append(sourceLocation, SimpleTextAttributes.REGULAR_ATTRIBUTES, sourceLocation);
            }
            String moduleName = " " + Paths.get(location.getNativeModuleName(), new String[0]).getFileName().toString();
            this.append(moduleName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, moduleName);
        }

        private void renderThreadElement(@NotNull ThreadElement threadElement, boolean selected) {
            this.setIcon(AllIcons.Debugger.ThreadSuspended);
            String text = threadElement.getThreadId().toString();
            this.append(text, selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES, text);
        }
    }
}

