/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisResultsContent;
import com.android.tools.idea.profiling.view.CaptureEditorLightToolWindowManager;
import com.android.tools.idea.profiling.view.CapturePanel;
import com.android.tools.idea.profiling.view.EmptyManager;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.ToolWindowAnchor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisResultsManager
extends CaptureEditorLightToolWindowManager {
    private final AnalysisResultsContent myContent = new AnalysisResultsContent();

    @NotNull
    public static AnalysisResultsManager getInstance(@NotNull Project project) {
        return (AnalysisResultsManager)((Object)project.getComponent(AnalysisResultsManager.class));
    }

    protected AnalysisResultsManager(@NotNull Project project, @NotNull FileEditorManager fileEditorManager) {
        super(project, fileEditorManager);
        Disposer.register((Disposable)this, () -> this.myContent.dispose());
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myContent.update(designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
            if (activeDesigner != null && activeDesigner instanceof CapturePanel && activeDesigner.getClientProperty((Object)this.getComponentName()) == null) {
                activeDesigner.putClientProperty((Object)this.getComponentName(), (Object)this.myContent);
            }
            this.myToolWindow.setIcon(this.getIcon());
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    @NotNull
    protected Icon getIcon() {
        return this.myContent.getIcon() == null ? AllIcons.Toolwindows.ToolWindowFind : this.myContent.getIcon();
    }

    @Override
    @NotNull
    protected String getManagerName() {
        return AndroidBundle.message("android.captures.analysis.results.manager.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String getToolWindowTitleBarText() {
        return AndroidBundle.message("android.captures.analysis.results.manager.titlebar.text", new Object[0]);
    }

    @Override
    @NotNull
    protected AnAction[] createActions() {
        return new AnAction[]{new ToggleAction(AndroidBundle.message("android.captures.analysis.results.manager.run.name", new Object[0]), AndroidBundle.message("android.captures.analysis.results.manager.run.description", new Object[0]), AllIcons.Toolwindows.ToolWindowRun){

            public boolean isSelected(@NotNull AnActionEvent e) {
                AnalysisResultsContent analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner();
                return analysisResultsContent != null && !analysisResultsContent.canRunAnalysis();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                AnalysisResultsContent analysisResultsContent;
                if (state && (analysisResultsContent = AnalysisResultsManager.this.getContentFromDesigner()) != null && analysisResultsContent.canRunAnalysis()) {
                    analysisResultsContent.performAnalysis();
                }
            }

            public void update(@NotNull AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                if (this.isSelected(e)) {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.disabled.description", new Object[0]));
                    presentation.setIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Execute));
                } else {
                    presentation.setText(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.name", new Object[0]));
                    presentation.setDescription(AndroidBundle.message("android.captures.analysis.results.manager.run.enabled.description", new Object[0]));
                    presentation.setIcon(AllIcons.Toolwindows.ToolWindowRun);
                }
            }
        }};
    }

    @Override
    @NotNull
    protected JComponent getContent() {
        return this.myContent.getMainPanel();
    }

    @Override
    @Nullable
    protected JComponent getFocusedComponent() {
        return this.myContent.getFocusComponent();
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    @NotNull
    public String getComponentName() {
        return "CaptureAnalysis";
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        AnalysisResultsContent content = new AnalysisResultsContent();
        content.update(designer);
        Icon icon2 = content.getIcon();
        if (icon2 == null) {
            icon2 = this.getIcon();
        }
        JComponent focus = content.getFocusComponent();
        LightToolWindow lightToolWindow = this.createContent(designer, content, this.getToolWindowTitleBarText(), icon2, content.getMainPanel(), focus == null ? content.getMainPanel() : focus, 320, this.createActions());
        try {
            LightToolWindow.class.getDeclaredMethod("minimize", new Class[0]).invoke((Object)lightToolWindow, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lightToolWindow;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return EmptyManager.getInstance(this.myProject);
            }
        };
    }

    @Nullable
    private AnalysisResultsContent getContentFromDesigner() {
        DesignerEditorPanelFacade activeDesigner = this.getActiveDesigner();
        if (activeDesigner != null && activeDesigner instanceof CapturePanel) {
            Object property2 = activeDesigner.getClientProperty((Object)this.getComponentName());
            if (property2 instanceof LightToolWindow) {
                LightToolWindow lightToolWindow = (LightToolWindow)property2;
                Object content = lightToolWindow.getContent();
                if (content instanceof AnalysisResultsContent) {
                    return (AnalysisResultsContent)content;
                }
            } else if (property2 instanceof AnalysisResultsContent) {
                return (AnalysisResultsContent)property2;
            }
        }
        return null;
    }
}

