/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.view.AnalysisContentsDelegate;
import com.android.tools.idea.profiling.view.AnalysisResultsManager;
import com.android.tools.idea.profiling.view.CaptureEditor;
import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturePanel
extends JPanel
implements DesignerEditorPanelFacade {
    @NotNull
    private Project myProject;
    @NotNull
    private CaptureEditor myEditor;
    @NotNull
    private AnalyzerTask[] myTasks;
    @NotNull
    private ThreeComponentsSplitter myThreeComponentsSplitter;
    @Nullable
    private InlineProgressIndicator myProgressIndicator;
    @Nullable
    private AnalysisContentsDelegate myResultsDelegate;
    @Nullable
    private Runnable myFinishedLoadingCallback;

    public CapturePanel(@NotNull Project project, @NotNull CaptureEditor editor2, @NotNull AnalyzerTask[] tasks, boolean startAsLoading) {
        this.myProject = project;
        this.myEditor = editor2;
        this.myTasks = tasks;
        this.myThreeComponentsSplitter = new ThreeComponentsSplitter(false);
        this.myThreeComponentsSplitter.setHonorComponentsMinimumSize(true);
        Disposer.register((Disposable)editor2, (Disposable)this.myThreeComponentsSplitter);
        if (startAsLoading) {
            TaskInfo taskInfo = new TaskInfo(){

                @NotNull
                public String getTitle() {
                    return "";
                }

                public String getCancelText() {
                    return null;
                }

                public String getCancelTooltipText() {
                    return null;
                }

                public boolean isCancellable() {
                    return false;
                }
            };
            this.myProgressIndicator = new InlineProgressIndicator(true, taskInfo){

                protected void queueRunningUpdate(@NotNull Runnable update2) {
                    ApplicationManager.getApplication().invokeLater(update2);
                }
            };
            this.setLayout(new GridBagLayout());
            this.add(this.myProgressIndicator.getComponent());
        }
    }

    public void setEditorPanel(final @NotNull JComponent editorPanel, final @NotNull AnalysisContentsDelegate delegate) {
        assert (!this.isDoneLoading());
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CapturePanel.this.removeAll();
                CapturePanel.this.myProgressIndicator = null;
                CapturePanel.this.myResultsDelegate = delegate;
                CapturePanel.this.setLayout(new BorderLayout());
                CapturePanel.this.myThreeComponentsSplitter.setInnerComponent(editorPanel);
                AnalysisResultsManager.getInstance(CapturePanel.this.myProject).bind(CapturePanel.this);
                CapturePanel.this.add((Component)CapturePanel.this.myThreeComponentsSplitter, "Center");
                if (CapturePanel.this.myFinishedLoadingCallback != null) {
                    CapturePanel.this.myFinishedLoadingCallback.run();
                    CapturePanel.this.myFinishedLoadingCallback = null;
                }
            }
        });
    }

    public ThreeComponentsSplitter getContentSplitter() {
        return this.myThreeComponentsSplitter;
    }

    @Nullable
    public InlineProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    public boolean isDoneLoading() {
        return this.myProgressIndicator == null;
    }

    @NotNull
    public AnalyzerTask[] getAnalyzerTasks() {
        return this.myTasks;
    }

    @NotNull
    public AnalysisReport performAnalysis(Set<? extends AnalyzerTask> tasks, @NotNull Set<AnalysisReport.Listener> listeners) {
        return this.myEditor.performAnalysis(tasks, listeners);
    }

    @NotNull
    public AnalysisContentsDelegate getContentsDelegate() {
        assert (this.myResultsDelegate != null);
        return this.myResultsDelegate;
    }

    @NotNull
    public CaptureEditor getEditor() {
        return this.myEditor;
    }

    public void runWhenFinishedLoading(@NotNull Runnable callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myFinishedLoadingCallback = callback2;
        if (this.isDoneLoading()) {
            this.myFinishedLoadingCallback.run();
            this.myFinishedLoadingCallback = null;
        }
    }
}

