/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class AndroidKtsSupportNotification {
    public static final String KTS_WARNING_MSG = "This project uses Gradle KTS build files which are not fully supported. Some functions may be affected.";
    public static final String KTS_WARNING_TITLE = "Gradle KTS Build Files";
    public static final NotificationGroup KTS_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Gradle KTS build files");
    @NotNull
    private final Project myProject;
    private boolean alreadyShown;

    @NotNull
    public static AndroidKtsSupportNotification getInstance(@NotNull Project project) {
        return (AndroidKtsSupportNotification)ServiceManager.getService((Project)project, AndroidKtsSupportNotification.class);
    }

    public AndroidKtsSupportNotification(@NotNull Project project) {
        this.myProject = project;
        this.alreadyShown = false;
    }

    public void showWarningIfNotShown() {
        if (!this.alreadyShown) {
            AndroidNotification.getInstance(this.myProject).showBalloon(KTS_WARNING_TITLE, KTS_WARNING_MSG, NotificationType.WARNING, KTS_NOTIFICATION_GROUP, new DisableAndroidKtsNotificationHyperlink());
            NotificationSettings settings = NotificationsConfigurationImpl.getSettings((String)KTS_NOTIFICATION_GROUP.getDisplayId());
            this.alreadyShown = settings.getDisplayType() != NotificationDisplayType.NONE || settings.isShouldLog();
        }
    }

    public static class DisableAndroidKtsNotificationHyperlink
    extends NotificationHyperlink {
        protected DisableAndroidKtsNotificationHyperlink() {
            super("disableKtsNotification", "Disable this warning");
        }

        @Override
        protected void execute(@NotNull Project project) {
            NotificationsConfiguration.getNotificationsConfiguration().changeSettings(KTS_NOTIFICATION_GROUP.getDisplayId(), NotificationDisplayType.NONE, false, false);
        }
    }
}

