/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.ui.CustomNotificationListener;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidNotification {
    public static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)"Android Notification Group");
    public static final NotificationGroup LOG_ONLY_GROUP = NotificationGroup.logOnlyGroup((String)"Android Notification Log-Only Group");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidNotification getInstance(@NotNull Project project) {
        return (AndroidNotification)ServiceManager.getService((Project)project, AndroidNotification.class);
    }

    public AndroidNotification(@NotNull Project project) {
        this.myProject = project;
    }

    public void addLogEvent(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        this.showNotification(title, text, type, LOG_ONLY_GROUP, null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        this.showBalloon(title, text, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text, type, BALLOON_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, NotificationHyperlink ... hyperlinks) {
        this.showBalloon(title, text, type, group, true, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidNotification.addHyperlinksToText(text, newLineForLinkText, hyperlinks);
        this.showNotification(title, newText, type, group, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text, boolean newLineForLinkText, NotificationHyperlink ... hyperlinks) {
        if (hyperlinks.length == 0) {
            return text;
        }
        StringBuilder b = new StringBuilder();
        b.append(text);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            if (newLineForLinkText) {
                b.append("<br>\n");
            }
            b.append(hyperlink.toHtml());
        }
        return b.toString();
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        this.showNotification(title, text, type, BALLOON_GROUP, listener2);
    }

    private void showNotification(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, @Nullable NotificationListener listener2) {
        Notification notification = group.createNotification(title, text, type, listener2);
        Runnable notificationTask = () -> {
            if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                boolean similar;
                Notification old = this.myNotification;
                if (old != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old.getContent()))) {
                    old.expire();
                }
                this.myNotification = notification;
                notification.notify(this.myProject);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }
}

