/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectBuildNotifications {
    private static final Topic<AndroidProjectBuildListener> TOPIC = new Topic("Android Project Build", AndroidProjectBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;

    public static void subscribe(@NotNull Project project, @NotNull AndroidProjectBuildListener listener2) {
        AndroidProjectBuildNotifications.subscribe(project, (Disposable)project, listener2);
    }

    public static void subscribe(@NotNull Project project, @NotNull Disposable disposable, @NotNull AndroidProjectBuildListener listener2) {
        MessageBusConnection connection = project.getMessageBus().connect(disposable);
        connection.subscribe(TOPIC, (Object)listener2);
    }

    @NotNull
    public static AndroidProjectBuildNotifications getInstance(@NotNull Project project) {
        return (AndroidProjectBuildNotifications)ServiceManager.getService((Project)project, AndroidProjectBuildNotifications.class);
    }

    public AndroidProjectBuildNotifications(@NotNull Project project, @NotNull MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void notifyBuildComplete(@NotNull BuildContext context) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> ((AndroidProjectBuildListener)this.myMessageBus.syncPublisher(TOPIC)).buildComplete(context));
    }

    public static interface BuildContext {
    }

    public static interface AndroidProjectBuildListener {
        public void buildComplete(@NotNull BuildContext var1);
    }
}

