/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurations {
    @NotNull
    public static AndroidRunConfigurations getInstance() {
        return (AndroidRunConfigurations)ServiceManager.getService(AndroidRunConfigurations.class);
    }

    public void createRunConfiguration(@NotNull AndroidFacet facet) {
        Module module = facet.getModule();
        ConfigurationFactory configurationFactory = AndroidRunConfigurationType.getInstance().getFactory();
        List configurations = RunManager.getInstance((Project)module.getProject()).getConfigurationsList(configurationFactory.getType());
        for (RunConfiguration configuration : configurations) {
            if (!(configuration instanceof AndroidRunConfiguration) || ((JavaRunConfigurationModule)((AndroidRunConfiguration)configuration).getConfigurationModule()).getModule() != module) continue;
            return;
        }
        this.addRunConfiguration(facet, (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get() != false ? TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX : TargetSelectionMode.SHOW_DIALOG);
    }

    public void addRunConfiguration(@NotNull AndroidFacet facet, @Nullable TargetSelectionMode targetSelectionMode) {
        Module module = facet.getModule();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        RunnerAndConfigurationSettings settings = runManager.createConfiguration(module.getName(), AndroidRunConfigurationType.class);
        AndroidRunConfiguration configuration = (AndroidRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4) {
            configuration.setLaunchUrl(InstantApps.getDefaultInstantAppUrl(facet));
        } else {
            configuration.MODE = LaunchUtils.isWatchFaceApp(facet) ? "do_nothing" : "default_activity";
        }
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
        TransactionGuard.submitTransaction((Disposable)module.getProject(), () -> {
            runManager.addConfiguration(settings);
            runManager.setSelectedConfiguration(settings);
        });
    }
}

