/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class CustomProjectTypeImporter {
    private static final ExtensionPointName<CustomProjectTypeImporter> EP_NAME = ExtensionPointName.create((String)"com.android.customProjectTypeImporter");

    @NotNull
    public static MainImporter getMain() {
        return (MainImporter)ServiceManager.getService(MainImporter.class);
    }

    public abstract boolean canImport(@NotNull VirtualFile var1);

    public abstract void importFile(@NotNull VirtualFile var1);

    public static class MainImporter {
        @NotNull
        private final CustomProjectTypeImporter[] myExtensions;

        public MainImporter() {
            this((CustomProjectTypeImporter[])EP_NAME.getExtensions());
        }

        @VisibleForTesting
        MainImporter(CustomProjectTypeImporter ... extensions) {
            this.myExtensions = extensions;
        }

        public boolean importFileAsProject(@NotNull VirtualFile file) {
            for (CustomProjectTypeImporter importer : this.myExtensions) {
                if (!importer.canImport(file)) continue;
                importer.importFile(file);
                return true;
            }
            return false;
        }
    }
}

