/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BatchUpdatesUtil;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingSuspender {
    private static final Logger LOG = Logger.getInstance(IndexingSuspender.class);
    private boolean myTestingIndexingSuspender;
    @NotNull
    private final Project myProject;
    private boolean myScheduledAfterProjectInitialisation;
    @Nullable
    private DeactivationEvent myDeactivationEvent;
    private volatile boolean myActivated;

    public static void ensureInitialised(@NotNull Project project) {
        ServiceManager.getService((Project)project, IndexingSuspender.class);
    }

    public IndexingSuspender(@NotNull Project project) {
        this(project, false);
    }

    @VisibleForTesting
    IndexingSuspender(@NotNull Project project, boolean testing) {
        this.myTestingIndexingSuspender = testing;
        this.myProject = project;
        if (!this.canActivate()) {
            return;
        }
        this.subscribeToSyncAndBuildEvents();
    }

    private void consumeActivationEvent(@NotNull ActivationEvent event) {
        LOG.info("Consuming IndexingSuspender activation event: " + event.toString());
        switch (event) {
            case SYNC_STARTED: {
                if (!this.myProject.isInitialized()) {
                    if (this.myActivated) {
                        this.ensureDeactivated();
                    }
                    this.myScheduledAfterProjectInitialisation = true;
                    StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
                        if (this.myScheduledAfterProjectInitialisation) {
                            this.activate(ActivationEvent.SYNC_STARTED, DeactivationEvent.SYNC_FINISHED);
                            this.myScheduledAfterProjectInitialisation = false;
                        }
                    });
                    break;
                }
                if (this.myActivated) break;
                this.activate(ActivationEvent.SYNC_STARTED, DeactivationEvent.SYNC_FINISHED);
                break;
            }
            case SETUP_STARTED: {
                if (!this.myProject.isInitialized()) {
                    this.clearStateConditions();
                    IndexingSuspender.reportStateError("Project is expected to be initialised before project setup starts.");
                    break;
                }
                if (this.myActivated) break;
                this.activate(ActivationEvent.SETUP_STARTED, DeactivationEvent.SYNC_FINISHED);
                break;
            }
            case BUILD_EXECUTOR_CREATED: {
                if (this.myDeactivationEvent != DeactivationEvent.SYNC_FINISHED) break;
                this.myDeactivationEvent = DeactivationEvent.BUILD_FINISHED;
                break;
            }
            case BUILD_STARTED: {
                if (this.myActivated) break;
                this.activate(ActivationEvent.BUILD_STARTED, DeactivationEvent.BUILD_FINISHED);
                break;
            }
            case TEMPLATE_RENDERING_STARTED: {
                if (this.myActivated) break;
                this.activate(ActivationEvent.TEMPLATE_RENDERING_STARTED, DeactivationEvent.TEMPLATE_RENDERING_FINISHED);
                break;
            }
            case SYNC_TASK_CREATED: {
                if (this.myDeactivationEvent != DeactivationEvent.TEMPLATE_RENDERING_FINISHED) break;
                this.myDeactivationEvent = DeactivationEvent.SYNC_FINISHED;
            }
        }
    }

    private void consumeDeactivationEvent(@NotNull DeactivationEvent event) {
        LOG.info("Consuming IndexingSuspender deactivation event: " + event.toString());
        this.myScheduledAfterProjectInitialisation = false;
        if (event == this.myDeactivationEvent) {
            this.ensureDeactivated();
        } else {
            LOG.info("IndexingSuspender deactivation event received and ignored: " + event.toString());
        }
    }

    private static void reportStateError(@NotNull String message2) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            throw new IllegalStateException(message2);
        }
        LOG.warn(message2);
    }

    private void subscribeToSyncAndBuildEvents() {
        LOG.info(String.format("Subscribing project '%1$s' to indexing suspender events (%2$s)", this.myProject.toString(), this.toString()));
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener(){

            @Override
            public void syncTaskCreated(@NotNull Project project, @NotNull GradleSyncInvoker.Request request) {
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SYNC_TASK_CREATED);
            }

            @Override
            public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SYNC_STARTED);
            }

            @Override
            public void setupStarted(@NotNull Project project) {
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.SETUP_STARTED);
            }

            @Override
            public void syncSucceeded(@NotNull Project project) {
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }

            @Override
            public void syncSkipped(@NotNull Project project) {
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.SYNC_FINISHED);
            }
        });
        MultiTemplateRenderer.subscribe(this.myProject, new MultiTemplateRenderer.TemplateRendererListener(){

            @Override
            public void multiRenderingStarted() {
                IndexingSuspender.this.consumeActivationEvent(ActivationEvent.TEMPLATE_RENDERING_STARTED);
            }

            @Override
            public void multiRenderingFinished() {
                IndexingSuspender.this.consumeDeactivationEvent(DeactivationEvent.TEMPLATE_RENDERING_FINISHED);
            }
        });
    }

    private void activate(@NotNull ActivationEvent activationEvent, @NotNull DeactivationEvent deactivationEvent) {
        if (this.myActivated) {
            IndexingSuspender.reportStateError("Must not attempt to activate IndexingSuspender when it is already activated. Ignored.");
            return;
        }
        if (!this.canActivate()) {
            LOG.info(String.format("Indexing suspension not activated (context: '%1$s')", activationEvent.name()));
            return;
        }
        if (activationEvent != ActivationEvent.TEMPLATE_RENDERING_STARTED && !this.myProject.isInitialized()) {
            IndexingSuspender.reportStateError("Attempt to suspend indexing when project is not yet initialised. Ignoring.");
            return;
        }
        this.myActivated = true;
        this.myDeactivationEvent = deactivationEvent;
        BatchUpdatesUtil.startBatchUpdate(this.myProject);
    }

    private void ensureDeactivated() {
        if (!this.canActivate() || !this.myActivated) {
            return;
        }
        BatchUpdatesUtil.finishBatchUpdate(this.myProject);
        this.clearStateConditions();
        this.myActivated = false;
    }

    private boolean canActivate() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return false;
        }
        if (!((Boolean)StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get()).booleanValue()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        return !application.isUnitTestMode() && !application.isHeadlessEnvironment() || this.myTestingIndexingSuspender;
    }

    private void clearStateConditions() {
        this.myDeactivationEvent = null;
    }

    private static enum DeactivationEvent {
        SYNC_FINISHED,
        BUILD_FINISHED,
        TEMPLATE_RENDERING_FINISHED;

    }

    private static enum ActivationEvent {
        SYNC_TASK_CREATED,
        SYNC_STARTED,
        SETUP_STARTED,
        BUILD_EXECUTOR_CREATED,
        BUILD_STARTED,
        TEMPLATE_RENDERING_STARTED;

    }
}

