/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.ModuleBasedClassFileFinder;
import com.android.tools.idea.projectsystem.ClassFileFinderUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleClassFileFinder
extends ModuleBasedClassFileFinder {
    public GradleClassFileFinder(@NotNull Module module) {
        super(module);
    }

    @Override
    @Nullable
    protected VirtualFile findClassFileInModule(@NotNull Module module, @NotNull String className) {
        VirtualFile file = super.findClassFileInModule(module, className);
        if (file != null) {
            return file;
        }
        AndroidModuleModel model2 = AndroidModuleModel.get(module);
        if (model2 == null) {
            return null;
        }
        for (VirtualFile outputDir : GradleClassFileFinder.getCompilerOutputRoots(model2)) {
            file = ClassFileFinderUtil.findClassFileInOutputRoot(outputDir, className);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model2) {
        File outFolder;
        File file;
        IdeVariant variant = model2.getSelectedVariant();
        String variantName = variant.getName();
        IdeAndroidArtifact mainArtifactInfo = model2.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput((AndroidArtifact)mainArtifactInfo);
            file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, "classes");
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            listBuilder.add((Object)file);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file2 == null) continue;
            listBuilder.add((Object)file2);
        }
        return listBuilder.build();
    }
}

