/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarHandler
extends ActionBarCallback {
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";
    private static final Pattern MENU_FIELD_PATTERN = Pattern.compile("R\\.menu\\.([a-z0-9_]+)");
    @Nullable
    private final Object myCredential;
    @NotNull
    private RenderTask myRenderTask;
    @Nullable
    private List<ResourceReference> myMenus;
    private static boolean ourShowMenu = false;

    ActionBarHandler(@NotNull RenderTask renderTask, @Nullable Object credential) {
        this.myRenderTask = renderTask;
        this.myCredential = credential;
    }

    public boolean getSplitActionBarWhenNarrow() {
        ActivityAttributesSnapshot attributes = this.getActivityAttributes();
        if (attributes != null) {
            return "splitActionBarWhenNarrow".equals(attributes.getUiOptions());
        }
        return false;
    }

    public static boolean isShowingMenu(@Nullable EditorDesignSurface surface) {
        return ourShowMenu;
    }

    public static boolean showMenu(boolean showMenu, @Nullable EditorDesignSurface surface, boolean repaint) {
        if (showMenu != ourShowMenu) {
            ourShowMenu = showMenu;
            if (surface != null && repaint) {
                surface.forceUserRequestedRefresh();
            }
            return true;
        }
        return false;
    }

    public boolean isOverflowPopupNeeded() {
        return ourShowMenu || this.myRenderTask.getContext().getFolderType() == ResourceFolderType.MENU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ResourceReference> getMenuIds() {
        if (this.myMenus != null) {
            return this.myMenus;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            Module module = this.myRenderTask.getContext().getModule();
            ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(module);
            if (repositoryManager != null) {
                String commaSeparatedMenus;
                ResourceNamespace namespace = repositoryManager.getNamespace();
                XmlFile xmlFile = this.myRenderTask.getXmlFile();
                String string = commaSeparatedMenus = xmlFile == null ? null : AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "menu", "http://schemas.android.com/tools");
                if (commaSeparatedMenus != null) {
                    List names = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)commaSeparatedMenus);
                    this.myMenus = new ArrayList<ResourceReference>(names.size());
                    for (String name : names) {
                        this.myMenus.add(new ResourceReference(namespace, ResourceType.MENU, name));
                    }
                } else {
                    String fqn;
                    String string2 = fqn = xmlFile == null ? null : AndroidPsiUtils.getDeclaredContextFqcn(module, xmlFile);
                    if (fqn != null) {
                        Project project = xmlFile.getProject();
                        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
                            PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
                            if (clz != null) {
                                for (PsiMethod method : clz.findMethodsByName(ON_CREATE_OPTIONS_MENU, true)) {
                                    if (method instanceof PsiCompiledElement) continue;
                                    String matchText = method.getText();
                                    Matcher matcher = MENU_FIELD_PATTERN.matcher(matchText);
                                    TreeSet<ResourceReference> menus = new TreeSet<ResourceReference>(Comparator.comparing(ResourceReference::getName));
                                    int index = 0;
                                    while (matcher.find(index)) {
                                        String name = matcher.group(1);
                                        menus.add(new ResourceReference(namespace, ResourceType.MENU, name));
                                        index = matcher.end();
                                    }
                                    if (menus.isEmpty()) continue;
                                    this.myMenus = new ArrayList<ResourceReference>(menus);
                                }
                            }
                        });
                    }
                }
            }
            if (this.myMenus == null) {
                this.myMenus = Collections.emptyList();
            }
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
        return this.myMenus;
    }

    public ActionBarCallback.HomeButtonStyle getHomeButtonStyle() {
        ActivityAttributesSnapshot attributes = this.getActivityAttributes();
        if (attributes != null && attributes.getParentActivity() != null) {
            return ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP;
        }
        return ActionBarCallback.HomeButtonStyle.NONE;
    }

    public int getNavigationMode() {
        XmlFile xmlFile = this.myRenderTask.getXmlFile();
        String navMode = StringUtil.notNullize(xmlFile == null ? null : AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "actionBarNavMode", "http://schemas.android.com/tools")).trim();
        if (navMode.equalsIgnoreCase("tabs")) {
            return 2;
        }
        if (navMode.equalsIgnoreCase("list")) {
            return 1;
        }
        return 0;
    }

    public void setMenuIds(@Nullable List<ResourceReference> menus) {
        this.myMenus = menus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ActivityAttributesSnapshot getActivityAttributes() {
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(this.myRenderTask.getContext().getModule());
            String activity = StringUtil.notNullize((String)this.myRenderTask.getContext().getConfiguration().getActivity());
            ActivityAttributesSnapshot activityAttributesSnapshot = manifest.getActivityAttributes(activity);
            return activityAttributesSnapshot;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }
}

