/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingAttributesFix
extends WriteCommandAction<Void> {
    @NotNull
    private final XmlFile myFile;
    @Nullable
    private final ResourceResolver myResourceResolver;

    public AddMissingAttributesFix(@NotNull Project project, @NotNull XmlFile file, @Nullable ResourceResolver resourceResolver) {
        super(project, "Add Size Attributes", new PsiFile[]{file});
        this.myFile = file;
        this.myResourceResolver = resourceResolver;
    }

    @NotNull
    public static List<SmartPsiElementPointer<XmlTag>> findViewsMissingSizes(@NotNull XmlFile file, @Nullable ResourceResolver resolver) {
        ArrayList missing = Lists.newArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!AddMissingAttributesFix.requiresSize(tag) || AddMissingAttributesFix.definesWidth(tag, resolver) && AddMissingAttributesFix.definesHeight(tag, resolver)) continue;
                missing.add(SmartPointerManager.createPointer((PsiElement)tag));
            }
        });
        return missing;
    }

    protected void run(@NotNull Result<Void> result2) throws Throwable {
        AddMissingAttributesFix.findViewsMissingSizes(this.myFile, this.myResourceResolver).stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).forEach(tag -> {
            if (!AddMissingAttributesFix.definesWidth(tag, this.myResourceResolver)) {
                tag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultWidth(tag));
            }
            if (!AddMissingAttributesFix.definesHeight(tag, this.myResourceResolver)) {
                tag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultHeight(tag));
            }
        });
    }

    public static boolean definesHeight(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        boolean definesHeight;
        XmlAttribute height = tag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android");
        boolean bl = definesHeight = height != null;
        if (definesHeight) {
            String value2 = height.getValue();
            if (value2 == null || value2.isEmpty()) {
                return false;
            }
            return value2.equals("wrap_content") || value2.equals("fill_parent") || value2.equals("match_parent") || value2.startsWith("@") || value2.startsWith("?") || Character.isDigit(value2.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesHeight = resourceResolver.findItemInStyle(styleValue, "layout_height", true) != null;
        }
        return definesHeight;
    }

    public static boolean definesWidth(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        boolean definesWidth;
        XmlAttribute width = tag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android");
        boolean bl = definesWidth = width != null;
        if (definesWidth) {
            String value2 = width.getValue();
            if (value2 == null || value2.isEmpty()) {
                return false;
            }
            return value2.equals("wrap_content") || value2.equals("fill_parent") || value2.equals("match_parent") || value2.startsWith("@") || value2.startsWith("?") || Character.isDigit(value2.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesWidth = resourceResolver.findItemInStyle(styleValue, "layout_width", true) != null;
        }
        return definesWidth;
    }

    @NotNull
    private static String getDefaultWidth(@NotNull XmlTag tag) {
        String parent;
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && ((parent = parentTag.getName()).equals("FrameLayout") || parent.equals("TableLayout") || parent.equals("TableRow"))) {
            return "match_parent";
        }
        return "wrap_content";
    }

    @NotNull
    private static String getDefaultHeight(@NotNull XmlTag tag) {
        String parent;
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && (parent = parentTag.getName()).equals("FrameLayout")) {
            return "match_parent";
        }
        return "wrap_content";
    }

    @Nullable
    private static XmlTag getParentTag(@NotNull XmlTag tag) {
        PsiElement parent = tag.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static boolean requiresSize(XmlTag tag) {
        String parentName;
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && ("GridLayout".equals(parentName = parentTag.getName()) || SdkConstants.FQCN_GRID_LAYOUT_V7.isEquals(parentName))) {
            return false;
        }
        String tagName = tag.getName();
        if (tagName.equals("requestFocus") || tagName.equals("merge") || tagName.equals("include")) {
            return false;
        }
        return !tagName.equals("layout") && !tagName.equals("variable") && !tagName.equals("data") && !tagName.equals("import");
    }
}

