/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GutterIconFactory {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final int RENDERING_SCALING_FACTOR = 10;

    @Nullable
    public static Icon createIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, int maxWidth, int maxHeight, @NotNull AndroidFacet facet) {
        String path = file.getPath();
        if (path.endsWith(".xml")) {
            return GutterIconFactory.createXmlIcon(file, resolver, maxWidth, maxHeight, facet);
        }
        return GutterIconFactory.createBitmapIcon(file, maxWidth, maxHeight);
    }

    @NotNull
    private static String getXmlContent(@NotNull VirtualFile file) throws IOException {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return new String(file.contentsToByteArray());
        }
        return document.getText();
    }

    @Nullable
    private static Icon createXmlIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, int maxWidth, int maxHeight, @NotNull AndroidFacet facet) {
        try {
            RetinaImageIcon retinaIcon;
            BufferedImage image;
            String xml = GutterIconFactory.getXmlContent(file);
            if (xml.contains("<vector")) {
                VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createFromMaxDimension((int)(GutterIconFactory.isRetinaEnabled() ? 2 * maxWidth : maxWidth));
                org.w3c.dom.Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) {
                    return null;
                }
                Element root = document.getDocumentElement();
                if (root == null) {
                    return null;
                }
                if (resolver != null) {
                    GutterIconFactory.replaceResourceReferences(root, resolver);
                }
                StringBuilder builder = new StringBuilder(100);
                image = VdPreview.getPreviewFromVectorDocument((VdPreview.TargetSize)imageTargetSize, (org.w3c.dom.Document)document, (StringBuilder)builder);
                if (builder.length() > 0) {
                    LOG.warn("Problems rendering " + file.getPresentableUrl() + ": " + builder);
                }
            } else {
                Dimension size;
                Configuration configuration = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(file);
                DrawableRenderer renderer = new DrawableRenderer(facet, configuration);
                image = renderer.renderDrawable(xml, size = new Dimension(maxWidth * 10, maxHeight * 10)).get();
                if (image == null) {
                    return null;
                }
                image = ImageUtils.scale((BufferedImage)image, (double)((double)maxWidth / (double)image.getWidth()), (double)((double)maxHeight / (double)image.getHeight()));
                Disposer.dispose((Disposable)renderer);
            }
            if (GutterIconFactory.isRetinaEnabled() && (retinaIcon = GutterIconFactory.getRetinaIcon(image)) != null) {
                return retinaIcon;
            }
            return new ImageIcon(image);
        }
        catch (Throwable e) {
            LOG.warn(String.format("Could not read/render icon image %1$s", file.getPresentableUrl()), e);
            return null;
        }
    }

    private static boolean isRetinaEnabled() {
        return UIUtil.isRetina();
    }

    @VisibleForTesting
    static boolean isReference(String attributeValue) {
        return ResourceUrl.parse((String)attributeValue) != null;
    }

    @VisibleForTesting
    static void replaceResourceReferences(@NotNull Node node, @NotNull RenderResources resolver) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i2 = 0; i2 < n; ++i2) {
                String resolvedValue;
                Node attribute = attributes.item(i2);
                String value2 = attribute.getNodeValue();
                if (!GutterIconFactory.isReference(value2) || GutterIconFactory.isReference(resolvedValue = ResourceHelper.resolveStringValue(resolver, value2))) continue;
                attribute.setNodeValue(resolvedValue);
            }
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            GutterIconFactory.replaceResourceReferences(node, resolver);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Icon createBitmapIcon(@NotNull VirtualFile file, int maxWidth, int maxHeight) {
        try (InputStream stream = file.getInputStream();){
            Icon icon2 = GutterIconFactory.createBitmapIcon(ImageIO.read(stream), maxWidth, maxHeight);
            return icon2;
        }
        catch (Exception e) {
            LOG.warn(String.format("Could not read icon image %1$s", file.getPresentableUrl()), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Icon createBitmapIcon(BufferedImage image, int maxWidth, int maxHeight) {
        if (image != null) {
            double scale;
            BufferedImage scaled;
            RetinaImageIcon retinaIcon;
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (GutterIconFactory.isRetinaEnabled() && (imageWidth > 2 * maxWidth || imageHeight > 2 * maxHeight) && (retinaIcon = GutterIconFactory.getRetinaIcon(scaled = ImageUtils.scale((BufferedImage)image, (double)(scale = 2.0 * Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight)), (double)scale))) != null) {
                return retinaIcon;
            }
            if (imageWidth > maxWidth || imageHeight > maxHeight) {
                scale = Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
                if (image.getType() == 13) {
                    BufferedImage bg = UIUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                    Graphics g = bg.getGraphics();
                    g.setColor(Gray.TRANSPARENT);
                    g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                    UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                    g.dispose();
                    image = bg;
                }
                image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
            }
            return new ImageIcon(image);
        }
        return null;
    }

    @Nullable
    private static RetinaImageIcon getRetinaIcon(@NotNull BufferedImage image) {
        BufferedImage hdpiImage;
        if (GutterIconFactory.isRetinaEnabled() && (hdpiImage = ImageUtils.convertToRetina((BufferedImage)image)) != null) {
            return new RetinaImageIcon((Image)hdpiImage);
        }
        return null;
    }

    private static class RetinaImageIcon
    extends ImageIcon {
        private RetinaImageIcon(Image image) {
            super(image, "");
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            UIUtil.drawImage((Graphics)g, (Image)this.getImage(), (int)x, (int)y, null);
        }
    }
}

